/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.pufferfish_unofficial_additions.rewards;

import de.cadentem.pufferfish_unofficial_additions.PUA;
import de.cadentem.pufferfish_unofficial_additions.misc.ModificationHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.reward.Reward;
import net.puffish.skillsmod.api.reward.RewardConfigContext;
import net.puffish.skillsmod.api.reward.RewardDisposeContext;
import net.puffish.skillsmod.api.reward.RewardUpdateContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import org.jetbrains.annotations.NotNull;

public class EffectReward
implements Reward {
    public static final ResourceLocation ID = PUA.location("effect");
    public static final Map<UUID, List<Data>> DATA = new HashMap<UUID, List<Data>>();
    private static final DurationModification EMPTY_DURATION_MODIFICATION = new DurationModification(Operation.NONE, 0.0);
    private final MobEffect effect;
    private final Type type;
    private final DurationModification durationModification;
    private final int amplifier;

    private EffectReward(MobEffect effect, Type type, DurationModification durationModification, int amplifier) {
        this.effect = effect;
        this.type = type;
        this.durationModification = durationModification;
        this.amplifier = amplifier;
    }

    public static void register() {
        SkillsAPI.registerReward((ResourceLocation)ID, EffectReward::parse);
    }

    public static boolean isImmune(UUID uuid, MobEffect effect, int amplifier) {
        return EffectReward.getData(uuid).stream().anyMatch(data -> data.type == Type.IMMUNE && data.effect == effect && amplifier <= data.amplifier);
    }

    private static Result<EffectReward, Problem> parse(RewardConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(EffectReward::parse);
    }

    private static Result<EffectReward, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional effect = rootObject.get("effect").andThen(BuiltinJson::parseEffect).ifFailure(problems::add).getSuccess();
        Optional typeRaw = rootObject.getString("type").ifFailure(problems::add).getSuccess();
        Optional amplifierOptional = rootObject.getInt("amplifier").ifFailure(problems::add).getSuccess();
        if (typeRaw.isPresent()) {
            Type type = Type.get((String)typeRaw.get());
            DurationModification durationModification = EMPTY_DURATION_MODIFICATION;
            if (type == Type.MODIFY && rootObject.getJson().has("duration_modification")) {
                String data;
                Optional durationModificationRaw = rootObject.getString("duration_modification").ifFailure(problems::add).getSuccess();
                if (durationModificationRaw.isPresent() && !(data = (String)durationModificationRaw.get()).isBlank()) {
                    durationModification = new DurationModification(Operation.get(data.substring(0, 1)), Double.parseDouble(data.substring(1)));
                }
            }
            if (amplifierOptional.isPresent()) {
                int amplifier = (Integer)amplifierOptional.get();
                if (!(amplifier >= 0 && amplifier <= 255 || type != Type.GRANT && type != Type.IMMUNE)) {
                    problems.add(Problem.message((String)"The amplifier has to be between 0 and 255"));
                }
                if (problems.isEmpty()) {
                    return Result.success((Object)new EffectReward((MobEffect)effect.orElseThrow(), type, durationModification, amplifier));
                }
            }
        }
        return Result.failure((Object)Problem.combine(problems));
    }

    public static boolean shouldRemove(UUID uuid, MobEffect effect, int amplifier) {
        return EffectReward.getData(uuid).stream().anyMatch(data -> data.type == Type.GRANT && data.effect == effect && data.amplifier == amplifier);
    }

    public static void applyEffects(ServerPlayer player) {
        EffectReward.getData(player.m_20148_()).stream().filter(data -> data.type == Type.GRANT).forEach(data -> {
            MobEffectInstance instance = player.m_21124_(data.effect);
            if (instance != null && instance.m_19564_() > data.amplifier && instance.m_267577_()) {
                return;
            }
            EffectReward.addEffect(player, data);
        });
    }

    public static MobEffectInstance modifyEffect(ServerPlayer player, MobEffectInstance instance) {
        if (!instance.m_267577_() && !((ModificationHandler)instance).pufferfish_unofficial_additions$wasModified()) {
            MobEffect effect = instance.m_19544_();
            int modifiedDuration = EffectReward.getModifiedDuration(player.m_20148_(), effect, instance.m_19557_());
            int modifiedAmplifier = EffectReward.getModifiedAmplifier(player.m_20148_(), effect, instance.m_19564_());
            if (modifiedAmplifier >= 0 && modifiedDuration > 0 && (instance.m_19557_() != modifiedDuration || instance.m_19564_() != modifiedAmplifier)) {
                MobEffectInstance modifiedInstance = new MobEffectInstance(effect, modifiedDuration, modifiedAmplifier, instance.m_19571_(), instance.m_19572_(), instance.m_19575_());
                ((ModificationHandler)modifiedInstance).pufferfish_unofficial_additions$setModified(true);
                return modifiedInstance;
            }
        }
        return instance;
    }

    private static int getModifiedDuration(UUID uuid, MobEffect effect, int duration) {
        List<Data> modifications = EffectReward.getData(uuid).stream().filter(data -> data.type == Type.MODIFY && data.effect == effect).toList();
        for (Data data2 : modifications) {
            DurationModification modification = data2.durationModification;
            if (modification == EMPTY_DURATION_MODIFICATION) continue;
            duration = switch (modification.operation) {
                case Operation.ADD -> (int)((double)duration + modification.amount);
                case Operation.SUBTRACT -> (int)((double)duration - modification.amount);
                case Operation.MULTIPLY -> (int)((double)duration * modification.amount);
                case Operation.DIVIDE -> {
                    if (modification.amount != 0.0) {
                        yield (int)((double)duration / modification.amount);
                    }
                    yield duration;
                }
                default -> duration;
            };
        }
        return Math.max(0, duration);
    }

    private static int getModifiedAmplifier(UUID uuid, MobEffect effect, int amplifier) {
        List<Data> modifications = EffectReward.getData(uuid).stream().filter(data -> data.type == Type.MODIFY && data.effect == effect).toList();
        for (Data data2 : modifications) {
            amplifier += data2.amplifier;
        }
        return amplifier;
    }

    public static void clearData(UUID uuid) {
        DATA.remove(uuid);
    }

    public void update(RewardUpdateContext context) {
        ServerPlayer player = context.getPlayer();
        int count = context.getCount();
        List<Data> data = EffectReward.getData(player.m_20148_());
        if (count == 0) {
            data.removeIf(this::matches);
            if (this.type == Type.GRANT) {
                this.removeEffect(player);
            }
        } else {
            int i;
            int active = count;
            for (i = 0; i < data.size(); ++i) {
                Data entry = data.get(i);
                if (!this.matches(entry)) continue;
                if (active == 0) {
                    data.remove(i);
                    --i;
                    continue;
                }
                --active;
            }
            for (i = 0; i < active; ++i) {
                data.add(new Data(this.effect, this.type, this.durationModification, this.amplifier));
            }
            if (this.type == Type.GRANT) {
                EffectReward.addEffect(player, new Data(this.effect, this.type, this.durationModification, this.amplifier));
            }
        }
    }

    public void dispose(RewardDisposeContext context) {
        context.getServer().m_6846_().m_11314_().forEach(player -> {
            EffectReward.getData(player.m_20148_()).removeIf(this::matches);
            if (this.type == Type.GRANT) {
                this.removeEffect((ServerPlayer)player);
            }
        });
    }

    private static List<Data> getData(UUID uuid) {
        return DATA.computeIfAbsent(uuid, key -> new ArrayList());
    }

    private void removeEffect(ServerPlayer player) {
        MobEffectInstance instance = player.m_21124_(this.effect);
        if (instance != null && instance.m_267577_() && this.matches(instance)) {
            player.m_21195_(this.effect);
        }
    }

    private static void addEffect(ServerPlayer player, Data data) {
        player.m_7292_(new MobEffectInstance(data.effect, -1, data.amplifier, false, false));
    }

    private boolean matches(Data data) {
        return data.effect == this.effect && data.type == this.type && data.durationModification == this.durationModification && data.amplifier == this.amplifier;
    }

    private boolean matches(@NotNull MobEffectInstance instance) {
        return instance.m_19544_() == this.effect && instance.m_19564_() == this.amplifier;
    }

    public static enum Type {
        GRANT,
        MODIFY,
        IMMUNE;


        public static Type get(String type) {
            return switch (type.toLowerCase()) {
                case "grant" -> GRANT;
                case "immune" -> IMMUNE;
                case "modify" -> MODIFY;
                default -> throw new IllegalArgumentException("Supplied invalid type: " + type);
            };
        }
    }

    public record DurationModification(Operation operation, double amount) {
    }

    public static enum Operation {
        ADD("+"),
        SUBTRACT("-"),
        MULTIPLY("x"),
        DIVIDE("/"),
        NONE("");

        private final String key;

        private Operation(String key) {
            this.key = key;
        }

        public static Operation get(String key) {
            for (Operation operation : Operation.values()) {
                if (!operation.key.equals(key)) continue;
                return operation;
            }
            return NONE;
        }
    }

    public record Data(MobEffect effect, Type type, DurationModification durationModification, int amplifier) {
    }
}

