/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.part.edge;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.init.CBMicroblockModContent;
import codechicken.microblock.part.MicroblockPart;
import codechicken.microblock.part.MicroblockPartFactory;
import codechicken.microblock.part.edge.EdgeMicroFactory;
import codechicken.microblock.part.face.FaceMicroblockPart;
import codechicken.microblock.util.MaskedCuboid;
import codechicken.microblock.util.MicroOcclusionHelper;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.NormalOcclusionPart;
import codechicken.multipart.api.part.PartialOcclusionPart;
import java.util.List;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PostMicroblockPart
extends MicroblockPart
implements PartialOcclusionPart,
NormalOcclusionPart {
    public static final Cuboid6[] aBounds = new Cuboid6[256];
    public static final VoxelShape[] aShapes = new VoxelShape[256];
    @Nullable
    public Cuboid6 renderBounds1 = null;
    @Nullable
    public Cuboid6 renderBounds2 = null;

    public PostMicroblockPart(MicroMaterial material) {
        super(material);
    }

    @Override
    public MicroblockPartFactory getMicroFactory() {
        return (MicroblockPartFactory)CBMicroblockModContent.POST_MICROBLOCK_PART.get();
    }

    @Override
    public Cuboid6 getBounds() {
        return aBounds[this.shape];
    }

    @Override
    public VoxelShape getShape(CollisionContext context) {
        return aShapes[this.shape];
    }

    @Override
    public int getItemFactoryId() {
        return ((EdgeMicroFactory)CBMicroblockModContent.EDGE_MICROBLOCK_PART.get()).factoryId;
    }

    @Override
    public Iterable<MaskedCuboid> getRenderCuboids(boolean isInventory) {
        if (isInventory) {
            return List.of(new MaskedCuboid(this.getBounds(), 0));
        }
        MaskedCuboid a = new MaskedCuboid(this.renderBounds1, 0);
        if (this.renderBounds2 == null) {
            return List.of(a);
        }
        return List.of(a, new MaskedCuboid(this.renderBounds2, 0));
    }

    @Override
    public VoxelShape getOcclusionShape() {
        return this.getShape(CollisionContext.m_82749_());
    }

    @Override
    public VoxelShape getPartialOcclusionShape() {
        return this.getOcclusionShape();
    }

    @Override
    public boolean occlusionTest(MultiPart nPart) {
        FaceMicroblockPart facePart;
        if (nPart instanceof PostMicroblockPart) {
            PostMicroblockPart post = (PostMicroblockPart)nPart;
            return post.getShapeSlot() != this.getShapeSlot();
        }
        if (nPart instanceof FaceMicroblockPart && (facePart = (FaceMicroblockPart)nPart).getSlot() >> 1 == this.getShapeSlot()) {
            return true;
        }
        return NormalOcclusionPart.super.occlusionTest(nPart);
    }

    @Override
    public void onPartChanged(@Nullable MultiPart part) {
        super.onPartChanged(part);
        if (this.level().f_46443_) {
            this.recalcBounds();
        }
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (this.level().f_46443_) {
            this.recalcBounds();
        }
    }

    @Override
    public void readUpdate(MCDataInput packet) {
        super.readUpdate(packet);
        if (this.level().f_46443_) {
            this.recalcBounds();
        }
    }

    public void recalcBounds() {
        this.renderBounds1 = this.getBounds().copy();
        this.renderBounds2 = null;
        this.shrinkFace(this.getShapeSlot() << 1);
        this.shrinkFace(this.getShapeSlot() << 1 | 1);
        for (MultiPart part : this.tile().getPartList()) {
            if (!(part instanceof PostMicroblockPart)) continue;
            PostMicroblockPart post = (PostMicroblockPart)part;
            this.shrinkPost(post);
        }
    }

    private void shrinkFace(int fSide) {
        MultiPart multiPart = this.tile().getSlottedPart(fSide);
        if (multiPart instanceof FaceMicroblockPart) {
            FaceMicroblockPart fPart = (FaceMicroblockPart)multiPart;
            MicroOcclusionHelper.shrink(this.renderBounds1, fPart.getBounds(), fSide);
        }
    }

    private void shrinkPost(PostMicroblockPart post) {
        if (post == this) {
            return;
        }
        if (this.thisShrinks(post)) {
            if (this.renderBounds2 == null) {
                this.renderBounds2 = this.getBounds().copy();
            }
            MicroOcclusionHelper.shrink(this.renderBounds1, post.getBounds(), this.getShapeSlot() << 1 | 1);
            MicroOcclusionHelper.shrink(this.renderBounds2, post.getBounds(), this.getShapeSlot() << 1);
        }
    }

    private boolean thisShrinks(PostMicroblockPart other) {
        if (this.getSize() != other.getSize()) {
            return this.getSize() < other.getSize();
        }
        if (this.isTransparent() != other.isTransparent()) {
            return this.isTransparent();
        }
        return this.getShapeSlot() > other.getShapeSlot();
    }

    static {
        for (int s = 0; s < 3; ++s) {
            Transformation tr = Rotation.sideRotations[s << 1].at(Vector3.CENTER);
            for (int t = 2; t < 8; t += 2) {
                double d1 = 0.5 - (double)t / 16.0;
                double d2 = 0.5 + (double)t / 16.0;
                int i = t << 4 | s;
                PostMicroblockPart.aBounds[i] = new Cuboid6(d1, 0.0, d1, d2, 1.0, d2).apply(tr);
                PostMicroblockPart.aShapes[i] = VoxelShapeCache.getShape((Cuboid6)aBounds[i]);
            }
        }
    }
}

