/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public final class BlueprintSurfaceRules
extends SurfaceRules {
    public static final DeferredRegister<Codec<? extends SurfaceRules.RuleSource>> RULE_SOURCES = DeferredRegister.create((ResourceKey)Registries.f_256815_, (String)"blueprint");
    public static final RegistryObject<Codec<? extends SurfaceRules.RuleSource>> TRANSIENT_MERGED = RULE_SOURCES.register("transient_merged", () -> TransientMergedRuleSource.CODEC.f_216232_());

    public record TransientMergedRuleSource(List<SurfaceRules.RuleSource> sequence, SurfaceRules.RuleSource original) implements SurfaceRules.RuleSource
    {
        public static final KeyDispatchDataCodec<SurfaceRules.RuleSource> CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)SurfaceRules.RuleSource.f_189682_.xmap(source -> source, source -> {
            SurfaceRules.RuleSource ruleSource;
            if (source instanceof TransientMergedRuleSource) {
                TransientMergedRuleSource transientMergedRuleSource = (TransientMergedRuleSource)source;
                ruleSource = transientMergedRuleSource.original;
            } else {
                ruleSource = source;
            }
            return ruleSource;
        }).fieldOf("original_source"));

        public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> m_213795_() {
            return CODEC;
        }

        public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
            if (this.sequence.size() == 1) {
                return (SurfaceRules.SurfaceRule)this.sequence.get(0).apply((Object)context);
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (SurfaceRules.RuleSource ruleSource : this.sequence) {
                builder.add((Object)((SurfaceRules.SurfaceRule)ruleSource.apply((Object)context)));
            }
            return new SequenceRule((List<SurfaceRules.SurfaceRule>)builder.build());
        }
    }

    private record SequenceRule(List<SurfaceRules.SurfaceRule> rules) implements SurfaceRules.SurfaceRule
    {
        @Nullable
        public BlockState m_183550_(int x, int y, int z) {
            for (SurfaceRules.SurfaceRule surfaceRule : this.rules) {
                BlockState blockstate = surfaceRule.m_183550_(x, y, z);
                if (blockstate == null) continue;
                return blockstate;
            }
            return null;
        }
    }
}

