/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.client;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.uv.IconTransformation;
import codechicken.microblock.api.MicroMaterial;
import javax.annotation.Nullable;
import mrtjp.projectred.expansion.client.TubeModelBuilder;
import mrtjp.projectred.expansion.part.BaseTubePart;
import mrtjp.projectred.expansion.part.RedstoneTubePart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class TubeModelRenderer {
    private static final CCModel[] pipeModels = new CCModel[64];
    private static final CCModel[] redstoneWireModels = new CCModel[64];

    private static int modelKey(int connMap) {
        return connMap;
    }

    private static int modelKey(BaseTubePart pipe) {
        return TubeModelRenderer.modelKey(pipe.getConnMap());
    }

    public static CCModel getOrGeneratePipeModel(int key) {
        CCModel model = pipeModels[key];
        if (model == null) {
            TubeModelRenderer.pipeModels[key] = model = new TubeModelBuilder().setModelKey(key).build();
        }
        return model;
    }

    public static CCModel getOrGenerateWireModel(int key) {
        CCModel model = redstoneWireModels[key];
        if (model == null) {
            TubeModelRenderer.redstoneWireModels[key] = model = new TubeModelBuilder().setWireMode(true).setModelKey(key).build();
        }
        return model;
    }

    public static void render(CCRenderState ccrs, BaseTubePart pipe) {
        int n;
        RedstoneTubePart rpp;
        boolean hasRs;
        boolean bl = hasRs = pipe instanceof RedstoneTubePart && (rpp = (RedstoneTubePart)pipe).hasRedstone();
        if (pipe instanceof RedstoneTubePart) {
            RedstoneTubePart rpp2 = (RedstoneTubePart)pipe;
            n = rpp2.getSignal();
        } else {
            n = 0;
        }
        int signal = n;
        TubeModelRenderer.render(ccrs, TubeModelRenderer.modelKey(pipe), pipe.getIcon(), pipe.getMaterial(), hasRs, signal);
    }

    public static void render(CCRenderState ccrs, int modelKey, TextureAtlasSprite icon, @Nullable MicroMaterial material, boolean hasRedstone, int signal) {
        IconTransformation uvt = new IconTransformation(icon);
        if (material != null) {
            // empty if block
        }
        TubeModelRenderer.getOrGeneratePipeModel(modelKey).render(ccrs, new IVertexOperation[]{uvt});
        if (hasRedstone) {
            int c = (signal & 0xFF) / 2 + 60 << 24 | 0xFF;
            TubeModelRenderer.getOrGenerateWireModel(modelKey).render(ccrs, new IVertexOperation[]{uvt, ColourMultiplier.instance((int)c)});
        }
    }

    public static void renderInventory(CCRenderState ccrs, TextureAtlasSprite icon, Transformation transformation) {
        IconTransformation uvt = new IconTransformation(icon);
        TubeModelRenderer.getOrGeneratePipeModel(TubeModelRenderer.modelKey(3)).render(ccrs, new IVertexOperation[]{uvt, transformation});
    }
}

