/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.inventory.container;

import codechicken.lib.inventory.container.ICCLContainerFactory;
import mrtjp.projectred.expansion.init.ExpansionMenus;
import mrtjp.projectred.expansion.tile.DeployerBlockEntity;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DeployerMenu
extends AbstractContainerMenu {
    public static final ICCLContainerFactory<DeployerMenu> FACTORY = (windowId, playerInv, packet) -> {
        BlockEntity tile = playerInv.f_35978_.m_9236_().m_7702_(packet.readPos());
        if (!(tile instanceof DeployerBlockEntity)) {
            return null;
        }
        DeployerBlockEntity dbe = (DeployerBlockEntity)tile;
        return new DeployerMenu(playerInv, dbe, windowId);
    };
    private final DeployerBlockEntity tile;
    private final Inventory playerInventory;

    public DeployerMenu(Inventory playerInventory, DeployerBlockEntity tile, int windowId) {
        super((MenuType)ExpansionMenus.DEPLOYER_MENU.get(), windowId);
        this.playerInventory = playerInventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory((Inventory)playerInventory, (int)8, (int)86, x$0 -> this.m_38897_((Slot)x$0));
        this.addDeployerInventory();
    }

    private void addDeployerInventory() {
        InventoryLib.addInventory((Container)this.tile.getInventory(), (int)0, (int)62, (int)18, (int)3, (int)3, x$0 -> this.m_38897_((Slot)x$0));
    }

    public boolean m_6875_(Player player) {
        return Container.m_272074_((BlockEntity)this.tile, (Player)player);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack originalStack = stack.m_41777_();
        if (this.isStorage(slotIndex) ? !this.moveToEntireInventory(stack, true) : !this.moveToStorage(stack, false)) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == originalStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return originalStack;
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isStorage(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 45;
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 27, reverse);
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 27, 36, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 36, reverse);
    }

    private boolean moveToStorage(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 36, 45, reverse);
    }
}

