/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.sculkhornid.core.item.custom;

import java.util.List;
import net.anvian.anvianslib.util.LibUtil;
import net.anvian.sculkhornid.core.config.ModConfigs;
import net.anvian.sculkhornid.core.item.custom.SculkHorn;
import net.anvian.sculkhornid.core.util.Helper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SculkHornArea
extends SculkHorn {
    float RADIUS = (float)ModConfigs.areaRadius;
    int SPEED_DURATION = ModConfigs.areaSpeedDuration;
    int SPEED_AMPLIFIER = ModConfigs.areaSpeedAmplifier;

    public SculkHornArea(Item.Properties properties) {
        super(properties, (float)ModConfigs.areaDamage, ModConfigs.areaCooldown, ModConfigs.areaExperienceLevel, ModConfigs.areaRemoveExperience);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level level, List<Component> list, TooltipFlag tooltipFlag) {
        if (Screen.m_96638_()) {
            list.add(Math.min(1, list.size()), (Component)Component.m_237119_().m_130946_(String.valueOf(Math.abs(this.REMOVE_EXPERIENCE))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tooltip.experience")).m_130940_(ChatFormatting.DARK_GREEN));
            list.add(Math.min(1, list.size()), (Component)Component.m_237119_().m_130946_(String.valueOf(this.RADIUS)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tooltip.radius")).m_130940_(ChatFormatting.DARK_GREEN));
            list.add(Math.min(1, list.size()), (Component)Component.m_237119_().m_130946_(String.valueOf(LibUtil.ticksToSeconds((int)this.COOLDOWN))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tooltip.cooldown")).m_130940_(ChatFormatting.DARK_GREEN));
            list.add(Math.min(1, list.size()), (Component)Component.m_237119_().m_130946_(String.valueOf(this.DAMAGE)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tooltip.damage")).m_130940_(ChatFormatting.DARK_GREEN));
        } else {
            list.add(Math.min(1, list.size()), (Component)Component.m_237115_((String)"tooltip_info_item.sculkhorn_shif"));
        }
        list.add(Math.min(1, list.size()), (Component)Component.m_237119_());
        list.add(Math.min(1, list.size()), (Component)Component.m_237115_((String)"tootip_sculkhorn_area"));
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (!level.f_46443_ && (player.f_36078_ >= this.EXPERIENCE_LEVEL || player.m_7500_())) {
            if (!player.m_7500_()) {
                player.m_6756_(this.REMOVE_EXPERIENCE);
                itemstack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(interactionHand));
            }
            SculkHornArea.sonicBoom((LivingEntity)player, (LivingEntity)player, this.RADIUS);
            Helper.causeMagicExplosionAttack(level, (LivingEntity)player, (LivingEntity)player, this.DAMAGE, this.RADIUS);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, this.SPEED_DURATION, this.SPEED_AMPLIFIER));
            if (ModConfigs.bothInCooldown) {
                this.applyCooldownToBothHorns(player);
            } else {
                player.m_36335_().m_41524_((Item)this, this.COOLDOWN);
            }
        }
        if (level.f_46443_ && (player.f_36078_ >= this.EXPERIENCE_LEVEL || player.m_7500_())) {
            level.m_6269_(player, (Entity)player, SoundEvents.f_215771_, SoundSource.RECORDS, 1.0f, 1.0f);
        }
        if (player.f_36078_ < this.EXPERIENCE_LEVEL && !player.m_7500_()) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    private static void sonicBoom(LivingEntity attacker, LivingEntity victim, float radius) {
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(victim.m_9236_(), victim.m_20185_(), victim.m_20186_() + 0.25, victim.m_20189_());
        areaEffectCloud.m_19718_(attacker);
        areaEffectCloud.m_19724_((ParticleOptions)ParticleTypes.f_235902_);
        areaEffectCloud.m_19712_(radius);
        areaEffectCloud.m_19734_(0);
        attacker.m_9236_().m_7967_((Entity)areaEffectCloud);
    }
}

