/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common;

import mekanism.api.providers.IItemProvider;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.tools.common.config.MekanismToolsConfig;
import mekanism.tools.common.config.ToolsConfig;
import mekanism.tools.common.registries.ToolsItems;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.living.MobSpawnEvent;

public class MobEquipmentHelper {
    private static final GearType REFINED_GLOWSTONE = new GearType((IItemProvider)ToolsItems.REFINED_GLOWSTONE_SWORD, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_SHOVEL, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_HELMET, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_CHESTPLATE, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_LEGGINGS, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_BOOTS, MekanismToolsConfig.tools.refinedGlowstoneSpawnRate);
    private static final GearType LAPIS_LAZULI = new GearType((IItemProvider)ToolsItems.LAPIS_LAZULI_SWORD, (IItemProvider)ToolsItems.LAPIS_LAZULI_SHOVEL, (IItemProvider)ToolsItems.LAPIS_LAZULI_HELMET, (IItemProvider)ToolsItems.LAPIS_LAZULI_CHESTPLATE, (IItemProvider)ToolsItems.LAPIS_LAZULI_LEGGINGS, (IItemProvider)ToolsItems.LAPIS_LAZULI_BOOTS, MekanismToolsConfig.tools.lapisLazuliSpawnRate);
    private static final GearType REFINED_OBSIDIAN = new GearType((IItemProvider)ToolsItems.REFINED_OBSIDIAN_SWORD, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_SHOVEL, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_HELMET, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_CHESTPLATE, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_LEGGINGS, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_BOOTS, MekanismToolsConfig.tools.refinedObsidianSpawnRate);
    private static final GearType STEEL = new GearType((IItemProvider)ToolsItems.STEEL_SWORD, (IItemProvider)ToolsItems.STEEL_SHOVEL, (IItemProvider)ToolsItems.STEEL_HELMET, (IItemProvider)ToolsItems.STEEL_CHESTPLATE, (IItemProvider)ToolsItems.STEEL_LEGGINGS, (IItemProvider)ToolsItems.STEEL_BOOTS, MekanismToolsConfig.tools.steelSpawnRate);
    private static final GearType BRONZE = new GearType((IItemProvider)ToolsItems.BRONZE_SWORD, (IItemProvider)ToolsItems.BRONZE_SHOVEL, (IItemProvider)ToolsItems.BRONZE_HELMET, (IItemProvider)ToolsItems.BRONZE_CHESTPLATE, (IItemProvider)ToolsItems.BRONZE_LEGGINGS, (IItemProvider)ToolsItems.BRONZE_BOOTS, MekanismToolsConfig.tools.bronzeSpawnRate);
    private static final GearType OSMIUM = new GearType((IItemProvider)ToolsItems.OSMIUM_SWORD, (IItemProvider)ToolsItems.OSMIUM_SHOVEL, (IItemProvider)ToolsItems.OSMIUM_HELMET, (IItemProvider)ToolsItems.OSMIUM_CHESTPLATE, (IItemProvider)ToolsItems.OSMIUM_LEGGINGS, (IItemProvider)ToolsItems.OSMIUM_BOOTS, MekanismToolsConfig.tools.osmiumSpawnRate);

    private static boolean isZombie(LivingEntity entity) {
        return entity instanceof Zombie && !(entity instanceof Drowned) && !(entity instanceof ZombifiedPiglin);
    }

    public static void onLivingSpecialSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        boolean isZombie = MobEquipmentHelper.isZombie((LivingEntity)entity);
        if (isZombie || entity instanceof Skeleton || entity instanceof Stray || entity instanceof Piglin) {
            RandomSource random = event.getLevel().m_213780_();
            boolean isHard = event.getDifficulty().m_19048_() == Difficulty.HARD;
            float difficultyMultiplier = event.getDifficulty().m_19057_();
            GearType gearType = null;
            if (random.m_188501_() < MekanismToolsConfig.tools.armorSpawnChance.get() * difficultyMultiplier) {
                gearType = MobEquipmentHelper.getGearType(entity instanceof Piglin ? 0 : random.m_188503_(6));
                MobEquipmentHelper.setEntityArmorWithChance(random, (LivingEntity)entity, isHard, difficultyMultiplier, gearType);
            }
            if (isZombie) {
                CachedFloatValue spawnChance;
                CachedFloatValue cachedFloatValue = spawnChance = isHard ? MekanismToolsConfig.tools.weaponSpawnChanceHard : MekanismToolsConfig.tools.weaponSpawnChance;
                if (random.m_188501_() < spawnChance.get()) {
                    if (gearType == null) {
                        gearType = MobEquipmentHelper.getGearType(random.m_188503_(6));
                    }
                    if (gearType.spawnChance.canSpawnWeapon.get()) {
                        IItemProvider weapon = random.m_188501_() < gearType.spawnChance.swordWeight.get() ? gearType.sword : gearType.shovel;
                        MobEquipmentHelper.setStackIfEmpty((LivingEntity)entity, random, gearType.spawnChance.weaponEnchantmentChance.get(), difficultyMultiplier, EquipmentSlot.MAINHAND, weapon);
                    }
                }
            }
        }
    }

    private static GearType getGearType(int type) {
        return switch (type) {
            default -> REFINED_GLOWSTONE;
            case 1 -> LAPIS_LAZULI;
            case 2 -> REFINED_OBSIDIAN;
            case 3 -> STEEL;
            case 4 -> BRONZE;
            case 5 -> OSMIUM;
        };
    }

    private static void setEntityArmorWithChance(RandomSource random, LivingEntity entity, boolean isHard, float difficultyMultiplier, GearType gearType) {
        float stopChance;
        ToolsConfig.ArmorSpawnChanceConfig chanceConfig = gearType.spawnChance();
        float f = stopChance = isHard ? chanceConfig.multiplePieceChanceHard.get() : chanceConfig.multiplePieceChance.get();
        if (random.m_188501_() < chanceConfig.bootsChance.get()) {
            MobEquipmentHelper.setStackIfEmpty(entity, random, chanceConfig.armorEnchantmentChance.get(), difficultyMultiplier, EquipmentSlot.FEET, gearType.boots);
            if (random.m_188501_() < stopChance) {
                return;
            }
        }
        if (random.m_188501_() < chanceConfig.leggingsChance.get()) {
            MobEquipmentHelper.setStackIfEmpty(entity, random, chanceConfig.armorEnchantmentChance.get(), difficultyMultiplier, EquipmentSlot.LEGS, gearType.leggings);
            if (random.m_188501_() < stopChance) {
                return;
            }
        }
        if (random.m_188501_() < chanceConfig.chestplateChance.get()) {
            MobEquipmentHelper.setStackIfEmpty(entity, random, chanceConfig.armorEnchantmentChance.get(), difficultyMultiplier, EquipmentSlot.CHEST, gearType.chestplate);
            if (random.m_188501_() < stopChance) {
                return;
            }
        }
        if (random.m_188501_() < chanceConfig.helmetChance.get()) {
            MobEquipmentHelper.setStackIfEmpty(entity, random, chanceConfig.armorEnchantmentChance.get(), difficultyMultiplier, EquipmentSlot.HEAD, gearType.helmet);
        }
    }

    private static void setStackIfEmpty(LivingEntity entity, RandomSource random, float baseChance, float difficultyMultiplier, EquipmentSlot slot, IItemProvider item) {
        if (entity.m_6844_(slot).m_41619_()) {
            ItemStack stack = item.getItemStack();
            if (random.m_188501_() < baseChance * difficultyMultiplier) {
                stack = EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)stack, (int)((int)(5.0f + difficultyMultiplier * (float)random.m_188503_(18))), (boolean)false);
            }
            entity.m_8061_(slot, stack);
        }
    }

    private record GearType(IItemProvider sword, IItemProvider shovel, IItemProvider helmet, IItemProvider chestplate, IItemProvider leggings, IItemProvider boots, ToolsConfig.ArmorSpawnChanceConfig spawnChance) {
    }
}

