/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.block;

import com.enderio.api.conduit.ConduitType;
import com.enderio.api.integration.IntegrationManager;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.conduits.common.conduit.ConduitBlockItem;
import com.enderio.conduits.common.conduit.ConduitBundle;
import com.enderio.conduits.common.conduit.ConduitGraphObject;
import com.enderio.conduits.common.conduit.RightClickAction;
import com.enderio.conduits.common.conduit.block.ConduitBlockEntity;
import com.enderio.conduits.common.conduit.connection.ConnectionState;
import com.enderio.conduits.common.conduit.connection.DynamicConnectionState;
import com.enderio.conduits.common.conduit.connection.StaticConnectionStates;
import com.enderio.conduits.common.conduit.type.redstone.RedstoneConduitData;
import com.enderio.conduits.common.init.ConduitBlockEntities;
import com.enderio.conduits.common.init.EIOConduitTypes;
import com.enderio.conduits.common.items.ConduitProbeItem;
import com.enderio.conduits.common.network.ConduitSavedData;
import com.enderio.conduits.common.redstone.RedstoneInsertFilter;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class ConduitBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final boolean ENABLE_FACADES = false;

    public ConduitBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.BLOCK;
    }

    public boolean m_5946_(BlockState pState, Fluid pFluid) {
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ConduitBlockEntity) {
            ConduitBlockEntity conduit = (ConduitBlockEntity)blockEntity;
            conduit.updateConnections(level, pos, fromPos, true);
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ConduitBlockEntities.CONDUIT.create(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof ConduitBlockEntity) {
            ConduitBlockEntity conduit = (ConduitBlockEntity)be;
            return conduit.getShape().getTotalShape();
        }
        return Shapes.m_83144_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof ConduitBlockEntity) {
            Optional<InteractionResult> interactionResult;
            ConduitBlockEntity conduit = (ConduitBlockEntity)be;
            if (!player.m_21120_(hand).m_41619_()) {
                interactionResult = this.handleProbe(player.m_21120_(hand));
                if (interactionResult.isPresent()) {
                    return interactionResult.get();
                }
                interactionResult = this.addConduit(conduit, player, player.m_21120_(hand), level.m_5776_());
                if (interactionResult.isPresent()) {
                    return interactionResult.get();
                }
                interactionResult = this.handleYeta(conduit, player, player.m_21120_(hand), hit, level.m_5776_());
                if (interactionResult.isPresent()) {
                    return interactionResult.get();
                }
                interactionResult = this.handleFacade(conduit, player, player.m_21120_(hand), hit, level.m_5776_());
                if (interactionResult.isPresent()) {
                    return interactionResult.get();
                }
                if (player.m_21120_(hand).m_41720_() instanceof ConduitBlockItem) {
                    return super.m_6227_(state, level, pos, player, hand, hit);
                }
            }
            if ((interactionResult = this.handleScreen(conduit, player, hit, level.m_5776_())).isPresent()) {
                return interactionResult.get();
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    private Optional<InteractionResult> handleProbe(ItemStack stack) {
        if (!(stack.m_41720_() instanceof ConduitProbeItem)) {
            return Optional.empty();
        }
        return Optional.of(InteractionResult.FAIL);
    }

    private Optional<InteractionResult> addConduit(ConduitBlockEntity conduit, Player player, ItemStack stack, boolean isClientSide) {
        InteractionResult result;
        Item item = stack.m_41720_();
        if (!(item instanceof ConduitBlockItem)) {
            return Optional.empty();
        }
        ConduitBlockItem conduitBlockItem = (ConduitBlockItem)item;
        RightClickAction action = conduit.addType(conduitBlockItem.getType(), player);
        if (!(action instanceof RightClickAction.Blocked)) {
            conduit.m_58904_().m_46597_(conduit.m_58899_(), conduit.m_58900_());
        }
        if (action instanceof RightClickAction.Upgrade) {
            RightClickAction.Upgrade upgradeAction = (RightClickAction.Upgrade)action;
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
                player.m_150109_().m_150079_(upgradeAction.getNotInConduit().getConduitItem().m_7968_());
            }
            result = InteractionResult.m_19078_((boolean)isClientSide);
        } else if (action instanceof RightClickAction.Insert) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            result = InteractionResult.m_19078_((boolean)isClientSide);
        } else {
            result = InteractionResult.FAIL;
        }
        if (result != InteractionResult.FAIL) {
            Level level = conduit.m_58904_();
            BlockPos blockpos = conduit.m_58899_();
            BlockState blockState = level.m_8055_(blockpos);
            SoundType soundtype = blockState.getSoundType((LevelReader)level, blockpos, (Entity)player);
            level.m_5594_(player, blockpos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            level.m_220407_(GameEvent.f_157797_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
        }
        return Optional.of(result);
    }

    private Optional<InteractionResult> handleYeta(ConduitBlockEntity conduit, Player player, ItemStack stack, BlockHitResult hit, boolean isClientSide) {
        if (stack.m_204117_(EIOTags.Items.WRENCH)) {
            @Nullable ConduitType<?> type = conduit.getShape().getConduit(hit.m_82425_(), (HitResult)hit);
            @Nullable Direction direction = conduit.getShape().getDirection(hit.m_82425_(), (HitResult)hit);
            if (type == null) {
                return Optional.empty();
            }
            if (isClientSide) {
                return Optional.of(InteractionResult.m_19078_((boolean)isClientSide));
            }
            if (direction != null) {
                ConnectionState connectionState = conduit.getBundle().getConnectionState(direction, type);
                if (connectionState instanceof DynamicConnectionState) {
                    DynamicConnectionState dyn = (DynamicConnectionState)connectionState;
                    conduit.getBundle().getNodeFor(type).clearState(direction);
                    conduit.dropConnection(dyn);
                    conduit.getBundle().setConnectionState(direction, type, StaticConnectionStates.DISABLED);
                    conduit.updateShape();
                    conduit.updateConnectionToData(type);
                } else {
                    conduit.getBundle().setConnectionState(direction, type, StaticConnectionStates.DISABLED);
                    conduit.updateShape();
                    conduit.updateConnectionToData(type);
                    BlockEntity blockEntity = conduit.m_58904_().m_7702_(conduit.m_58899_().m_121945_(direction));
                    if (blockEntity instanceof ConduitBlockEntity) {
                        ConduitBlockEntity other = (ConduitBlockEntity)blockEntity;
                        other.getBundle().setConnectionState(direction.m_122424_(), type, StaticConnectionStates.DISABLED);
                        other.updateShape();
                        other.updateConnectionToData(type);
                        ConduitGraphObject<?> thisNode = conduit.getBundle().getNodeFor(type);
                        ConduitGraphObject<?> otherNode = other.getBundle().getNodeFor(type);
                        thisNode.getGraph().removeSingleEdge(thisNode, otherNode);
                        thisNode.getGraph().removeSingleEdge(otherNode, thisNode);
                        ConduitSavedData.addPotentialGraph(type, thisNode.getGraph(), (ServerLevel)conduit.m_58904_());
                        ConduitSavedData.addPotentialGraph(type, otherNode.getGraph(), (ServerLevel)other.m_58904_());
                    }
                }
            } else {
                ConnectionState connectionState = conduit.getBundle().getConnectionState(hit.m_82434_(), type);
                if (connectionState == StaticConnectionStates.DISABLED) {
                    conduit.tryConnectTo(hit.m_82434_(), type, true, true);
                }
            }
            return Optional.of(InteractionResult.m_19078_((boolean)isClientSide));
        }
        return Optional.empty();
    }

    @SubscribeEvent
    public static void handleShiftYeta(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity blockEntity;
        if (event.getItemStack().m_204117_(EIOTags.Items.WRENCH) && (blockEntity = event.getLevel().m_7702_(event.getPos())) instanceof ConduitBlockEntity) {
            ConduitType<?> type;
            ConduitBlockEntity conduit = (ConduitBlockEntity)blockEntity;
            if (event.getEntity().m_20161_() && (type = conduit.getShape().getConduit(event.getPos(), (HitResult)event.getHitVec())) != null) {
                conduit.removeTypeAndDelete(event.getEntity(), type);
                event.setCanceled(true);
            }
        }
    }

    private Optional<InteractionResult> handleFacade(ConduitBlockEntity conduit, Player player, ItemStack stack, BlockHitResult hit, boolean isClientSide) {
        Optional facade = IntegrationManager.findFirst(integration -> integration.getFacadeOf(stack));
        if (facade.isPresent()) {
            // empty if block
        }
        return Optional.empty();
    }

    private Optional<InteractionResult> handleScreen(ConduitBlockEntity conduit, Player player, BlockHitResult hit, boolean isClientSide) {
        Optional<OpenInformation> openInformation = this.getOpenInformation(conduit, hit);
        if (openInformation.isPresent()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)conduit.menuProvider(openInformation.get().direction(), openInformation.get().type()), buf -> {
                    buf.m_130064_(conduit.m_58899_());
                    buf.m_130068_((Enum)((OpenInformation)openInformation.get()).direction());
                    buf.writeInt(EIOConduitTypes.getConduitId(((OpenInformation)openInformation.get()).type()));
                });
            }
            return Optional.of(InteractionResult.m_19078_((boolean)isClientSide));
        }
        return Optional.empty();
    }

    private Optional<OpenInformation> getOpenInformation(ConduitBlockEntity conduit, BlockHitResult hit) {
        @Nullable ConduitType<?> type = conduit.getShape().getConduit(hit.m_82425_(), (HitResult)hit);
        @Nullable Direction direction = conduit.getShape().getDirection(hit.m_82425_(), (HitResult)hit);
        if (direction != null && type != null && ConduitBlock.canBeOrIsValidConnection(conduit, type, direction)) {
            return Optional.of(new OpenInformation(direction, type));
        }
        if (type != null && ConduitBlock.canBeValidConnection(conduit, type, direction = hit.m_82434_())) {
            return Optional.of(new OpenInformation(direction, type));
        }
        if (type != null) {
            for (Direction potential : Direction.values()) {
                if (!ConduitBlock.canBeValidConnection(conduit, type, potential)) continue;
                return Optional.of(new OpenInformation(potential, type));
            }
        }
        ConduitBundle bundle = conduit.getBundle();
        for (Direction potential : Direction.values()) {
            if (!bundle.isConnectionEnd(potential)) continue;
            for (ConduitType<?> potentialType : bundle.getTypes()) {
                if (!(bundle.getConnectionState(potential, potentialType) instanceof DynamicConnectionState)) continue;
                return Optional.of(new OpenInformation(potential, potentialType));
            }
            throw new IllegalStateException("couldn't find connection even though it should be present");
        }
        for (Direction potential : Direction.values()) {
            if (conduit.m_58904_().m_7702_(conduit.m_58899_().m_121945_(potential)) instanceof ConduitBlockEntity) continue;
            for (ConduitType<?> potentialType : bundle.getTypes()) {
                if (!ConduitBlock.canBeValidConnection(conduit, potentialType, potential)) continue;
                return Optional.of(new OpenInformation(potential, potentialType));
            }
        }
        return Optional.empty();
    }

    public static boolean canBeOrIsValidConnection(ConduitBlockEntity conduit, ConduitType<?> type, Direction direction) {
        ConduitBundle bundle = conduit.getBundle();
        return bundle.getConnectionState(direction, type) instanceof DynamicConnectionState || ConduitBlock.canBeValidConnection(conduit, type, direction);
    }

    public static boolean canBeValidConnection(ConduitBlockEntity conduit, ConduitType<?> type, Direction direction) {
        StaticConnectionStates state;
        ConduitBundle bundle = conduit.getBundle();
        ConnectionState connectionState = bundle.getConnectionState(direction, type);
        return connectionState instanceof StaticConnectionStates && (state = (StaticConnectionStates)connectionState) == StaticConnectionStates.DISABLED && !(conduit.m_58904_().m_7702_(conduit.m_58899_().m_121945_(direction)) instanceof ConduitBlockEntity);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ConduitBlockEntity conduit;
        ConduitType<?> type;
        BlockEntity hitResult;
        if (level instanceof Level) {
            Level realLevel = (Level)level;
            if (state.m_61145_((Property)BlockStateProperties.f_61362_).orElse(false).booleanValue()) {
                hitResult = Item.m_41435_((Level)realLevel, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
                if (hitResult.m_6662_() == HitResult.Type.MISS) {
                    return Items.f_41852_.m_7968_();
                }
                if (hitResult.m_82425_().equals((Object)pos)) {
                    target = hitResult;
                } else {
                    return level.m_8055_(hitResult.m_82425_()).getCloneItemStack((HitResult)hitResult, level, hitResult.m_82425_(), player);
                }
            }
        }
        if ((hitResult = level.m_7702_(pos)) instanceof ConduitBlockEntity && (type = (conduit = (ConduitBlockEntity)hitResult).getShape().getConduit(pos, target)) != null) {
            return type.getConduitItem().m_7968_();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (level1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof ConduitBlockEntity) {
                ConduitBlockEntity conduitBlockEntity = (ConduitBlockEntity)blockEntity;
                conduitBlockEntity.everyTick();
            }
        };
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        ConduitBlockItem item = (ConduitBlockItem)stack.m_41720_();
        if (placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ConduitBlockEntity) {
                ConduitBlockEntity conduit = (ConduitBlockEntity)blockEntity;
                conduit.addType(item.getType(), player);
                if (!level.m_5776_()) {
                    conduit.updateClient();
                }
            }
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        HitResult hit = player.m_19907_(player.getBlockReach() + 5.0, 1.0f, false);
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof ConduitBlockEntity) {
            ConduitBlockEntity conduit = (ConduitBlockEntity)be;
            @Nullable ConduitType<?> conduitType = conduit.getShape().getConduit(((BlockHitResult)hit).m_82425_(), hit);
            if (conduitType == null) {
                if (!conduit.getBundle().getTypes().isEmpty()) {
                    level.m_5594_(player, pos, SoundEvents.f_11916_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return false;
                }
                return true;
            }
            SoundType soundtype = state.getSoundType((LevelReader)level, pos, (Entity)player);
            level.m_5594_(player, pos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            if (conduit.removeType(conduitType, !player.m_150110_().f_35937_)) {
                return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
            }
            level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
            return false;
        }
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        ConduitBlockEntity conduit;
        BlockEntity blockEntity;
        return direction != null && (blockEntity = level.m_7702_(pos)) instanceof ConduitBlockEntity && (conduit = (ConduitBlockEntity)blockEntity).getBundle().getTypes().contains(EIOConduitTypes.REDSTONE.get()) && conduit.getBundle().getConnectionState(direction.m_122424_(), (ConduitType)EIOConduitTypes.REDSTONE.get()) instanceof DynamicConnectionState;
    }

    public int m_6378_(BlockState pBlockState, BlockGetter level, BlockPos pos, Direction direction) {
        DynamicConnectionState dyn;
        ConduitBlockEntity conduit;
        Object object = level.m_7702_(pos);
        return object instanceof ConduitBlockEntity && (conduit = (ConduitBlockEntity)((Object)object)).getBundle().getTypes().contains(EIOConduitTypes.REDSTONE.get()) && (object = conduit.getBundle().getConnectionState(direction.m_122424_(), (ConduitType)EIOConduitTypes.REDSTONE.get())) instanceof DynamicConnectionState && (dyn = (DynamicConnectionState)object).isInsert() ? this.getSignalOutput(dyn, (RedstoneConduitData)conduit.getBundle().getNodeFor((ConduitType)EIOConduitTypes.REDSTONE.get()).getConduitData()) : 0;
    }

    private int getSignalOutput(DynamicConnectionState dyn, RedstoneConduitData data) {
        return dyn.filterInsert().getCapability(EIOCapabilities.FILTER).filter(filter -> filter instanceof RedstoneInsertFilter).map(filter -> ((RedstoneInsertFilter)filter).getOutputSignal(data, dyn.insertChannel())).orElse(data.getSignal(dyn.insertChannel()));
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
    }

    private record OpenInformation(Direction direction, ConduitType<?> type) {
    }
}

