/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.integrations.mekanism;

import com.enderio.api.conduit.ColoredRedstoneProvider;
import com.enderio.api.conduit.ConduitGraph;
import com.enderio.api.conduit.ConduitType;
import com.enderio.conduits.common.integrations.mekanism.ChemicalConduitData;
import com.enderio.conduits.common.integrations.mekanism.MultiCapabilityAwareConduitTicker;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.slurry.ISlurryHandler;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.capabilities.Capability;

public class ChemicalTicker
extends MultiCapabilityAwareConduitTicker<ChemicalConduitData, IChemicalHandler<?, ?>> {
    private final int rate;

    @SafeVarargs
    public ChemicalTicker(int rate, Capability<? extends IChemicalHandler<?, ?>> ... capabilities) {
        super(capabilities);
        this.rate = rate;
    }

    private int getScaledTransferRate() {
        return (int)Math.ceil((double)this.rate * (20.0 / (double)this.getTickRate()));
    }

    @Override
    protected void tickCapabilityGraph(ConduitType<ChemicalConduitData> type, List<MultiCapabilityAwareConduitTicker.CapabilityConnection<ChemicalConduitData, IChemicalHandler<?, ?>>> insertCaps, List<MultiCapabilityAwareConduitTicker.CapabilityConnection<ChemicalConduitData, IChemicalHandler<?, ?>>> extractCaps, ServerLevel level, ConduitGraph<ChemicalConduitData> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        for (MultiCapabilityAwareConduitTicker.CapabilityConnection<ChemicalConduitData, IChemicalHandler<?, ?>> extract : extractCaps) {
            this.tickExtractCapability(extract.capability(), extract.data(), insertCaps);
        }
    }

    private <C extends Chemical<C>, S extends ChemicalStack<C>> void tickExtractCapability(IChemicalHandler<C, S> extractHandler, ChemicalConduitData chemicalExtendedData, List<MultiCapabilityAwareConduitTicker.CapabilityConnection<ChemicalConduitData, IChemicalHandler<?, ?>>> insertCaps) {
        ChemicalStack result;
        int transferRate = this.getScaledTransferRate();
        ChemicalType extractType = this.getTypeFor(extractHandler);
        if (!chemicalExtendedData.lockedChemical.isEmpty()) {
            if (chemicalExtendedData.lockedChemical.getChemicalType() != extractType) {
                return;
            }
            result = extractHandler.extractChemical(chemicalExtendedData.lockedChemical.getChemical().getStack((long)transferRate), Action.SIMULATE);
        } else {
            result = extractHandler.extractChemical((long)transferRate, Action.SIMULATE);
        }
        if (result.isEmpty()) {
            return;
        }
        long transferred = 0L;
        for (MultiCapabilityAwareConduitTicker.CapabilityConnection<ChemicalConduitData, IChemicalHandler<?, ?>> insert : insertCaps) {
            Object transferredChemical;
            ChemicalType insertType = this.getTypeFor(insert.capability());
            if (extractType != insertType) continue;
            IChemicalHandler<?, ?> destinationHandler = insert.capability();
            if ((transferred += (transferredChemical = !chemicalExtendedData.lockedChemical.isEmpty() ? (Object)ChemicalTicker.tryChemicalTransfer(destinationHandler, extractHandler, chemicalExtendedData.lockedChemical.getChemical().getStack((long)transferRate - transferred), true) : ChemicalTicker.tryChemicalTransfer(destinationHandler, extractHandler, (long)transferRate - transferred, true)).getAmount()) < (long)transferRate) continue;
            break;
        }
    }

    private ChemicalType getTypeFor(IChemicalHandler<?, ?> handler) {
        if (handler instanceof IGasHandler) {
            return ChemicalType.GAS;
        }
        if (handler instanceof IInfusionHandler) {
            return ChemicalType.INFUSION;
        }
        if (handler instanceof IPigmentHandler) {
            return ChemicalType.PIGMENT;
        }
        if (handler instanceof ISlurryHandler) {
            return ChemicalType.SLURRY;
        }
        throw new IllegalStateException("Unknown chemical handler type");
    }

    private static <C extends Chemical<C>, S extends ChemicalStack<C>> S tryChemicalTransfer(IChemicalHandler<C, S> chemicalDestination, IChemicalHandler<C, S> chemicalSource, long maxAmount, boolean doTransfer) {
        ChemicalStack drainable = chemicalSource.extractChemical(maxAmount, Action.SIMULATE);
        if (!drainable.isEmpty()) {
            return (S)ChemicalTicker.tryChemicalTransfer_Internal(chemicalDestination, chemicalSource, drainable, doTransfer);
        }
        return (S)chemicalSource.getEmptyStack();
    }

    private static <C extends Chemical<C>, S extends ChemicalStack<C>> S tryChemicalTransfer(IChemicalHandler<C, S> chemicalDestination, IChemicalHandler<C, S> chemicalSource, S resource, boolean doTransfer) {
        ChemicalStack drainable = chemicalSource.extractChemical(resource, Action.SIMULATE);
        if (!drainable.isEmpty() && resource.equals((Object)drainable)) {
            return (S)ChemicalTicker.tryChemicalTransfer_Internal(chemicalDestination, chemicalSource, drainable, doTransfer);
        }
        return (S)chemicalSource.getEmptyStack();
    }

    private static <C extends Chemical<C>, S extends ChemicalStack<C>> S tryChemicalTransfer_Internal(IChemicalHandler<C, S> chemicalDestination, IChemicalHandler<C, S> chemicalSource, S drainable, boolean doTransfer) {
        long fillableAmount = drainable.getAmount() - chemicalDestination.insertChemical(drainable, Action.SIMULATE).getAmount();
        if (fillableAmount > 0L) {
            drainable.setAmount(fillableAmount);
            if (doTransfer) {
                ChemicalStack drained = chemicalSource.extractChemical(drainable, Action.EXECUTE);
                if (!drained.isEmpty()) {
                    drained.setAmount(chemicalDestination.insertChemical(drained, Action.EXECUTE).getAmount());
                    return (S)drained;
                }
            } else {
                return drainable;
            }
        }
        return (S)chemicalSource.getEmptyStack();
    }
}

