/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.redstone;

import com.enderio.api.misc.ColorControl;
import com.enderio.conduits.common.conduit.type.redstone.RedstoneConduitData;
import com.enderio.conduits.common.redstone.RedstoneInsertFilter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class RedstoneTLatchFilter
implements RedstoneInsertFilter {
    private static final String KEY_ACTIVE = "Active";
    private static final String KEY_DEACTIVATED = "Deactivated";
    private final ItemStack stack;

    public RedstoneTLatchFilter(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public int getOutputSignal(RedstoneConduitData data, ColorControl control) {
        boolean active1 = this.isActive();
        if (data.isActive(control) && this.isDeactivated()) {
            active1 = !active1;
            this.setState(active1, false);
        }
        if (!data.isActive(control)) {
            this.setState(active1, true);
        }
        return active1 ? 15 : 0;
    }

    public boolean isActive() {
        CompoundTag tag = this.stack.m_41784_();
        return tag.m_128441_(KEY_ACTIVE) && tag.m_128471_(KEY_ACTIVE);
    }

    public boolean isDeactivated() {
        CompoundTag tag = this.stack.m_41784_();
        return !tag.m_128441_(KEY_DEACTIVATED) || tag.m_128471_(KEY_ACTIVE);
    }

    public void setState(boolean active, boolean deactivated) {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128379_(KEY_ACTIVE, active);
        tag.m_128379_(KEY_DEACTIVATED, deactivated);
    }
}

