/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.redstone;

import com.enderio.conduits.common.redstone.RedstoneExtractFilter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class RedstoneTimerFilter
implements RedstoneExtractFilter {
    private static final String KEY_TICKS = "Ticks";
    private static final String KEY_MAX_TICKS = "MaxTicks";
    private final ItemStack stack;

    public RedstoneTimerFilter(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public int getInputSignal(Level level, BlockPos pos, Direction direction) {
        int ticks = this.getTicks();
        int maxTicks = this.getMaxTicks();
        if ((ticks += 2) >= maxTicks) {
            ticks = 0;
            this.setTimer(ticks, maxTicks);
            return 15;
        }
        this.setTimer(ticks, maxTicks);
        return 0;
    }

    public int getMaxTicks() {
        CompoundTag tag = this.stack.m_41784_();
        return tag.m_128441_(KEY_TICKS) ? tag.m_128451_(KEY_TICKS) : 20;
    }

    public int getTicks() {
        CompoundTag tag = this.stack.m_41784_();
        return tag.m_128441_(KEY_MAX_TICKS) ? tag.m_128451_(KEY_MAX_TICKS) : 0;
    }

    public void setTimer(int ticks, int maxTicks) {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128405_(KEY_TICKS, ticks);
        tag.m_128405_(KEY_MAX_TICKS, maxTicks);
    }

    public void setMaxTicks(int maxTicks) {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128405_(KEY_MAX_TICKS, maxTicks);
    }
}

