/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Pair;
import kotlin.collections.MapsKt__MapWithDefaultKt;
import kotlin.collections.builders.MapBuilder;
import kotlin.jvm.internal.Intrinsics;

abstract class MapsKt__MapsJVMKt
extends MapsKt__MapWithDefaultKt {
    public static Map mapOf(Pair pair) {
        Pair pair2 = pair;
        Intrinsics.checkNotNullParameter(pair2, "pair");
        Map<Object, Object> map = Collections.singletonMap(pair2.getFirst(), pair.getSecond());
        Intrinsics.checkNotNullExpressionValue(map, "singletonMap(pair.first, pair.second)");
        return map;
    }

    public static Map createMapBuilder() {
        return new MapBuilder();
    }

    public static Map build(Map map) {
        Map map2 = map;
        Intrinsics.checkNotNullParameter(map2, "builder");
        return ((MapBuilder)map2).build();
    }

    public static SortedMap toSortedMap(Map map) {
        Intrinsics.checkNotNullParameter(map, "<this>");
        return new TreeMap(map);
    }

    public static SortedMap toSortedMap(Map map, Comparator comparator) {
        Intrinsics.checkNotNullParameter(map, "<this>");
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        TreeMap treeMap = new TreeMap(comparator);
        treeMap.putAll(map);
        return treeMap;
    }

    public static final Map toSingletonMap(Map object) {
        Map map = object;
        Intrinsics.checkNotNullParameter(map, "<this>");
        object = map.entrySet().iterator().next();
        Map map2 = Collections.singletonMap(object.getKey(), object.getValue());
        Intrinsics.checkNotNullExpressionValue(map2, "with(entries.iterator().\u2026ingletonMap(key, value) }");
        return map2;
    }

    public static int mapCapacity(int n) {
        if (n >= 0) {
            n = n < 3 ? ++n : (n < 0x40000000 ? (int)((float)n / 0.75f + 1.0f) : Integer.MAX_VALUE);
        }
        return n;
    }
}

