/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.path;

import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

final class PathRelativizer {
    public static final PathRelativizer INSTANCE = new PathRelativizer();
    private static final Path emptyPath = Paths.get("", new String[0]);
    private static final Path parentPath = Paths.get("..", new String[0]);

    private PathRelativizer() {
    }

    public final Path tryRelativeTo(Path path, Path path2) {
        Path path3 = path2;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(path3, "base");
        Object object = path3.normalize();
        path = path.normalize();
        path2 = object.relativize(path);
        int n = Math.min(object.getNameCount(), path.getNameCount());
        for (int i = 0; i < n; ++i) {
            Path path4 = parentPath;
            if (!Intrinsics.areEqual(object.getName(i), path4)) break;
            if (Intrinsics.areEqual(path.getName(i), path4)) {
                continue;
            }
            throw new IllegalArgumentException("Unable to compute relative path");
        }
        if (Intrinsics.areEqual(path, object) || !Intrinsics.areEqual(object, emptyPath)) {
            object = ((Object)path2).toString();
            String string = path2.getFileSystem().getSeparator();
            Intrinsics.checkNotNullExpressionValue(string, "rn.fileSystem.separator");
            path = StringsKt.endsWith$default((String)object, string, false, 2, null) ? path2.getFileSystem().getPath(StringsKt.dropLast((String)object, path2.getFileSystem().getSeparator().length()), new String[0]) : path2;
        }
        Path path5 = path;
        Intrinsics.checkNotNullExpressionValue(path5, "r");
        return path5;
    }
}

