/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeReference$Companion;
import kotlin.jvm.internal.TypeReference$WhenMappings;
import kotlin.jvm.internal.TypeReference$asString$args$1;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;

public final class TypeReference
implements KType {
    public static final TypeReference$Companion Companion = new TypeReference$Companion(null);
    private final KClassifier classifier;
    private final List arguments;
    private final KType platformTypeUpperBound;
    private final int flags;

    public TypeReference(KClassifier kClassifier, List list, KType kType, int n) {
        Intrinsics.checkNotNullParameter(kClassifier, "classifier");
        Intrinsics.checkNotNullParameter(list, "arguments");
        this.classifier = kClassifier;
        this.arguments = list;
        this.platformTypeUpperBound = kType;
        this.flags = n;
    }

    public TypeReference(KClassifier kClassifier, List list, boolean bl) {
        TypeReference typeReference = typeReference2;
        Intrinsics.checkNotNullParameter(kClassifier, "classifier");
        Intrinsics.checkNotNullParameter(list, "arguments");
        TypeReference typeReference2 = null;
        typeReference(kClassifier, list, typeReference2, bl ? 1 : 0);
    }

    private final String asString(boolean bl) {
        Object object;
        Object object2 = ((TypeReference)object3).getClassifier();
        object2 = object2 instanceof KClass ? (KClass)object2 : null;
        if ((object2 = object2 != null ? JvmClassMappingKt.getJavaClass((KClass)object2) : null) == null) {
            object = ((TypeReference)object3).getClassifier().toString();
        } else if ((((TypeReference)object3).flags & 4) != 0) {
            object = "kotlin.Nothing";
        } else if (((Class)object2).isArray()) {
            object = ((TypeReference)object3).getArrayClassName((Class)object2);
        } else if (bl && ((Class)object2).isPrimitive()) {
            KClassifier kClassifier = ((TypeReference)object3).getClassifier();
            Intrinsics.checkNotNull(kClassifier, "null cannot be cast to non-null type kotlin.reflect.KClass<*>");
            object = JvmClassMappingKt.getJavaObjectType((KClass)kClassifier).getName();
        } else {
            object = ((Class)object2).getName();
        }
        if (((TypeReference)object3).getArguments().isEmpty()) {
            object2 = "";
        } else {
            TypeReference$asString$args$1 typeReference$asString$args$1;
            object2 = typeReference$asString$args$1;
            typeReference$asString$args$1 = new TypeReference$asString$args$1((TypeReference)object3);
            object2 = CollectionsKt.joinToString$default(((TypeReference)object3).getArguments(), ", ", "<", ">", 0, null, (Function1)object2, 24, null);
        }
        String string = ((TypeReference)object3).isMarkedNullable() ? "?" : "";
        TypeReference typeReference = object3;
        Object object3 = (String)object + (String)object2 + string;
        object = typeReference.platformTypeUpperBound;
        if (object instanceof TypeReference && !Intrinsics.areEqual(object = ((TypeReference)object).asString(true), object3)) {
            object3 = Intrinsics.areEqual(object, (String)object3 + '?') ? (String)object3 + '!' : '(' + (String)object3 + ".." + (String)object + ')';
        }
        return object3;
    }

    private final String getArrayClassName(Class clazz) {
        return Intrinsics.areEqual(clazz, boolean[].class) ? "kotlin.BooleanArray" : (Intrinsics.areEqual(clazz, char[].class) ? "kotlin.CharArray" : (Intrinsics.areEqual(clazz, byte[].class) ? "kotlin.ByteArray" : (Intrinsics.areEqual(clazz, short[].class) ? "kotlin.ShortArray" : (Intrinsics.areEqual(clazz, int[].class) ? "kotlin.IntArray" : (Intrinsics.areEqual(clazz, float[].class) ? "kotlin.FloatArray" : (Intrinsics.areEqual(clazz, long[].class) ? "kotlin.LongArray" : (Intrinsics.areEqual(clazz, double[].class) ? "kotlin.DoubleArray" : "kotlin.Array")))))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String asString(KTypeProjection kTypeProjection) {
        int n;
        if (kTypeProjection.getVariance() == null) {
            return "*";
        }
        Object object = kTypeProjection.getType();
        if (!(object instanceof TypeReference)) {
            object = null;
        }
        if (object == null || (object = ((TypeReference)object).asString(true)) == null) {
            object = String.valueOf(kTypeProjection.getType());
        }
        if ((n = TypeReference$WhenMappings.$EnumSwitchMapping$0[kTypeProjection.getVariance().ordinal()]) == 1) return object;
        if (n == 2) return "in " + (String)object;
        if (n != 3) throw new NoWhenBranchMatchedException();
        return "out " + (String)object;
    }

    public static final /* synthetic */ String access$asString(TypeReference typeReference, KTypeProjection kTypeProjection) {
        return typeReference.asString(kTypeProjection);
    }

    @Override
    public KClassifier getClassifier() {
        return this.classifier;
    }

    @Override
    public List getArguments() {
        return this.arguments;
    }

    @Override
    public List getAnnotations() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isMarkedNullable() {
        return (this.flags & 1) != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof TypeReference)) return false;
        object = (TypeReference)object;
        if (!Intrinsics.areEqual(this.getClassifier(), ((TypeReference)object).getClassifier())) return false;
        if (!Intrinsics.areEqual(this.getArguments(), ((TypeReference)object).getArguments())) return false;
        if (!Intrinsics.areEqual(this.platformTypeUpperBound, ((TypeReference)object).platformTypeUpperBound)) return false;
        if (this.flags != ((TypeReference)object).flags) return false;
        return true;
    }

    public int hashCode() {
        return (this.getClassifier().hashCode() * 31 + ((Object)this.getArguments()).hashCode()) * 31 + ((Object)this.flags).hashCode();
    }

    public String toString() {
        return this.asString(false) + " (Kotlin reflection is not available)";
    }
}

