/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames$FqNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectAnnotationSource;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClassKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.SignatureSerializer;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass$AnnotationArgumentVisitor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass$AnnotationVisitor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass$MemberVisitor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass$MethodAnnotationVisitor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;

final class ReflectClassStructure {
    public static final ReflectClassStructure INSTANCE = new ReflectClassStructure();

    private ReflectClassStructure() {
    }

    private final void loadMethodAnnotations(Class methodArray, KotlinJvmBinaryClass$MemberVisitor kotlinJvmBinaryClass$MemberVisitor) {
        methodArray = methodArray.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue(methodArray, "klass.declaredMethods");
        for (Method method : methodArray) {
            Name name = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue(name, "identifier(method.name)");
            Method method2 = method;
            Intrinsics.checkNotNullExpressionValue(method2, "method");
            KotlinJvmBinaryClass$MethodAnnotationVisitor kotlinJvmBinaryClass$MethodAnnotationVisitor = kotlinJvmBinaryClass$MemberVisitor.visitMethod(name, SignatureSerializer.INSTANCE.methodDesc(method2));
            if (kotlinJvmBinaryClass$MethodAnnotationVisitor == null) continue;
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue(annotationArray, "method.declaredAnnotations");
            for (Annotation annotation : annotationArray) {
                Intrinsics.checkNotNullExpressionValue(annotation, "annotation");
                this.processAnnotation(kotlinJvmBinaryClass$MethodAnnotationVisitor, annotation);
            }
            Annotation[][] annotationArray2 = method.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue(annotationArray2, "method.parameterAnnotations");
            int n = annotationArray2.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] annotationArray3 = annotationArray2[i];
                Intrinsics.checkNotNullExpressionValue(annotationArray3, "annotations");
                for (Annotation annotation : annotationArray3) {
                    ReflectAnnotationSource reflectAnnotationSource;
                    Class clazz = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(annotation));
                    Object object = ReflectClassUtilKt.getClassId(clazz);
                    ReflectAnnotationSource reflectAnnotationSource2 = reflectAnnotationSource;
                    Annotation annotation2 = annotation;
                    Intrinsics.checkNotNullExpressionValue(annotation2, "annotation");
                    reflectAnnotationSource = new ReflectAnnotationSource(annotation2);
                    object = kotlinJvmBinaryClass$MethodAnnotationVisitor.visitParameterAnnotation(i, (ClassId)object, reflectAnnotationSource2);
                    if (object == null) continue;
                    INSTANCE.processAnnotationArguments((KotlinJvmBinaryClass$AnnotationArgumentVisitor)object, annotation, clazz);
                }
            }
            kotlinJvmBinaryClass$MethodAnnotationVisitor.visitEnd();
        }
    }

    private final void loadConstructorAnnotations(Class constructorArray, KotlinJvmBinaryClass$MemberVisitor kotlinJvmBinaryClass$MemberVisitor) {
        constructorArray = constructorArray.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, "klass.declaredConstructors");
        int n = constructorArray.length;
        for (int i = 0; i < n; ++i) {
            Constructor<?> constructor;
            Constructor<?> constructor2 = constructor = constructorArray[i];
            Intrinsics.checkNotNullExpressionValue(constructor2, "constructor");
            KotlinJvmBinaryClass$MethodAnnotationVisitor kotlinJvmBinaryClass$MethodAnnotationVisitor = kotlinJvmBinaryClass$MemberVisitor.visitMethod(SpecialNames.INIT, SignatureSerializer.INSTANCE.constructorDesc(constructor2));
            if (kotlinJvmBinaryClass$MethodAnnotationVisitor == null) continue;
            Annotation[] annotationArray = constructor.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue(annotationArray, "constructor.declaredAnnotations");
            for (Annotation annotation : annotationArray) {
                Intrinsics.checkNotNullExpressionValue(annotation, "annotation");
                this.processAnnotation(kotlinJvmBinaryClass$MethodAnnotationVisitor, annotation);
            }
            annotationArray = constructor.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue(annotationArray, "parameterAnnotations");
            int n2 = annotationArray.length == 0 ? 1 : 0;
            if ((n2 ^ 1) != 0) {
                int n3 = constructor.getParameterTypes().length - annotationArray.length;
                int n4 = annotationArray.length;
                for (n2 = 0; n2 < n4; ++n2) {
                    Annotation annotation;
                    annotation = annotationArray[n2];
                    Intrinsics.checkNotNullExpressionValue(annotation, "annotations");
                    int n5 = ((Annotation)annotation).length;
                    for (int j = 0; j < n5; ++j) {
                        ReflectAnnotationSource reflectAnnotationSource;
                        Annotation annotation2 = annotation[j];
                        Class clazz = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(annotation2));
                        int n6 = n2 + n3;
                        ClassId classId = ReflectClassUtilKt.getClassId(clazz);
                        Object object = reflectAnnotationSource;
                        Annotation annotation3 = annotation2;
                        Intrinsics.checkNotNullExpressionValue(annotation3, "annotation");
                        reflectAnnotationSource = new ReflectAnnotationSource(annotation3);
                        object = kotlinJvmBinaryClass$MethodAnnotationVisitor.visitParameterAnnotation(n6, classId, (SourceElement)object);
                        if (object == null) continue;
                        INSTANCE.processAnnotationArguments((KotlinJvmBinaryClass$AnnotationArgumentVisitor)object, annotation2, clazz);
                    }
                }
            }
            kotlinJvmBinaryClass$MethodAnnotationVisitor.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class fieldArray, KotlinJvmBinaryClass$MemberVisitor kotlinJvmBinaryClass$MemberVisitor) {
        fieldArray = fieldArray.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue(fieldArray, "klass.declaredFields");
        for (Field field : fieldArray) {
            Name name = Name.identifier(field.getName());
            Intrinsics.checkNotNullExpressionValue(name, "identifier(field.name)");
            Field field2 = field;
            Intrinsics.checkNotNullExpressionValue(field2, "field");
            KotlinJvmBinaryClass$AnnotationVisitor kotlinJvmBinaryClass$AnnotationVisitor = kotlinJvmBinaryClass$MemberVisitor.visitField(name, SignatureSerializer.INSTANCE.fieldDesc(field2), null);
            if (kotlinJvmBinaryClass$AnnotationVisitor == null) continue;
            Annotation[] annotationArray = field.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue(annotationArray, "field.declaredAnnotations");
            for (Annotation annotation : annotationArray) {
                Intrinsics.checkNotNullExpressionValue(annotation, "annotation");
                this.processAnnotation(kotlinJvmBinaryClass$AnnotationVisitor, annotation);
            }
            kotlinJvmBinaryClass$AnnotationVisitor.visitEnd();
        }
    }

    private final void processAnnotation(KotlinJvmBinaryClass$AnnotationVisitor object, Annotation annotation) {
        Class clazz = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(annotation));
        if ((object = object.visitAnnotation(ReflectClassUtilKt.getClassId(clazz), new ReflectAnnotationSource(annotation))) != null) {
            INSTANCE.processAnnotationArguments((KotlinJvmBinaryClass$AnnotationArgumentVisitor)object, annotation, clazz);
        }
    }

    private final void processAnnotationArguments(KotlinJvmBinaryClass$AnnotationArgumentVisitor kotlinJvmBinaryClass$AnnotationArgumentVisitor, Annotation annotation, Class methodArray) {
        methodArray = methodArray.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue(methodArray, "annotationType.declaredMethods");
        for (Method method : methodArray) {
            Object object;
            Method method2;
            try {
                method2 = method;
                object = method.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {}
            Intrinsics.checkNotNull(object);
            Name name = Name.identifier(method2.getName());
            Intrinsics.checkNotNullExpressionValue(name, "identifier(method.name)");
            this.processAnnotationArgumentValue(kotlinJvmBinaryClass$AnnotationArgumentVisitor, name, object);
        }
        kotlinJvmBinaryClass$AnnotationArgumentVisitor.visitEnd();
    }

    private final ClassLiteralValue classLiteralValue(Class object) {
        int n = 0;
        while (((Class)object).isArray()) {
            ++n;
            object = ((Class)object).getComponentType();
            Intrinsics.checkNotNullExpressionValue(object, "currentClass.componentType");
        }
        if (((Class)object).isPrimitive()) {
            if (Intrinsics.areEqual(object, Void.TYPE)) {
                ClassId classId = ClassId.topLevel(StandardNames$FqNames.unit.toSafe());
                Intrinsics.checkNotNullExpressionValue(classId, "topLevel(StandardNames.FqNames.unit.toSafe())");
                return new ClassLiteralValue(classId, n);
            }
            object = JvmPrimitiveType.get(((Class)object).getName()).getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue(object, "get(currentClass.name).primitiveType");
            if (n > 0) {
                ClassId classId = ClassId.topLevel(((PrimitiveType)((Object)object)).getArrayTypeFqName());
                Intrinsics.checkNotNullExpressionValue(classId, "topLevel(primitiveType.arrayTypeFqName)");
                return new ClassLiteralValue(classId, n - 1);
            }
            ClassId classId = ClassId.topLevel(((PrimitiveType)((Object)object)).getTypeFqName());
            Intrinsics.checkNotNullExpressionValue(classId, "topLevel(primitiveType.typeFqName)");
            return new ClassLiteralValue(classId, n);
        }
        object = ReflectClassUtilKt.getClassId(object);
        FqName fqName2 = ((ClassId)object).asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "javaClassId.asSingleFqName()");
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
        if (classId != null) {
            object = classId;
        }
        return new ClassLiteralValue((ClassId)object, n);
    }

    /*
     * WARNING - void declaration
     */
    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass$AnnotationArgumentVisitor object, Name object2, Object objectArray) {
        Class<?> clazz;
        Object[] objectArray2;
        block19: {
            block15: {
                Object[] objectArray22;
                block18: {
                    block17: {
                        block16: {
                            block14: {
                                clazz = objectArray2.getClass();
                                if (!Intrinsics.areEqual(clazz, Class.class)) break block14;
                                void v0 = objectArray2;
                                Intrinsics.checkNotNull(v0, "null cannot be cast to non-null type java.lang.Class<*>");
                                object.visitClassLiteral((Name)object2, objectArray22.classLiteralValue((Class)v0));
                                break block15;
                            }
                            if (!ReflectKotlinClassKt.access$getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT$p().contains(clazz)) break block16;
                            object.visit((Name)object2, objectArray2);
                            break block15;
                        }
                        if (!ReflectClassUtilKt.isEnumClassOrSpecializedEnumEntryClass(clazz)) break block17;
                        if (!clazz.isEnum()) {
                            clazz = clazz.getEnclosingClass();
                        }
                        Object object3 = object;
                        void v2 = objectArray2;
                        Class<?> clazz2 = clazz;
                        Intrinsics.checkNotNullExpressionValue(clazz2, "if (clazz.isEnum) clazz else clazz.enclosingClass");
                        objectArray22 = ReflectClassUtilKt.getClassId(clazz2);
                        Intrinsics.checkNotNull(v2, "null cannot be cast to non-null type kotlin.Enum<*>");
                        object = Name.identifier(((Enum)v2).name());
                        Intrinsics.checkNotNullExpressionValue(object, "identifier((value as Enum<*>).name)");
                        object3.visitEnum((Name)object2, (ClassId)objectArray22, (Name)object);
                        break block15;
                    }
                    if (!Annotation.class.isAssignableFrom(clazz)) break block18;
                    Object object4 = object;
                    Object[] objectArray3 = clazz.getInterfaces();
                    Intrinsics.checkNotNullExpressionValue(objectArray3, "clazz.interfaces");
                    object = (Class)ArraysKt.single(objectArray3);
                    Intrinsics.checkNotNullExpressionValue(object, "annotationClass");
                    KotlinJvmBinaryClass$AnnotationArgumentVisitor i = object4.visitAnnotation((Name)object2, ReflectClassUtilKt.getClassId((Class)object));
                    if (i == null) {
                        return;
                    }
                    void v6 = objectArray2;
                    Intrinsics.checkNotNull(v6, "null cannot be cast to non-null type kotlin.Annotation");
                    super.processAnnotationArguments(i, (Annotation)v6, (Class)object);
                    break block15;
                }
                if (!clazz.isArray()) break block19;
                if ((object = object.visitArray((Name)object2)) == null) {
                    return;
                }
                Class<?> clazz3 = clazz.getComponentType();
                if (clazz3.isEnum()) {
                    void v7 = objectArray2;
                    Class<?> clazz4 = clazz3;
                    Intrinsics.checkNotNullExpressionValue(clazz4, "componentType");
                    objectArray22 = ReflectClassUtilKt.getClassId(clazz4);
                    Intrinsics.checkNotNull(v7, "null cannot be cast to non-null type kotlin.Array<*>");
                    for (Object object5 : (Object[])v7) {
                        Intrinsics.checkNotNull(object5, "null cannot be cast to non-null type kotlin.Enum<*>");
                        Name name = Name.identifier(((Enum)object5).name());
                        Intrinsics.checkNotNullExpressionValue(name, "identifier((element as Enum<*>).name)");
                        object.visitEnum((ClassId)objectArray22, name);
                    }
                } else if (Intrinsics.areEqual(clazz3, Class.class)) {
                    void v10 = objectArray2;
                    Intrinsics.checkNotNull(v10, "null cannot be cast to non-null type kotlin.Array<*>");
                    for (Object object6 : (Object[])v10) {
                        Intrinsics.checkNotNull(object6, "null cannot be cast to non-null type java.lang.Class<*>");
                        object.visitClassLiteral(super.classLiteralValue((Class)object6));
                    }
                } else if (Annotation.class.isAssignableFrom(clazz3)) {
                    void v12 = objectArray2;
                    Intrinsics.checkNotNull(v12, "null cannot be cast to non-null type kotlin.Array<*>");
                    objectArray2 = (Object[])v12;
                    int n = objectArray2.length;
                    for (int i = 0; i < n; ++i) {
                        Class<?> clazz5 = clazz3;
                        Object object7 = objectArray2[i];
                        Intrinsics.checkNotNullExpressionValue(clazz5, "componentType");
                        KotlinJvmBinaryClass$AnnotationArgumentVisitor kotlinJvmBinaryClass$AnnotationArgumentVisitor = object.visitAnnotation(ReflectClassUtilKt.getClassId(clazz5));
                        if (kotlinJvmBinaryClass$AnnotationArgumentVisitor == null) continue;
                        Object object8 = object7;
                        Intrinsics.checkNotNull(object8, "null cannot be cast to non-null type kotlin.Annotation");
                        super.processAnnotationArguments(kotlinJvmBinaryClass$AnnotationArgumentVisitor, (Annotation)object8, clazz3);
                    }
                } else {
                    void var2_8;
                    void v15 = objectArray2;
                    Intrinsics.checkNotNull(v15, "null cannot be cast to non-null type kotlin.Array<*>");
                    objectArray22 = (Object[])v15;
                    boolean bl = false;
                    int n = objectArray22.length;
                    while (var2_8 < n) {
                        object.visit(objectArray22[var2_8]);
                        ++var2_8;
                    }
                }
                object.visitEnd();
            }
            return;
        }
        throw new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + objectArray2);
    }

    public final void loadClassAnnotations(Class annotationArray, KotlinJvmBinaryClass$AnnotationVisitor kotlinJvmBinaryClass$AnnotationVisitor) {
        Intrinsics.checkNotNullParameter(annotationArray, "klass");
        Intrinsics.checkNotNullParameter(kotlinJvmBinaryClass$AnnotationVisitor, "visitor");
        annotationArray = annotationArray.getDeclaredAnnotations();
        Intrinsics.checkNotNullExpressionValue(annotationArray, "klass.declaredAnnotations");
        for (Annotation annotation : annotationArray) {
            Intrinsics.checkNotNullExpressionValue(annotation, "annotation");
            this.processAnnotation(kotlinJvmBinaryClass$AnnotationVisitor, annotation);
        }
        kotlinJvmBinaryClass$AnnotationVisitor.visitEnd();
    }

    public final void visitMembers(Class clazz, KotlinJvmBinaryClass$MemberVisitor kotlinJvmBinaryClass$MemberVisitor) {
        ReflectClassStructure reflectClassStructure = this;
        Intrinsics.checkNotNullParameter(clazz, "klass");
        Intrinsics.checkNotNullParameter(kotlinJvmBinaryClass$MemberVisitor, "memberVisitor");
        reflectClassStructure.loadMethodAnnotations(clazz, kotlinJvmBinaryClass$MemberVisitor);
        reflectClassStructure.loadConstructorAnnotations(clazz, kotlinJvmBinaryClass$MemberVisitor);
        reflectClassStructure.loadFieldAnnotations(clazz, kotlinJvmBinaryClass$MemberVisitor);
    }
}

