/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.InputStream;
import java.util.ArrayList;
import kotlin.reflect.jvm.internal.impl.protobuf.BoundedByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedInputStream$RefillCallback;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedOutputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.protobuf.Internal;
import kotlin.reflect.jvm.internal.impl.protobuf.InvalidProtocolBufferException;
import kotlin.reflect.jvm.internal.impl.protobuf.LiteralByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite$Builder;
import kotlin.reflect.jvm.internal.impl.protobuf.Parser;
import kotlin.reflect.jvm.internal.impl.protobuf.Utf8;
import kotlin.reflect.jvm.internal.impl.protobuf.WireFormat;

public final class CodedInputStream {
    private final byte[] buffer;
    private final boolean bufferIsImmutable;
    private int bufferSize;
    private int bufferSizeAfterLimit;
    private int bufferPos;
    private final InputStream input;
    private int lastTag;
    private boolean enableAliasing;
    private int totalBytesRetired;
    private int currentLimit;
    private int recursionDepth;
    private int recursionLimit;
    private int sizeLimit;
    private CodedInputStream$RefillCallback refillCallback;

    public int readTag() {
        int n;
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = n = this.readRawVarint32();
        if (WireFormat.getTagFieldNumber(n) != 0) {
            return this.lastTag;
        }
        throw InvalidProtocolBufferException.invalidTag();
    }

    public void checkLastTagWas(int n) {
        if (this.lastTag == n) {
            return;
        }
        throw InvalidProtocolBufferException.invalidEndTag();
    }

    public boolean skipField(int n, CodedOutputStream codedOutputStream) {
        switch (WireFormat.getTagWireType(n)) {
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            case 5: {
                CodedOutputStream codedOutputStream2 = codedOutputStream;
                int n2 = ((CodedInputStream)((Object)byteString)).readRawLittleEndian32();
                codedOutputStream2.writeRawVarint32(n);
                codedOutputStream2.writeFixed32NoTag(n2);
                return true;
            }
            case 4: {
                return false;
            }
            case 3: {
                CodedOutputStream codedOutputStream3 = codedOutputStream;
                codedOutputStream3.writeRawVarint32(n);
                ((CodedInputStream)((Object)byteString)).skipMessage(codedOutputStream3);
                int n3 = WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4);
                ((CodedInputStream)((Object)byteString)).checkLastTagWas(n3);
                codedOutputStream.writeRawVarint32(n3);
                return true;
            }
            case 2: {
                CodedOutputStream codedOutputStream4 = codedOutputStream;
                ByteString byteString = ((CodedInputStream)((Object)byteString)).readBytes();
                codedOutputStream4.writeRawVarint32(n);
                codedOutputStream4.writeBytesNoTag(byteString);
                return true;
            }
            case 1: {
                CodedOutputStream codedOutputStream5 = codedOutputStream;
                long l = ((CodedInputStream)((Object)byteString)).readRawLittleEndian64();
                codedOutputStream5.writeRawVarint32(n);
                codedOutputStream5.writeFixed64NoTag(l);
                return true;
            }
            case 0: 
        }
        CodedOutputStream codedOutputStream6 = codedOutputStream;
        long l = ((CodedInputStream)((Object)byteString)).readInt64();
        codedOutputStream6.writeRawVarint32(n);
        codedOutputStream6.writeUInt64NoTag(l);
        return true;
    }

    public void skipMessage(CodedOutputStream codedOutputStream) {
        int n;
        while ((n = this.readTag()) != 0 && this.skipField(n, codedOutputStream)) {
        }
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public long readUInt64() {
        return this.readRawVarint64();
    }

    public long readInt64() {
        return this.readRawVarint64();
    }

    public int readInt32() {
        return this.readRawVarint32();
    }

    public long readFixed64() {
        return this.readRawLittleEndian64();
    }

    public int readFixed32() {
        return this.readRawLittleEndian32();
    }

    public boolean readBool() {
        return this.readRawVarint64() != 0L;
    }

    public String readString() {
        int n;
        int n2 = this.readRawVarint32();
        if (n2 <= this.bufferSize - (n = this.bufferPos) && n2 > 0) {
            String string;
            String string2 = string;
            string2(this.buffer, n, n2, "UTF-8");
            this.bufferPos += n2;
            return string;
        }
        if (n2 == 0) {
            return "";
        }
        return new String(this.readRawBytesSlowPath(n2), "UTF-8");
    }

    public String readStringRequireUtf8() {
        Object object;
        int n = ((CodedInputStream)object).readRawVarint32();
        CodedInputStream codedInputStream = object;
        int n2 = codedInputStream.bufferPos;
        if (n <= codedInputStream.bufferSize - n2 && n > 0) {
            CodedInputStream codedInputStream2 = object;
            object = ((CodedInputStream)object).buffer;
            codedInputStream2.bufferPos = n2 + n;
        } else {
            if (n == 0) {
                return "";
            }
            object = ((CodedInputStream)object).readRawBytesSlowPath(n);
            n2 = 0;
        }
        int n3 = n2;
        if (Utf8.isValidUtf8((byte[])object, n3, n3 + n)) {
            return new String((byte[])object, n2, n, "UTF-8");
        }
        throw InvalidProtocolBufferException.invalidUtf8();
    }

    public void readGroup(int n, MessageLite$Builder messageLite$Builder, ExtensionRegistryLite extensionRegistryLite) {
        int n2 = this.recursionDepth;
        if (n2 < this.recursionLimit) {
            CodedInputStream codedInputStream = this;
            this.recursionDepth = n2 + 1;
            messageLite$Builder.mergeFrom(this, extensionRegistryLite);
            codedInputStream.checkLastTagWas(WireFormat.makeTag(n, 4));
            --codedInputStream.recursionDepth;
            return;
        }
        throw InvalidProtocolBufferException.recursionLimitExceeded();
    }

    public void readMessage(MessageLite$Builder messageLite$Builder, ExtensionRegistryLite extensionRegistryLite) {
        CodedInputStream codedInputStream = this;
        int n = codedInputStream.readRawVarint32();
        if (codedInputStream.recursionDepth < this.recursionLimit) {
            CodedInputStream codedInputStream2 = this;
            CodedInputStream codedInputStream3 = this;
            int n2 = codedInputStream3.pushLimit(n);
            ++codedInputStream3.recursionDepth;
            messageLite$Builder.mergeFrom(codedInputStream3, extensionRegistryLite);
            codedInputStream2.checkLastTagWas(0);
            --codedInputStream2.recursionDepth;
            codedInputStream2.popLimit(n2);
            return;
        }
        throw InvalidProtocolBufferException.recursionLimitExceeded();
    }

    public MessageLite readMessage(Parser parser, ExtensionRegistryLite extensionRegistryLite) {
        CodedInputStream codedInputStream = this;
        int n = codedInputStream.readRawVarint32();
        if (codedInputStream.recursionDepth < this.recursionLimit) {
            CodedInputStream codedInputStream2 = this;
            int n2 = codedInputStream2.pushLimit(n);
            ++codedInputStream2.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(codedInputStream2, extensionRegistryLite);
            CodedInputStream codedInputStream3 = this;
            codedInputStream3.checkLastTagWas(0);
            --codedInputStream3.recursionDepth;
            this.popLimit(n2);
            return messageLite;
        }
        throw InvalidProtocolBufferException.recursionLimitExceeded();
    }

    public ByteString readBytes() {
        int n;
        int n2 = this.readRawVarint32();
        if (n2 <= this.bufferSize - (n = this.bufferPos) && n2 > 0) {
            ByteString byteString;
            if (this.bufferIsImmutable && this.enableAliasing) {
                BoundedByteString boundedByteString;
                byteString = boundedByteString;
                CodedInputStream codedInputStream = this;
                byte[] byArray = codedInputStream.buffer;
                boundedByteString = new BoundedByteString(byArray, codedInputStream.bufferPos, n2);
            } else {
                byteString = ByteString.copyFrom(this.buffer, n, n2);
            }
            this.bufferPos += n2;
            return byteString;
        }
        if (n2 == 0) {
            return ByteString.EMPTY;
        }
        return new LiteralByteString(this.readRawBytesSlowPath(n2));
    }

    public int readUInt32() {
        return this.readRawVarint32();
    }

    public int readEnum() {
        return this.readRawVarint32();
    }

    public int readSFixed32() {
        return this.readRawLittleEndian32();
    }

    public long readSFixed64() {
        return this.readRawLittleEndian64();
    }

    public int readSInt32() {
        return CodedInputStream.decodeZigZag32(this.readRawVarint32());
    }

    public long readSInt64() {
        return CodedInputStream.decodeZigZag64(this.readRawVarint64());
    }

    public int readRawVarint32() {
        int n;
        int n2;
        block6: {
            block4: {
                byte[] byArray;
                block8: {
                    long l;
                    block7: {
                        block5: {
                            CodedInputStream codedInputStream = this;
                            n2 = codedInputStream.bufferSize;
                            n = codedInputStream.bufferPos;
                            if (n2 == n) break block4;
                            byArray = this.buffer;
                            int n3 = n + 1;
                            if ((n = this.buffer[n]) >= 0) {
                                this.bufferPos = n3;
                                return n;
                            }
                            if (n2 - n3 < 9) break block4;
                            int n4 = n;
                            int n5 = n3;
                            n = n5 + 1;
                            n2 = n4 ^ byArray[n5] << 7;
                            l = n2;
                            if (l >= 0L) break block5;
                            n2 = (int)(l ^ 0xFFFFFFFFFFFFFF80L);
                            break block6;
                        }
                        if ((l = (long)(n2 ^= byArray[n++] << 14)) < 0L) break block7;
                        n2 = (int)(l ^ 0x3F80L);
                        break block6;
                    }
                    if ((l = (long)(n2 ^= byArray[n++] << 21)) >= 0L) break block8;
                    n2 = (int)(l ^ 0xFFFFFFFFFFE03F80L);
                    break block6;
                }
                byte by = byArray[n++];
                n2 = (int)((long)(n2 ^ by << 28) ^ 0xFE03F80L);
                if (by >= 0 || byArray[n++] >= 0 || byArray[n++] >= 0 || byArray[n++] >= 0 || byArray[n++] >= 0 || byArray[n++] >= 0) break block6;
            }
            return (int)this.readRawVarint64SlowPath();
        }
        this.bufferPos = n;
        return n2;
    }

    public long readRawVarint64() {
        long l;
        int n;
        block6: {
            long l2;
            block13: {
                block4: {
                    byte[] byArray;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block5: {
                                                CodedInputStream codedInputStream = this;
                                                int n2 = codedInputStream.bufferSize;
                                                n = codedInputStream.bufferPos;
                                                if (n2 == n) break block4;
                                                byArray = this.buffer;
                                                int n3 = n + 1;
                                                if ((n = this.buffer[n]) >= 0) {
                                                    this.bufferPos = n3;
                                                    return n;
                                                }
                                                if (n2 - n3 < 9) break block4;
                                                int n4 = n;
                                                int n5 = n3;
                                                n = n5 + 1;
                                                l2 = n4 ^ byArray[n5] << 7;
                                                if (l2 >= 0L) break block5;
                                                l = l2 ^ 0xFFFFFFFFFFFFFF80L;
                                                break block6;
                                            }
                                            if ((l2 ^= (long)(byArray[n++] << 14)) < 0L) break block7;
                                            l = l2 ^ 0x3F80L;
                                            break block6;
                                        }
                                        if ((l2 ^= (long)(byArray[n++] << 21)) >= 0L) break block8;
                                        l = l2 ^ 0xFFFFFFFFFFE03F80L;
                                        break block6;
                                    }
                                    if ((l2 ^= (long)byArray[n++] << 28) < 0L) break block9;
                                    l = l2 ^ 0xFE03F80L;
                                    break block6;
                                }
                                if ((l2 ^= (long)byArray[n++] << 35) >= 0L) break block10;
                                l = l2 ^ 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((l2 ^= (long)byArray[n++] << 42) < 0L) break block11;
                            l = l2 ^ 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((l2 ^= (long)byArray[n++] << 49) >= 0L) break block12;
                        l = l2 ^ 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    if ((l2 = l2 ^ (long)byArray[n++] << 56 ^ 0xFE03F80FE03F80L) >= 0L || (long)byArray[n++] >= 0L) break block13;
                }
                return this.readRawVarint64SlowPath();
            }
            l = l2;
        }
        this.bufferPos = n;
        return l;
    }

    long readRawVarint64SlowPath() {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.readRawByte();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    public int readRawLittleEndian32() {
        CodedInputStream codedInputStream = this;
        int n = codedInputStream.bufferPos;
        if (codedInputStream.bufferSize - n < 4) {
            CodedInputStream codedInputStream2 = this;
            codedInputStream2.refillBuffer(4);
            n = codedInputStream2.bufferPos;
        }
        byte[] byArray = this.buffer;
        this.bufferPos = n + 4;
        return this.buffer[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    public long readRawLittleEndian64() {
        CodedInputStream codedInputStream = this;
        int n = codedInputStream.bufferPos;
        if (codedInputStream.bufferSize - n < 8) {
            CodedInputStream codedInputStream2 = this;
            codedInputStream2.refillBuffer(8);
            n = codedInputStream2.bufferPos;
        }
        byte[] byArray = this.buffer;
        this.bufferPos = n + 8;
        return (long)this.buffer[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    public int pushLimit(int n) {
        if (n >= 0) {
            int n2 = this.currentLimit;
            if ((n += this.totalBytesRetired + this.bufferPos) <= n2) {
                this.currentLimit = n;
                this.recomputeBufferSizeAfterLimit();
                return n2;
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        throw InvalidProtocolBufferException.negativeSize();
    }

    public void popLimit(int n) {
        this.currentLimit = n;
        this.recomputeBufferSizeAfterLimit();
    }

    public int getBytesUntilLimit() {
        int n = this.currentLimit;
        if (n == Integer.MAX_VALUE) {
            return -1;
        }
        return n - (this.totalBytesRetired + this.bufferPos);
    }

    public boolean isAtEnd() {
        return this.bufferPos == this.bufferSize && !this.tryRefillBuffer(1);
    }

    public byte readRawByte() {
        if (this.bufferPos == this.bufferSize) {
            this.refillBuffer(1);
        }
        int n = this.bufferPos;
        this.bufferPos = n + 1;
        return this.buffer[n];
    }

    public void skipRawBytes(int n) {
        int n2 = this.bufferPos;
        if (n <= this.bufferSize - n2 && n >= 0) {
            this.bufferPos = n2 + n;
        } else {
            this.skipRawBytesSlowPath(n);
        }
    }

    public static CodedInputStream newInstance(InputStream inputStream2) {
        return new CodedInputStream(inputStream2);
    }

    public static int readRawVarint32(int n, InputStream inputStream2) {
        int n2;
        int n3;
        if ((n & 0x80) == 0) {
            return n;
        }
        n &= 0x7F;
        for (n3 = 7; n3 < 32; n3 += 7) {
            n2 = inputStream2.read();
            if (n2 != -1) {
                n |= (n2 & 0x7F) << n3;
                if ((n2 & 0x80) != 0) continue;
                return n;
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        while (n3 < 64) {
            n2 = inputStream2.read();
            if (n2 != -1) {
                if ((n2 & 0x80) == 0) {
                    return n;
                }
                n3 += 7;
                continue;
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long l) {
        return l >>> 1 ^ -(l & 1L);
    }

    private CodedInputStream(InputStream inputStream2) {
        CodedInputStream codedInputStream = this;
        this.enableAliasing = false;
        this.currentLimit = Integer.MAX_VALUE;
        this.recursionLimit = 64;
        this.sizeLimit = 0x4000000;
        this.refillCallback = null;
        this.buffer = new byte[4096];
        this.bufferSize = 0;
        this.bufferPos = 0;
        this.totalBytesRetired = 0;
        codedInputStream.input = inputStream2;
        codedInputStream.bufferIsImmutable = false;
    }

    private void recomputeBufferSizeAfterLimit() {
        int n;
        CodedInputStream codedInputStream = this;
        codedInputStream.bufferSize = n = codedInputStream.bufferSize + this.bufferSizeAfterLimit;
        int n2 = codedInputStream.totalBytesRetired + n;
        int n3 = this.currentLimit;
        if (n2 > n3) {
            int n4;
            this.bufferSizeAfterLimit = n4 = n2 - n3;
            this.bufferSize = n - n4;
        } else {
            this.bufferSizeAfterLimit = 0;
        }
    }

    private void ensureAvailable(int n) {
        if (this.bufferSize - this.bufferPos < n) {
            this.refillBuffer(n);
        }
    }

    private void refillBuffer(int n) {
        if (this.tryRefillBuffer(n)) {
            return;
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    private boolean tryRefillBuffer(int n) {
        int n2 = this.bufferPos;
        if (n2 + n > this.bufferSize) {
            if (this.totalBytesRetired + n2 + n > this.currentLimit) {
                return false;
            }
            CodedInputStream$RefillCallback codedInputStream$RefillCallback = this.refillCallback;
            if (codedInputStream$RefillCallback != null) {
                codedInputStream$RefillCallback.onRefill();
            }
            if (this.input != null) {
                int n3;
                int n4 = this.bufferPos;
                if (n4 > 0) {
                    n3 = this.bufferSize;
                    if (n3 > n4) {
                        System.arraycopy(this.buffer, n4, this.buffer, 0, n3 -= n4);
                    }
                    CodedInputStream codedInputStream = this;
                    codedInputStream.totalBytesRetired += n4;
                    codedInputStream.bufferSize -= n4;
                    codedInputStream.bufferPos = 0;
                }
                CodedInputStream codedInputStream = this;
                byte[] byArray = codedInputStream.buffer;
                n3 = codedInputStream.bufferSize;
                int n5 = this.input.read(byArray, n3, byArray.length - n3);
                if (n5 != 0 && n5 >= -1 && n5 <= this.buffer.length) {
                    if (n5 > 0) {
                        CodedInputStream codedInputStream2 = this;
                        codedInputStream2.bufferSize += n5;
                        if (codedInputStream2.totalBytesRetired + n - this.sizeLimit <= 0) {
                            CodedInputStream codedInputStream3 = this;
                            codedInputStream3.recomputeBufferSizeAfterLimit();
                            return codedInputStream3.bufferSize >= n ? true : this.tryRefillBuffer(n);
                        }
                        throw InvalidProtocolBufferException.sizeLimitExceeded();
                    }
                } else {
                    throw new IllegalStateException(new StringBuilder(102).append("InputStream#read(byte[]) returned invalid result: ").append(n5).append("\nThe InputStream implementation is buggy.").toString());
                }
            }
            return false;
        }
        throw new IllegalStateException(new StringBuilder(77).append("refillBuffer() called when ").append(n).append(" bytes were already available in buffer").toString());
    }

    private byte[] readRawBytesSlowPath(int n) {
        if (n <= 0) {
            if (n == 0) {
                return Internal.EMPTY_BYTE_ARRAY;
            }
            throw InvalidProtocolBufferException.negativeSize();
        }
        int n2 = ((CodedInputStream)object).totalBytesRetired;
        int n3 = ((CodedInputStream)object).bufferPos;
        int n4 = ((CodedInputStream)object).currentLimit;
        if (n2 + n3 + n <= n4) {
            int n5;
            ArrayList<byte[]> arrayList;
            if (n < 4096) {
                byte[] byArray = new byte[n];
                int n6 = n;
                CodedInputStream codedInputStream = object;
                n = codedInputStream.bufferSize - n3;
                System.arraycopy(codedInputStream.buffer, n3, byArray, 0, n);
                codedInputStream.bufferPos = codedInputStream.bufferSize;
                n3 = n6 - n;
                ((CodedInputStream)object).ensureAvailable(n3);
                System.arraycopy(((CodedInputStream)object).buffer, 0, byArray, n, n3);
                ((CodedInputStream)object).bufferPos = n3;
                return byArray;
            }
            n4 = ((CodedInputStream)object).bufferSize;
            CodedInputStream codedInputStream = object;
            codedInputStream.totalBytesRetired = n2 + n4;
            codedInputStream.bufferPos = 0;
            codedInputStream.bufferSize = 0;
            n2 = n4 - n3;
            ArrayList<byte[]> arrayList2 = arrayList;
            arrayList = new ArrayList<byte[]>();
            for (n4 = n - n2; n4 > 0; n4 -= n5) {
                int n7;
                n5 = Math.min(n4, 4096);
                byte[] byArray = new byte[n5];
                for (int i = 0; i < n5; i += n7) {
                    InputStream inputStream2 = ((CodedInputStream)object).input;
                    if (inputStream2 == null) {
                        n7 = -1;
                    } else {
                        n7 = n5 - i;
                        n7 = inputStream2.read(byArray, i, n7);
                    }
                    if (n7 != -1) {
                        ((CodedInputStream)object).totalBytesRetired += n7;
                        continue;
                    }
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                arrayList2.add(byArray);
            }
            CodedInputStream codedInputStream2 = object;
            Object object = new byte[n];
            System.arraycopy(codedInputStream2.buffer, n3, object, 0, n2);
            for (byte[] byArray : arrayList2) {
                n3 = byArray.length;
                System.arraycopy(byArray, 0, object, n2, n3);
                n2 += byArray.length;
            }
            return object;
        }
        ((CodedInputStream)object).skipRawBytes(n4 - n2 - n3);
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    private void skipRawBytesSlowPath(int n) {
        if (n >= 0) {
            int n2 = this.totalBytesRetired;
            int n3 = this.bufferPos;
            int n4 = this.currentLimit;
            if (n2 + n3 + n <= n4) {
                CodedInputStream codedInputStream = this;
                n2 = codedInputStream.bufferSize;
                n3 = n2 - n3;
                codedInputStream.bufferPos = n2;
                codedInputStream.refillBuffer(1);
                while ((n2 = n - n3) > (n4 = this.bufferSize)) {
                    n3 += n4;
                    this.bufferPos = n4;
                    this.refillBuffer(1);
                }
                this.bufferPos = n2;
                return;
            }
            this.skipRawBytes(n4 - n2 - n3);
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        throw InvalidProtocolBufferException.negativeSize();
    }
}

