/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Class;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$PackageFragment;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;

public final class ProtoBasedClassDataFinder
implements ClassDataFinder {
    private final NameResolver nameResolver;
    private final BinaryVersion metadataVersion;
    private final Function1 classSource;
    private final Map classIdToProto;

    public ProtoBasedClassDataFinder(ProtoBuf$PackageFragment protoBuf$PackageFragment, NameResolver object, BinaryVersion binaryVersion2, Function1 object2) {
        LinkedHashMap linkedHashMap;
        Intrinsics.checkNotNullParameter(protoBuf$PackageFragment, "proto");
        Intrinsics.checkNotNullParameter(object, "nameResolver");
        Intrinsics.checkNotNullParameter(binaryVersion2, "metadataVersion");
        Intrinsics.checkNotNullParameter(object2, "classSource");
        this.nameResolver = object;
        this.metadataVersion = binaryVersion2;
        this.classSource = object2;
        List list = protoBuf$PackageFragment.getClass_List();
        Intrinsics.checkNotNullExpressionValue(list, "proto.class_List");
        int n = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault(list, 10)), 16);
        object = linkedHashMap;
        linkedHashMap = new LinkedHashMap(n);
        for (BinaryVersion binaryVersion2 : list) {
            object2 = (ProtoBuf$Class)((Object)binaryVersion2);
            object.put(NameResolverUtilKt.getClassId(this.nameResolver, ((ProtoBuf$Class)object2).getFqName()), binaryVersion2);
        }
        this.classIdToProto = object;
    }

    public final Collection getAllClassIds() {
        return this.classIdToProto.keySet();
    }

    @Override
    public ClassData findClassData(ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        ProtoBuf$Class protoBuf$Class = (ProtoBuf$Class)((ProtoBasedClassDataFinder)((Object)sourceElement)).classIdToProto.get(classId);
        if (protoBuf$Class == null) {
            return null;
        }
        ProtoBasedClassDataFinder protoBasedClassDataFinder = sourceElement;
        NameResolver nameResolver = protoBasedClassDataFinder.nameResolver;
        BinaryVersion binaryVersion = protoBasedClassDataFinder.metadataVersion;
        SourceElement sourceElement = (SourceElement)((ProtoBasedClassDataFinder)((Object)sourceElement)).classSource.invoke(classId);
        return new ClassData(nameResolver, protoBuf$Class, binaryVersion, sourceElement);
    }
}

