/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.CharsKt__CharKt;
import kotlin.text.DelimitedRangesSequence;
import kotlin.text.StringsKt;
import kotlin.text.StringsKt__StringsJVMKt;
import kotlin.text.StringsKt__StringsKt$rangesDelimitedBy$1;
import kotlin.text.StringsKt__StringsKt$rangesDelimitedBy$2;
import kotlin.text.StringsKt__StringsKt$splitToSequence$1;

abstract class StringsKt__StringsKt
extends StringsKt__StringsJVMKt {
    public static CharSequence trim(CharSequence charSequence) {
        CharSequence charSequence2 = charSequence;
        Intrinsics.checkNotNullParameter(charSequence2, "<this>");
        int n = 0;
        int n2 = charSequence2.length() - 1;
        boolean bl = false;
        while (n <= n2) {
            int n3 = !bl ? n : n2;
            n3 = CharsKt.isWhitespace(charSequence.charAt(n3)) ? 1 : 0;
            if (!bl) {
                if (n3 == 0) {
                    bl = true;
                    continue;
                }
                ++n;
                continue;
            }
            if (n3 == 0) break;
            --n2;
        }
        return charSequence.subSequence(n, n2 + 1);
    }

    public static IntRange getIndices(CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "<this>");
        return new IntRange(0, charSequence.length() - 1);
    }

    public static int getLastIndex(CharSequence charSequence) {
        CharSequence charSequence2 = charSequence;
        Intrinsics.checkNotNullParameter(charSequence2, "<this>");
        return charSequence2.length() - 1;
    }

    public static final String substring(CharSequence charSequence, IntRange intRange) {
        IntRange intRange2 = intRange;
        Intrinsics.checkNotNullParameter(charSequence, "<this>");
        Intrinsics.checkNotNullParameter(intRange2, "range");
        return ((Object)charSequence.subSequence(intRange2.getStart(), intRange.getEndInclusive() + 1)).toString();
    }

    public static final String substringBefore(String string, char c, String string2) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(string2, "missingDelimiterValue");
        int n = StringsKt.indexOf$default((CharSequence)string, c, 0, false, 6, null);
        c = (char)n;
        if (n != -1) {
            string2 = string.substring(0, c);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return string2;
    }

    public static /* synthetic */ String substringBefore$default(String string, char c, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = string;
        }
        return StringsKt__StringsKt.substringBefore(string, c, string2);
    }

    public static final String substringBefore(String string, String string2, String string3) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(string2, "delimiter");
        Intrinsics.checkNotNullParameter(string3, "missingDelimiterValue");
        int n = StringsKt.indexOf$default((CharSequence)string, string2, 0, false, 6, null);
        if (n != -1) {
            string3 = string.substring(0, n);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return string3;
    }

    public static /* synthetic */ String substringBefore$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = string;
        }
        return StringsKt__StringsKt.substringBefore(string, string2, string3);
    }

    public static final String substringAfter(String string, char c, String string2) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(string2, "missingDelimiterValue");
        int n = StringsKt.indexOf$default((CharSequence)string, c, 0, false, 6, null);
        c = (char)n;
        if (n != -1) {
            String string3 = string;
            int n2 = c + '\u0001';
            string2 = string3.substring(n2, string3.length());
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return string2;
    }

    public static /* synthetic */ String substringAfter$default(String string, char c, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = string;
        }
        return StringsKt__StringsKt.substringAfter(string, c, string2);
    }

    public static String substringAfter(String string, String string2, String string3) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(string2, "delimiter");
        Intrinsics.checkNotNullParameter(string3, "missingDelimiterValue");
        int n = StringsKt.indexOf$default((CharSequence)string, string2, 0, false, 6, null);
        if (n != -1) {
            String string4 = string;
            int n2 = n + string2.length();
            string3 = string4.substring(n2, string4.length());
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return string3;
    }

    public static /* synthetic */ String substringAfter$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = string;
        }
        return StringsKt.substringAfter(string, string2, string3);
    }

    public static String substringBeforeLast(String string, String string2, String string3) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(string2, "delimiter");
        Intrinsics.checkNotNullParameter(string3, "missingDelimiterValue");
        int n = StringsKt.lastIndexOf$default((CharSequence)string, string2, 0, false, 6, null);
        if (n != -1) {
            string3 = string.substring(0, n);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return string3;
    }

    public static final String substringAfterLast(String string, char c, String string2) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(string2, "missingDelimiterValue");
        int n = StringsKt.lastIndexOf$default((CharSequence)string, c, 0, false, 6, null);
        c = (char)n;
        if (n != -1) {
            String string3 = string;
            int n2 = c + '\u0001';
            string2 = string3.substring(n2, string3.length());
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return string2;
    }

    public static /* synthetic */ String substringAfterLast$default(String string, char c, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = string;
        }
        return StringsKt__StringsKt.substringAfterLast(string, c, string2);
    }

    public static String removePrefix(String string, CharSequence charSequence) {
        CharSequence charSequence2 = charSequence;
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(charSequence2, "prefix");
        if (StringsKt__StringsKt.startsWith$default((CharSequence)string, charSequence2, false, 2, null)) {
            String string2 = string.substring(charSequence.length());
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
            return string2;
        }
        return string;
    }

    public static String removeSuffix(String string, CharSequence charSequence) {
        CharSequence charSequence2 = charSequence;
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(charSequence2, "suffix");
        if (StringsKt__StringsKt.endsWith$default((CharSequence)string, charSequence2, false, 2, null)) {
            String string2 = string;
            String string3 = string2.substring(0, string2.length() - charSequence.length());
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string3;
        }
        return string;
    }

    public static final boolean regionMatchesImpl(CharSequence charSequence, int n, CharSequence charSequence2, int n2, int n3, boolean bl) {
        Intrinsics.checkNotNullParameter(charSequence, "<this>");
        Intrinsics.checkNotNullParameter(charSequence2, "other");
        if (n2 >= 0 && n >= 0 && n <= charSequence.length() - n3 && n2 <= charSequence2.length() - n3) {
            for (int i = 0; i < n3; ++i) {
                if (CharsKt__CharKt.equals(charSequence.charAt(n + i), charSequence2.charAt(n2 + i), bl)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final boolean startsWith(CharSequence charSequence, char c, boolean bl) {
        CharSequence charSequence2 = charSequence;
        Intrinsics.checkNotNullParameter(charSequence2, "<this>");
        return charSequence2.length() > 0 && CharsKt__CharKt.equals(charSequence.charAt(0), c, bl);
    }

    public static /* synthetic */ boolean startsWith$default(CharSequence charSequence, char c, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt__StringsKt.startsWith(charSequence, c, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean endsWith(CharSequence charSequence, char c, boolean bl) {
        CharSequence charSequence2 = charSequence;
        Intrinsics.checkNotNullParameter(charSequence2, "<this>");
        if (charSequence2.length() <= 0) return false;
        CharSequence charSequence3 = charSequence;
        if (!CharsKt__CharKt.equals(charSequence3.charAt(StringsKt.getLastIndex(charSequence3)), c, bl)) return false;
        return true;
    }

    public static /* synthetic */ boolean endsWith$default(CharSequence charSequence, char c, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt__StringsKt.endsWith(charSequence, c, bl);
    }

    public static final boolean startsWith(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        Intrinsics.checkNotNullParameter(charSequence, "<this>");
        Intrinsics.checkNotNullParameter(charSequence2, "prefix");
        if (!bl && charSequence instanceof String && charSequence2 instanceof String) {
            return StringsKt.startsWith$default((String)charSequence, (String)charSequence2, false, 2, null);
        }
        int n = charSequence2.length();
        return StringsKt__StringsKt.regionMatchesImpl(charSequence, 0, charSequence2, 0, n, bl);
    }

    public static /* synthetic */ boolean startsWith$default(CharSequence charSequence, CharSequence charSequence2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt__StringsKt.startsWith(charSequence, charSequence2, bl);
    }

    public static final boolean endsWith(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        Intrinsics.checkNotNullParameter(charSequence, "<this>");
        Intrinsics.checkNotNullParameter(charSequence2, "suffix");
        if (!bl && charSequence instanceof String && charSequence2 instanceof String) {
            return StringsKt.endsWith$default((String)charSequence, (String)charSequence2, false, 2, null);
        }
        int n = charSequence.length() - charSequence2.length();
        int n2 = charSequence2.length();
        return StringsKt__StringsKt.regionMatchesImpl(charSequence, n, charSequence2, 0, n2, bl);
    }

    public static /* synthetic */ boolean endsWith$default(CharSequence charSequence, CharSequence charSequence2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt__StringsKt.endsWith(charSequence, charSequence2, bl);
    }

    public static final int indexOfAny(CharSequence charSequence, char[] cArray, int n, boolean bl) {
        Intrinsics.checkNotNullParameter(charSequence, "<this>");
        Intrinsics.checkNotNullParameter(cArray, "chars");
        if (!bl && cArray.length == 1 && charSequence instanceof String) {
            char c = ArraysKt.single(cArray);
            return ((String)charSequence).indexOf(c, n);
        }
        n = RangesKt.coerceAtLeast(n, 0);
        IntIterator intIterator = new IntRange(n, StringsKt.getLastIndex(charSequence)).iterator();
        while (intIterator.hasNext()) {
            boolean bl2;
            int n2;
            block3: {
                n2 = intIterator.nextInt();
                char c = charSequence.charAt(n2);
                int n3 = cArray.length;
                for (int i = 0; i < n3; ++i) {
                    if (!CharsKt__CharKt.equals(cArray[i], c, bl)) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
            if (!bl2) continue;
            return n2;
        }
        return -1;
    }

    public static final int lastIndexOfAny(CharSequence charSequence, char[] cArray, int n, boolean bl) {
        Intrinsics.checkNotNullParameter(charSequence, "<this>");
        Intrinsics.checkNotNullParameter(cArray, "chars");
        if (!bl && cArray.length == 1 && charSequence instanceof String) {
            char c = ArraysKt.single(cArray);
            return ((String)charSequence).lastIndexOf(c, n);
        }
        for (n = RangesKt.coerceAtMost(n, StringsKt.getLastIndex(charSequence)); -1 < n; --n) {
            boolean bl2;
            block3: {
                char c = charSequence.charAt(n);
                int n2 = cArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (!CharsKt__CharKt.equals(cArray[i], c, bl)) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
            if (!bl2) continue;
            return n;
        }
        return -1;
    }

    private static final int indexOf$StringsKt__StringsKt(CharSequence charSequence, CharSequence charSequence2, int n, int n2, boolean bl, boolean bl2) {
        IntProgression intProgression;
        if (!bl2) {
            IntRange intRange;
            intProgression = intRange;
            n = RangesKt.coerceAtLeast(n, 0);
            intRange = new IntRange(n, RangesKt.coerceAtMost(n2, charSequence.length()));
        } else {
            intProgression = RangesKt.downTo(RangesKt.coerceAtMost(n, StringsKt.getLastIndex(charSequence)), RangesKt.coerceAtLeast(n2, 0));
        }
        if (charSequence instanceof String && charSequence2 instanceof String) {
            IntProgression intProgression2 = intProgression;
            n = intProgression2.getFirst();
            n2 = intProgression2.getLast();
            int n3 = intProgression2.getStep();
            if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                while (true) {
                    int n4;
                    String string;
                    if (StringsKt__StringsJVMKt.regionMatches((String)charSequence2, 0, string = (String)charSequence, n, n4 = charSequence2.length(), bl)) {
                        return n;
                    }
                    if (n != n2) {
                        n += n3;
                        continue;
                    }
                    break;
                }
            }
        } else {
            IntProgression intProgression3 = intProgression;
            n = intProgression3.getFirst();
            n2 = intProgression3.getLast();
            int n5 = intProgression3.getStep();
            if (n5 > 0 && n <= n2 || n5 < 0 && n2 <= n) {
                while (true) {
                    CharSequence charSequence3 = charSequence2;
                    int n6 = charSequence3.length();
                    if (StringsKt__StringsKt.regionMatchesImpl(charSequence3, 0, charSequence, n, n6, bl)) {
                        return n;
                    }
                    if (n == n2) break;
                    n += n5;
                }
            }
        }
        return -1;
    }

    static /* synthetic */ int indexOf$StringsKt__StringsKt$default(CharSequence charSequence, CharSequence charSequence2, int n, int n2, boolean bl, boolean bl2, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            bl2 = false;
        }
        return StringsKt__StringsKt.indexOf$StringsKt__StringsKt(charSequence, charSequence2, n, n2, bl, bl2);
    }

    private static final Pair findAnyOf$StringsKt__StringsKt(CharSequence charSequence, Collection object, int n, boolean bl, boolean bl2) {
        IntProgression intProgression;
        if (!bl && object.size() == 1) {
            object = (String)CollectionsKt.single((Iterable)object);
            int n2 = !bl2 ? StringsKt.indexOf$default(charSequence, (String)object, n, false, 4, null) : StringsKt.lastIndexOf$default(charSequence, (String)object, n, false, 4, null);
            return n2 < 0 ? null : TuplesKt.to(n2, object);
        }
        if (!bl2) {
            IntRange intRange;
            intProgression = intRange;
            n = RangesKt.coerceAtLeast(n, 0);
            intRange = new IntRange(n, charSequence.length());
        } else {
            intProgression = RangesKt.downTo(RangesKt.coerceAtMost(n, StringsKt.getLastIndex(charSequence)), 0);
        }
        if (charSequence instanceof String) {
            IntProgression intProgression2 = intProgression;
            n = intProgression2.getFirst();
            int n3 = intProgression2.getLast();
            int n4 = intProgression2.getStep();
            if (n4 > 0 && n <= n3 || n4 < 0 && n3 <= n) {
                while (true) {
                    Object var7_13;
                    Object object2;
                    block14: {
                        object2 = object.iterator();
                        while (object2.hasNext()) {
                            Object t = object2.next();
                            var7_13 = t;
                            String string = (String)t;
                            String string2 = (String)charSequence;
                            int n5 = string.length();
                            if (!StringsKt__StringsJVMKt.regionMatches(string, 0, string2, n, n5, bl)) continue;
                            break block14;
                        }
                        var7_13 = null;
                    }
                    object2 = var7_13;
                    if (object2 != null) {
                        return TuplesKt.to(n, object2);
                    }
                    if (n != n3) {
                        n += n4;
                        continue;
                    }
                    break;
                }
            }
        } else {
            IntProgression intProgression3 = intProgression;
            n = intProgression3.getFirst();
            int n6 = intProgression3.getLast();
            int n7 = intProgression3.getStep();
            if (n7 > 0 && n <= n6 || n7 < 0 && n6 <= n) {
                while (true) {
                    Object var7_14;
                    Object object3;
                    block16: {
                        object3 = object.iterator();
                        while (object3.hasNext()) {
                            Object t = object3.next();
                            var7_14 = t;
                            String string = (String)t;
                            int n8 = string.length();
                            if (!StringsKt__StringsKt.regionMatchesImpl(string, 0, charSequence, n, n8, bl)) continue;
                            break block16;
                        }
                        var7_14 = null;
                    }
                    object3 = var7_14;
                    if (object3 != null) {
                        return TuplesKt.to(n, object3);
                    }
                    if (n == n6) break;
                    n += n7;
                }
            }
        }
        return null;
    }

    public static final int indexOf(CharSequence object, char c, int n, boolean bl) {
        int n2;
        Intrinsics.checkNotNullParameter(object, "<this>");
        if (!bl && object instanceof String) {
            n2 = ((String)object).indexOf(c, n);
        } else {
            CharSequence charSequence = object;
            char[] cArray = new char[1];
            object = cArray;
            cArray[0] = c;
            n2 = StringsKt__StringsKt.indexOfAny(charSequence, (char[])object, n, bl);
        }
        return n2;
    }

    public static /* synthetic */ int indexOf$default(CharSequence charSequence, char c, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return StringsKt__StringsKt.indexOf(charSequence, c, n, bl);
    }

    public static final int indexOf(CharSequence charSequence, String string, int n, boolean bl) {
        int n2;
        Intrinsics.checkNotNullParameter(charSequence, "<this>");
        Intrinsics.checkNotNullParameter(string, "string");
        if (!bl && charSequence instanceof String) {
            n2 = ((String)charSequence).indexOf(string, n);
        } else {
            CharSequence charSequence2 = charSequence;
            int n3 = charSequence2.length();
            n2 = StringsKt__StringsKt.indexOf$StringsKt__StringsKt$default(charSequence2, string, n, n3, bl, false, 16, null);
        }
        return n2;
    }

    public static /* synthetic */ int indexOf$default(CharSequence charSequence, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return StringsKt__StringsKt.indexOf(charSequence, string, n, bl);
    }

    public static final int lastIndexOf(CharSequence object, char c, int n, boolean bl) {
        int n2;
        Intrinsics.checkNotNullParameter(object, "<this>");
        if (!bl && object instanceof String) {
            n2 = ((String)object).lastIndexOf(c, n);
        } else {
            CharSequence charSequence = object;
            char[] cArray = new char[1];
            object = cArray;
            cArray[0] = c;
            n2 = StringsKt__StringsKt.lastIndexOfAny(charSequence, (char[])object, n, bl);
        }
        return n2;
    }

    public static /* synthetic */ int lastIndexOf$default(CharSequence charSequence, char c, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = StringsKt.getLastIndex(charSequence);
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return StringsKt__StringsKt.lastIndexOf(charSequence, c, n, bl);
    }

    public static final int lastIndexOf(CharSequence charSequence, String string, int n, boolean bl) {
        Intrinsics.checkNotNullParameter(charSequence, "<this>");
        Intrinsics.checkNotNullParameter(string, "string");
        return !bl && charSequence instanceof String ? ((String)charSequence).lastIndexOf(string, n) : StringsKt__StringsKt.indexOf$StringsKt__StringsKt(charSequence, string, n, 0, bl, true);
    }

    public static /* synthetic */ int lastIndexOf$default(CharSequence charSequence, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = StringsKt.getLastIndex(charSequence);
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return StringsKt__StringsKt.lastIndexOf(charSequence, string, n, bl);
    }

    public static final boolean contains(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        CharSequence charSequence3 = charSequence2;
        Intrinsics.checkNotNullParameter(charSequence, "<this>");
        Intrinsics.checkNotNullParameter(charSequence3, "other");
        return charSequence3 instanceof String ? StringsKt.indexOf$default(charSequence, (String)charSequence2, 0, bl, 2, null) >= 0 : StringsKt__StringsKt.indexOf$StringsKt__StringsKt$default(charSequence, charSequence2, 0, charSequence.length(), bl, false, 16, null) >= 0;
    }

    public static /* synthetic */ boolean contains$default(CharSequence charSequence, CharSequence charSequence2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt__StringsKt.contains(charSequence, charSequence2, bl);
    }

    public static final boolean contains(CharSequence charSequence, char c, boolean bl) {
        Intrinsics.checkNotNullParameter(charSequence, "<this>");
        return StringsKt.indexOf$default(charSequence, c, 0, bl, 2, null) >= 0;
    }

    public static /* synthetic */ boolean contains$default(CharSequence charSequence, char c, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt__StringsKt.contains(charSequence, c, bl);
    }

    private static final Sequence rangesDelimitedBy$StringsKt__StringsKt(CharSequence charSequence, char[] cArray, int n, boolean bl, int n2) {
        StringsKt__StringsKt$rangesDelimitedBy$1 stringsKt__StringsKt$rangesDelimitedBy$1;
        StringsKt__StringsKt.requireNonNegativeLimit(n2);
        StringsKt__StringsKt$rangesDelimitedBy$1 stringsKt__StringsKt$rangesDelimitedBy$12 = stringsKt__StringsKt$rangesDelimitedBy$1;
        stringsKt__StringsKt$rangesDelimitedBy$1 = new StringsKt__StringsKt$rangesDelimitedBy$1(cArray, bl);
        return new DelimitedRangesSequence(charSequence, n, n2, stringsKt__StringsKt$rangesDelimitedBy$12);
    }

    static /* synthetic */ Sequence rangesDelimitedBy$StringsKt__StringsKt$default(CharSequence charSequence, char[] cArray, int n, boolean bl, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return StringsKt__StringsKt.rangesDelimitedBy$StringsKt__StringsKt(charSequence, cArray, n, bl, n2);
    }

    private static final Sequence rangesDelimitedBy$StringsKt__StringsKt(CharSequence charSequence, String[] object, int n, boolean bl, int n2) {
        StringsKt__StringsKt$rangesDelimitedBy$2 stringsKt__StringsKt$rangesDelimitedBy$2;
        StringsKt__StringsKt.requireNonNegativeLimit(n2);
        object = ArraysKt.asList(object);
        StringsKt__StringsKt$rangesDelimitedBy$2 stringsKt__StringsKt$rangesDelimitedBy$22 = stringsKt__StringsKt$rangesDelimitedBy$2;
        stringsKt__StringsKt$rangesDelimitedBy$2 = new StringsKt__StringsKt$rangesDelimitedBy$2((List)object, bl);
        return new DelimitedRangesSequence(charSequence, n, n2, stringsKt__StringsKt$rangesDelimitedBy$22);
    }

    static /* synthetic */ Sequence rangesDelimitedBy$StringsKt__StringsKt$default(CharSequence charSequence, String[] stringArray, int n, boolean bl, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return StringsKt__StringsKt.rangesDelimitedBy$StringsKt__StringsKt(charSequence, stringArray, n, bl, n2);
    }

    public static final void requireNonNegativeLimit(int n) {
        if (n >= 0) {
            return;
        }
        String string = "Limit must be non-negative, but was " + n;
        throw new IllegalArgumentException(string.toString());
    }

    public static final Sequence splitToSequence(CharSequence charSequence, String[] stringArray, boolean bl, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "<this>");
        Intrinsics.checkNotNullParameter(stringArray, "delimiters");
        return SequencesKt.map(StringsKt__StringsKt.rangesDelimitedBy$StringsKt__StringsKt$default(charSequence, stringArray, 0, bl, n, 2, null), new StringsKt__StringsKt$splitToSequence$1(charSequence));
    }

    public static /* synthetic */ Sequence splitToSequence$default(CharSequence charSequence, String[] stringArray, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return StringsKt__StringsKt.splitToSequence(charSequence, stringArray, bl, n);
    }

    public static final List split(CharSequence charSequence, String[] object, boolean bl, int n) {
        ArrayList<String> arrayList;
        String string;
        Intrinsics.checkNotNullParameter(charSequence, "<this>");
        Intrinsics.checkNotNullParameter(object, "delimiters");
        if (((String[])object).length == 1 && !((string = object[0]).length() == 0)) {
            return StringsKt__StringsKt.split$StringsKt__StringsKt(charSequence, string, bl, n);
        }
        object = SequencesKt.asIterable(StringsKt__StringsKt.rangesDelimitedBy$StringsKt__StringsKt$default(charSequence, (String[])object, 0, bl, n, 2, null));
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10));
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(StringsKt__StringsKt.substring(charSequence, (IntRange)object.next()));
        }
        return arrayList2;
    }

    public static /* synthetic */ List split$default(CharSequence charSequence, String[] stringArray, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return StringsKt__StringsKt.split(charSequence, stringArray, bl, n);
    }

    public static final List split(CharSequence charSequence, char[] object, boolean bl, int n) {
        ArrayList<String> arrayList;
        Intrinsics.checkNotNullParameter(charSequence, "<this>");
        Intrinsics.checkNotNullParameter(object, "delimiters");
        if (((char[])object).length == 1) {
            return StringsKt__StringsKt.split$StringsKt__StringsKt(charSequence, String.valueOf(object[0]), bl, n);
        }
        Iterable iterable = SequencesKt.asIterable(StringsKt__StringsKt.rangesDelimitedBy$StringsKt__StringsKt$default(charSequence, (char[])object, 0, bl, n, 2, null));
        object = iterable;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10));
        object = iterable.iterator();
        while (object.hasNext()) {
            arrayList2.add(StringsKt__StringsKt.substring(charSequence, (IntRange)object.next()));
        }
        return arrayList2;
    }

    public static /* synthetic */ List split$default(CharSequence charSequence, char[] cArray, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return StringsKt__StringsKt.split(charSequence, cArray, bl, n);
    }

    private static final List split$StringsKt__StringsKt(CharSequence charSequence, String string, boolean bl, int n) {
        StringsKt__StringsKt.requireNonNegativeLimit(n);
        int n2 = 0;
        int n3 = StringsKt__StringsKt.indexOf(charSequence, string, n2, bl);
        if (n3 != -1 && n != 1) {
            boolean bl2 = n > 0;
            int n4 = bl2 ? RangesKt.coerceAtMost(n, 10) : 10;
            ArrayList<String> arrayList = new ArrayList<String>(n4);
            do {
                arrayList.add(((Object)charSequence.subSequence(n2, n3)).toString());
                n2 = n3 + string.length();
            } while ((!bl2 || arrayList.size() != n - 1) && (n3 = StringsKt__StringsKt.indexOf(charSequence, string, n2, bl)) != -1);
            ArrayList<String> arrayList2 = arrayList;
            arrayList2.add(((Object)charSequence.subSequence(n2, charSequence.length())).toString());
            return arrayList2;
        }
        return CollectionsKt.listOf((Object)((Object)charSequence).toString());
    }

    public static final Sequence lineSequence(CharSequence charSequence) {
        CharSequence charSequence2 = charSequence;
        Intrinsics.checkNotNullParameter(charSequence2, "<this>");
        return StringsKt__StringsKt.splitToSequence$default(charSequence2, new String[]{"\r\n", "\n", "\r"}, false, 0, 6, null);
    }

    public static final List lines(CharSequence charSequence) {
        CharSequence charSequence2 = charSequence;
        Intrinsics.checkNotNullParameter(charSequence2, "<this>");
        return SequencesKt.toList(StringsKt__StringsKt.lineSequence(charSequence2));
    }

    public static boolean toBooleanStrict(String string) {
        block4: {
            boolean bl;
            block3: {
                block2: {
                    String string2 = string;
                    Intrinsics.checkNotNullParameter(string2, "<this>");
                    if (!Intrinsics.areEqual(string2, "true")) break block2;
                    bl = true;
                    break block3;
                }
                if (!Intrinsics.areEqual(string, "false")) break block4;
                bl = false;
            }
            return bl;
        }
        throw new IllegalArgumentException("The string doesn't represent a boolean value: " + string);
    }

    public static final /* synthetic */ Pair access$findAnyOf(CharSequence charSequence, Collection collection, int n, boolean bl, boolean bl2) {
        return StringsKt__StringsKt.findAnyOf$StringsKt__StringsKt(charSequence, collection, n, bl, bl2);
    }
}

