/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.Connection;
import okhttp3.ConnectionSpec;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Request$Builder;
import okhttp3.Response;
import okhttp3.Response$Builder;
import okhttp3.Route;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.ConnectionSpecSelector;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection$Companion;
import okhttp3.internal.connection.RealConnection$WhenMappings;
import okhttp3.internal.connection.RealConnection$connectTls$1;
import okhttp3.internal.connection.RealConnection$connectTls$2;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http1.Http1ExchangeCodec;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Connection$Builder;
import okhttp3.internal.http2.Http2Connection$Listener;
import okhttp3.internal.http2.Http2ExchangeCodec;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.http2.StreamResetException;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.OkHostnameVerifier;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;

public final class RealConnection
extends Http2Connection$Listener
implements Connection {
    public static final RealConnection$Companion Companion = new RealConnection$Companion(null);
    private final RealConnectionPool connectionPool;
    private final Route route;
    private Socket rawSocket;
    private Socket socket;
    private Handshake handshake;
    private Protocol protocol;
    private Http2Connection http2Connection;
    private BufferedSource source;
    private BufferedSink sink;
    private boolean noNewExchanges;
    private boolean noCoalescedConnections;
    private int routeFailureCount;
    private int successCount;
    private int refusedStreamCount;
    private int allocationLimit;
    private final List calls;
    private long idleAtNs;

    public RealConnection(RealConnectionPool realConnectionPool, Route route) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(realConnectionPool, "connectionPool");
        Intrinsics.checkNotNullParameter(route, "route");
        ((RealConnection)((Object)arrayList2)).connectionPool = realConnectionPool;
        ((RealConnection)((Object)arrayList2)).route = route;
        ((RealConnection)((Object)arrayList2)).allocationLimit = 1;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        v1.calls = arrayList2;
        v1.idleAtNs = Long.MAX_VALUE;
    }

    private final void connectTunnel(int n, int n2, int n3, Call call, EventListener eventListener) {
        Request request = this.createTunnelRequest();
        HttpUrl httpUrl = request.url();
        int n4 = 0;
        while (n4 < 21) {
            RealConnection realConnection = this;
            ++n4;
            realConnection.connectSocket(n, n2, call, eventListener);
            request = realConnection.createTunnel(n2, n3, request, httpUrl);
            if (request == null) break;
            Object object = this.rawSocket;
            if (object != null) {
                Util.closeQuietly((Socket)object);
            }
            RealConnection realConnection2 = this;
            realConnection2.rawSocket = null;
            realConnection2.sink = null;
            realConnection2.source = null;
            object = realConnection2.route.socketAddress();
            eventListener.connectEnd(call, (InetSocketAddress)object, realConnection2.route.proxy(), null);
        }
    }

    private final void connectSocket(int n, int n2, Call call, EventListener eventListener) {
        NullPointerException nullPointerException2;
        block6: {
            Proxy proxy = this.route.proxy();
            Object object = this.route.address();
            Proxy.Type type2 = proxy.type();
            int n3 = type2 == null ? -1 : RealConnection$WhenMappings.$EnumSwitchMapping$0[type2.ordinal()];
            if (n3 != 1 && n3 != 2) {
                Socket socket;
                object = socket;
                socket = new Socket(proxy);
            } else {
                object = ((Address)object).socketFactory().createSocket();
                Intrinsics.checkNotNull(object);
            }
            Object object2 = this.rawSocket = object;
            eventListener.connectStart(call, this.route.socketAddress(), proxy);
            ((Socket)object2).setSoTimeout(n2);
            try {
                Platform.Companion.get().connectSocket((Socket)object, this.route.socketAddress(), n);
            }
            catch (ConnectException connectException) {
                ConnectException connectException2 = new ConnectException(Intrinsics.stringPlus("Failed to connect to ", this.route.socketAddress()));
                connectException2.initCause(connectException);
                throw connectException2;
            }
            try {
                this.source = Okio.buffer(Okio.source((Socket)object2));
                this.sink = Okio.buffer(Okio.sink((Socket)object));
            }
            catch (NullPointerException nullPointerException2) {
                if (Intrinsics.areEqual(nullPointerException2.getMessage(), "throw with null exception")) break block6;
            }
            return;
        }
        throw new IOException(nullPointerException2);
    }

    private final void establishProtocol(ConnectionSpecSelector object, int n, Call call, EventListener eventListener) {
        if (this.route.address().sslSocketFactory() == null) {
            object = Protocol.H2_PRIOR_KNOWLEDGE;
            if (this.route.address().protocols().contains(object)) {
                this.socket = this.rawSocket;
                this.protocol = object;
                this.startHttp2(n);
                return;
            }
            this.socket = this.rawSocket;
            this.protocol = Protocol.HTTP_1_1;
            return;
        }
        RealConnection realConnection = this;
        eventListener.secureConnectStart(call);
        realConnection.connectTls((ConnectionSpecSelector)object);
        eventListener.secureConnectEnd(call, realConnection.handshake);
        if (this.protocol == Protocol.HTTP_2) {
            this.startHttp2(n);
        }
    }

    private final void startHttp2(int n) {
        Http2Connection$Builder http2Connection$Builder;
        Socket socket = this.socket;
        RealConnection realConnection = this;
        Intrinsics.checkNotNull(socket);
        BufferedSource bufferedSource = realConnection.source;
        Intrinsics.checkNotNull(bufferedSource);
        BufferedSink bufferedSink = realConnection.sink;
        Intrinsics.checkNotNull(bufferedSink);
        socket.setSoTimeout(0);
        Http2Connection$Builder http2Connection$Builder2 = http2Connection$Builder;
        http2Connection$Builder2(true, TaskRunner.INSTANCE);
        Http2Connection http2Connection = http2Connection$Builder.socket(socket, this.route.address().url().host(), bufferedSource, bufferedSink).listener(this).pingIntervalMillis(n).build();
        RealConnection realConnection2 = this;
        realConnection2.http2Connection = http2Connection;
        realConnection2.allocationLimit = Http2Connection.Companion.getDEFAULT_SETTINGS().getMaxConcurrentStreams();
        Http2Connection.start$default(http2Connection, false, null, 3, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void connectTls(ConnectionSpecSelector var1_2) {
        block28: {
            block31: {
                block30: {
                    block29: {
                        var2_3 = this.route.address();
                        v0 = var2_3.sslSocketFactory();
                        var3_4 = null;
                        Intrinsics.checkNotNull(v0);
                        v1 = this.rawSocket;
                        v2 = var2_3;
                        v3 = v2;
                        var4_5 = v2.url().host();
                        var4_5 = v0.createSocket(v1, (String)var4_5, v3.url().port(), true);
                        if (var4_5 == null) break block28;
                        v4 = var1_2;
                        var3_4 = (SSLSocket)var4_5;
                        var1_2 = v4.configureSecureSocket(var3_4);
                        if (!var1_2.supportsTlsExtensions()) ** GOTO lbl28
                        v5 = Platform.Companion.get();
                        v6 = var3_4;
                        v7 = var2_3;
                        v8 = v7;
                        var4_5 = v7.url().host();
                        v5.configureTlsExtensions(v6, (String)var4_5, v8.protocols());
lbl28:
                        // 2 sources

                        v9 = var2_3;
                        v10 = var3_4;
                        v10.startHandshake();
                        var4_5 = v10.getSession();
                        v11 = var4_5;
                        Intrinsics.checkNotNullExpressionValue(v11, "sslSocketSession");
                        var5_6 = Handshake.Companion.get((SSLSession)v11);
                        v12 = v9.hostnameVerifier();
                        Intrinsics.checkNotNull(v12);
                        if (v12.verify(var2_3.url().host(), (SSLSession)var4_5)) ** GOTO lbl50
                        this = var5_6.peerCertificates();
                        if (!(this.isEmpty() ^ true)) ** GOTO lbl49
                        this = (X509Certificate)this.get(0);
                        throw new SSLPeerUnverifiedException(StringsKt.trimMargin$default("\n              |Hostname " + var2_3.url().host() + " not verified:\n              |    certificate: " + CertificatePinner.Companion.pin((Certificate)this) + "\n              |    DN: " + this.getSubjectDN().getName() + "\n              |    subjectAltNames: " + OkHostnameVerifier.INSTANCE.allSubjectAltNames((X509Certificate)this) + "\n              ", null, 1, null));
lbl49:
                        // 1 sources

                        throw new SSLPeerUnverifiedException("Hostname " + var2_3.url().host() + " not verified (no certificates)");
lbl50:
                        // 1 sources

                        v13 = var1_2;
                        var1_2 = var2_3.certificatePinner();
                        v14 = var2_3;
                        v15 = this;
                        Intrinsics.checkNotNull(var1_2);
                        v16 = v17;
                        v18 = v17;
                        v19 = var5_6;
                        v20 = v19;
                        v21 = v19;
                        var4_5 = v19.tlsVersion();
                        var6_7 = v21.cipherSuite();
                        var7_8 = v20.localCertificates();
                        v22 = var4_5;
                        v23 = var6_7;
                        var4_5 = v24;
                        v24 = new RealConnection$connectTls$1((CertificatePinner)var1_2, var5_6, var2_3);
                        v16((TlsVersion)v22, v23, var7_8, (Function0)var4_5);
                        v15.handshake = v18;
                        var1_2.check$okhttp(v14.url().host(), new RealConnection$connectTls$2((RealConnection)this));
                        if (!v13.supportsTlsExtensions()) break block29;
                        var1_2 = Platform.Companion.get().getSelectedProtocol(var3_4);
                        break block30;
                    }
                    var1_2 = null;
                }
                this.socket = var3_4;
                this.source = Okio.buffer(Okio.source(var3_4));
                this.sink = Okio.buffer(Okio.sink(var3_4));
                if (var1_2 == null) break block31;
                v25 = Protocol.Companion.get((String)var1_2);
lbl89:
                // 2 sources

                while (true) {
                    var1_2 = v25;
                    ** GOTO lbl96
                    break;
                }
            }
            v25 = Protocol.HTTP_1_1;
            ** continue;
lbl96:
            // 1 sources

            this.protocol = var1_2;
            Platform.Companion.get().afterHandshake(var3_4);
            return;
        }
        try {
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.SSLSocket");
        }
        catch (Throwable var0_1) {
            if (var3_4 != null) {
                Platform.Companion.get().afterHandshake(var3_4);
            }
            if (var3_4 != null) {
                Util.closeQuietly(var3_4);
            }
            throw var0_1;
        }
    }

    private final Request createTunnel(int n, int n2, Request object, HttpUrl object2) {
        BufferedSink bufferedSink;
        Object object3;
        block3: {
            block4: {
                object2 = "CONNECT " + Util.toHostHeader((HttpUrl)object2, true) + " HTTP/1.1";
                while (true) {
                    Http1ExchangeCodec http1ExchangeCodec;
                    RealConnection realConnection = this;
                    object3 = realConnection.source;
                    Intrinsics.checkNotNull(object3);
                    bufferedSink = realConnection.sink;
                    Intrinsics.checkNotNull(bufferedSink);
                    Http1ExchangeCodec http1ExchangeCodec2 = http1ExchangeCodec;
                    http1ExchangeCodec2(null, this, (BufferedSource)object3, bufferedSink);
                    TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                    object3.timeout().timeout(n, timeUnit);
                    bufferedSink.timeout().timeout(n2, timeUnit);
                    http1ExchangeCodec.writeRequest(((Request)object).headers(), (String)object2);
                    http1ExchangeCodec.finishRequest();
                    Response$Builder response$Builder = http1ExchangeCodec.readResponseHeaders(false);
                    Intrinsics.checkNotNull(response$Builder);
                    object = response$Builder.request((Request)object).build();
                    http1ExchangeCodec2.skipConnectBody((Response)object);
                    int n3 = ((Response)object).code();
                    if (n3 == 200) break block3;
                    if (n3 != 407) break block4;
                    object3 = this.route.address().proxyAuthenticator().authenticate(this.route, (Response)object);
                    if (object3 == null) break;
                    if (StringsKt.equals("close", Response.header$default((Response)object, "Connection", null, 2, null), true)) {
                        return object3;
                    }
                    object = object3;
                }
                throw new IOException("Failed to authenticate with proxy");
            }
            throw new IOException(Intrinsics.stringPlus("Unexpected response code for CONNECT: ", ((Response)object).code()));
        }
        if (object3.getBuffer().exhausted() && bufferedSink.getBuffer().exhausted()) {
            return null;
        }
        throw new IOException("TLS tunnel buffered too many bytes!");
    }

    private final Request createTunnelRequest() {
        Object object = new Request$Builder().url(((RealConnection)((Object)request)).route.address().url()).method("CONNECT", null).header("Host", Util.toHostHeader(((RealConnection)((Object)request)).route.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", "okhttp/4.10.0").build();
        Response response = new Response$Builder().request((Request)object).protocol(Protocol.HTTP_1_1).code(407).message("Preemptive Authenticate").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(-1L).header("Proxy-Authenticate", "OkHttp-Preemptive").build();
        Request request = ((RealConnection)((Object)request)).route.address().proxyAuthenticator().authenticate(((RealConnection)((Object)request)).route, response);
        if (request != null) {
            object = request;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean routeMatchesAny(List iterator2) {
        boolean bl;
        if (iterator2 instanceof Collection && iterator2.isEmpty()) {
            return false;
        }
        iterator2 = iterator2.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Route route = (Route)iterator2.next();
            if (route.proxy().type() == Proxy.Type.DIRECT && this.route.proxy().type() == Proxy.Type.DIRECT && Intrinsics.areEqual(this.route.socketAddress(), route.socketAddress())) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean supportsUrl(HttpUrl httpUrl) {
        if (Util.assertionsEnabled) {
            if (!Thread.holdsLock(this)) throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + this));
        }
        Object object = this.route.address().url();
        if (httpUrl.port() != ((HttpUrl)object).port()) {
            return false;
        }
        if (Intrinsics.areEqual(httpUrl.host(), ((HttpUrl)object).host())) {
            return true;
        }
        if (this.noCoalescedConnections) return false;
        object = this.handshake;
        if (object == null) return false;
        Intrinsics.checkNotNull(object);
        if (!this.certificateSupportHost(httpUrl, (Handshake)object)) return false;
        return true;
    }

    private final boolean certificateSupportHost(HttpUrl httpUrl, Handshake handshake2) {
        Object object = handshake2.peerCertificates();
        return object.isEmpty() ^ true && OkHostnameVerifier.INSTANCE.verify((String)(object = httpUrl.host()), (X509Certificate)object.get(0));
    }

    public static final /* synthetic */ Handshake access$getHandshake$p(RealConnection realConnection) {
        return realConnection.handshake;
    }

    public final boolean getNoNewExchanges() {
        return this.noNewExchanges;
    }

    public final void setNoNewExchanges(boolean bl) {
        this.noNewExchanges = bl;
    }

    public final int getRouteFailureCount$okhttp() {
        return this.routeFailureCount;
    }

    public final List getCalls() {
        return this.calls;
    }

    public final long getIdleAtNs$okhttp() {
        return this.idleAtNs;
    }

    public final void setIdleAtNs$okhttp(long l) {
        this.idleAtNs = l;
    }

    public final boolean isMultiplexed$okhttp() {
        return this.http2Connection != null;
    }

    public final synchronized void noNewExchanges$okhttp() {
        this.noNewExchanges = true;
    }

    public final synchronized void noCoalescedConnections$okhttp() {
        this.noCoalescedConnections = true;
    }

    public final synchronized void incrementSuccessCount$okhttp() {
        ++this.successCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void connect(int n, int n2, int n3, int n4, boolean bl, Call call, EventListener eventListener) {
        block12: {
            ProtocolException protocolException;
            Object object;
            ConnectionSpecSelector connectionSpecSelector;
            Intrinsics.checkNotNullParameter(call, "call");
            Intrinsics.checkNotNullParameter(eventListener, "eventListener");
            if (!(((RealConnection)object).protocol == null)) {
                throw new IllegalStateException("already connected".toString());
            }
            RealConnection realConnection = object;
            RouteException routeException = null;
            Object object2 = realConnection.route.address().connectionSpecs();
            ConnectionSpecSelector connectionSpecSelector2 = connectionSpecSelector;
            connectionSpecSelector = new ConnectionSpecSelector((List)object2);
            if (realConnection.route.address().sslSocketFactory() == null) {
                if (!object2.contains(ConnectionSpec.CLEARTEXT)) {
                    UnknownServiceException unknownServiceException;
                    object = unknownServiceException;
                    unknownServiceException = new UnknownServiceException("CLEARTEXT communication not enabled for client");
                    throw new RouteException((IOException)object);
                }
                object2 = ((RealConnection)object).route.address().url().host();
                if (!Platform.Companion.get().isCleartextTrafficPermitted((String)object2)) {
                    throw new RouteException(new UnknownServiceException("CLEARTEXT communication to " + (String)object2 + " not permitted by network security policy"));
                }
            } else if (((RealConnection)object).route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
                UnknownServiceException unknownServiceException;
                object = unknownServiceException;
                unknownServiceException = new UnknownServiceException("H2_PRIOR_KNOWLEDGE cannot be used with HTTPS");
                throw new RouteException((IOException)object);
            }
            while (true) {
                Object object3;
                try {
                    block15: {
                        block14: {
                            block13: {
                                if (!((RealConnection)object).route.requiresTunnel()) break block13;
                                Object object4 = object;
                                super.connectTunnel(n, n2, n3, call, eventListener);
                                if (((RealConnection)object4).rawSocket != null) break block14;
                                break block15;
                            }
                            super.connectSocket(n, n2, call, eventListener);
                        }
                        Object object5 = object;
                        super.establishProtocol(connectionSpecSelector2, n4, call, eventListener);
                        object2 = ((RealConnection)object5).route.socketAddress();
                        object3 = ((RealConnection)object5).route.proxy();
                        Protocol protocol = ((RealConnection)object5).protocol;
                        eventListener.connectEnd(call, (InetSocketAddress)object2, (Proxy)object3, protocol);
                    }
                    if (((RealConnection)object).route.requiresTunnel() && ((RealConnection)object).rawSocket == null) break;
                    break block12;
                }
                catch (IOException iOException) {
                    object3 = ((RealConnection)object).socket;
                    if (object3 != null) {
                        Util.closeQuietly((Socket)object3);
                    }
                    object3 = ((RealConnection)object).rawSocket;
                    if (object3 != null) {
                        Util.closeQuietly((Socket)object3);
                    }
                    Object object6 = object;
                    ((RealConnection)object6).socket = null;
                    ((RealConnection)object6).rawSocket = null;
                    ((RealConnection)object6).source = null;
                    ((RealConnection)object6).sink = null;
                    ((RealConnection)object6).handshake = null;
                    ((RealConnection)object6).protocol = null;
                    ((RealConnection)object6).http2Connection = null;
                    ((RealConnection)object6).allocationLimit = 1;
                    object3 = ((RealConnection)object6).route.socketAddress();
                    eventListener.connectFailed(call, (InetSocketAddress)object3, ((RealConnection)object6).route.proxy(), null, iOException);
                    if (routeException == null) {
                        RouteException routeException2;
                        routeException = routeException2;
                        routeException2 = new RouteException(iOException);
                        continue;
                    }
                    routeException.addConnectException(iOException);
                    if (bl && connectionSpecSelector2.connectionFailed(iOException)) continue;
                    throw routeException;
                }
                break;
            }
            object = protocolException;
            protocolException = new ProtocolException("Too many tunnel connections attempted: 21");
            throw new RouteException((IOException)object);
        }
        ((RealConnection)object).idleAtNs = System.nanoTime();
    }

    public final boolean isEligible$okhttp(Address address, List object) {
        Intrinsics.checkNotNullParameter(address, "address");
        if (Util.assertionsEnabled && !Thread.holdsLock(string)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + string));
        }
        if (((RealConnection)((Object)string)).calls.size() < ((RealConnection)((Object)string)).allocationLimit && !((RealConnection)((Object)string)).noNewExchanges) {
            if (!((RealConnection)((Object)string)).route.address().equalsNonHost$okhttp(address)) {
                return false;
            }
            if (Intrinsics.areEqual(address.url().host(), ((RealConnection)((Object)string)).route().address().url().host())) {
                return true;
            }
            if (((RealConnection)((Object)string)).http2Connection == null) {
                return false;
            }
            if (object != null && ((RealConnection)((Object)string)).routeMatchesAny((List)object)) {
                if (address.hostnameVerifier() != OkHostnameVerifier.INSTANCE) {
                    return false;
                }
                if (!((RealConnection)((Object)string)).supportsUrl(address.url())) {
                    return false;
                }
                try {
                    object = address.certificatePinner();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    return false;
                }
                RealConnection realConnection = string;
                Intrinsics.checkNotNull(object);
                String string = address.url().host();
                Handshake handshake2 = realConnection.handshake();
                Intrinsics.checkNotNull(handshake2);
                ((CertificatePinner)object).check(string, handshake2.peerCertificates());
                return true;
            }
            return false;
        }
        return false;
    }

    public final ExchangeCodec newCodec$okhttp(OkHttpClient okHttpClient, RealInterceptorChain realInterceptorChain) {
        RealConnection realConnection = this;
        Intrinsics.checkNotNullParameter(okHttpClient, "client");
        Intrinsics.checkNotNullParameter(realInterceptorChain, "chain");
        Object object = realConnection.socket;
        Intrinsics.checkNotNull(object);
        BufferedSource bufferedSource = realConnection.source;
        Intrinsics.checkNotNull(bufferedSource);
        BufferedSink bufferedSink = realConnection.sink;
        Intrinsics.checkNotNull(bufferedSink);
        Http2Connection http2Connection = realConnection.http2Connection;
        if (http2Connection != null) {
            Http2ExchangeCodec http2ExchangeCodec;
            object = http2ExchangeCodec;
            http2ExchangeCodec = new Http2ExchangeCodec(okHttpClient, this, realInterceptorChain, http2Connection);
        } else {
            Http1ExchangeCodec http1ExchangeCodec;
            ((Socket)object).setSoTimeout(realInterceptorChain.readTimeoutMillis());
            object = TimeUnit.MILLISECONDS;
            bufferedSource.timeout().timeout(realInterceptorChain.getReadTimeoutMillis$okhttp(), (TimeUnit)((Object)object));
            bufferedSink.timeout().timeout(realInterceptorChain.getWriteTimeoutMillis$okhttp(), (TimeUnit)((Object)object));
            object = http1ExchangeCodec;
            http1ExchangeCodec = new Http1ExchangeCodec(okHttpClient, this, bufferedSource, bufferedSink);
        }
        return object;
    }

    public Route route() {
        return this.route;
    }

    public final void cancel() {
        Socket socket = ((RealConnection)((Object)socket)).rawSocket;
        if (socket != null) {
            Util.closeQuietly(socket);
        }
    }

    public Socket socket() {
        Socket socket = this.socket;
        Intrinsics.checkNotNull(socket);
        return socket;
    }

    public final boolean isHealthy(boolean bl) {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        RealConnection realConnection = this;
        long l = System.nanoTime();
        Closeable closeable = realConnection.rawSocket;
        Intrinsics.checkNotNull(closeable);
        Socket socket = realConnection.socket;
        Intrinsics.checkNotNull(socket);
        BufferedSource bufferedSource = realConnection.source;
        Intrinsics.checkNotNull(bufferedSource);
        if (!(((Socket)closeable).isClosed() || socket.isClosed() || socket.isInputShutdown() || socket.isOutputShutdown())) {
            closeable = this.http2Connection;
            if (closeable != null) {
                return ((Http2Connection)closeable).isHealthy(l);
            }
            RealConnection realConnection2 = this;
            synchronized (realConnection2) {
                long l2 = l - realConnection2.getIdleAtNs$okhttp();
                if (l2 >= 10000000000L && bl) {
                    return Util.isHealthy(socket, bufferedSource);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onStream(Http2Stream http2Stream) {
        Http2Stream http2Stream2 = http2Stream;
        Intrinsics.checkNotNullParameter(http2Stream2, "stream");
        http2Stream2.close(ErrorCode.REFUSED_STREAM, null);
    }

    @Override
    public synchronized void onSettings(Http2Connection http2Connection, Settings settings) {
        Settings settings2 = settings;
        Intrinsics.checkNotNullParameter(http2Connection, "connection");
        Intrinsics.checkNotNullParameter(settings2, "settings");
        this.allocationLimit = settings2.getMaxConcurrentStreams();
    }

    public Handshake handshake() {
        return this.handshake;
    }

    public final void connectFailed$okhttp(OkHttpClient okHttpClient, Route route, IOException iOException) {
        Intrinsics.checkNotNullParameter(okHttpClient, "client");
        Intrinsics.checkNotNullParameter(route, "failedRoute");
        Intrinsics.checkNotNullParameter(iOException, "failure");
        if (route.proxy().type() != Proxy.Type.DIRECT) {
            Address address = route.address();
            address.proxySelector().connectFailed(address.url().uri(), route.proxy().address(), iOException);
        }
        okHttpClient.getRouteDatabase().failed(route);
    }

    public final synchronized void trackFailure$okhttp(RealCall cloneable2, IOException object) {
        Intrinsics.checkNotNullParameter(cloneable2, "call");
        if (object instanceof StreamResetException) {
            object = ((StreamResetException)object).errorCode;
            if (object == ErrorCode.REFUSED_STREAM) {
                if (++this.refusedStreamCount > 1) {
                    this.noNewExchanges = true;
                    ++this.routeFailureCount;
                }
            } else if (object != ErrorCode.CANCEL || !cloneable2.isCanceled()) {
                this.noNewExchanges = true;
                ++this.routeFailureCount;
            }
        } else if (!this.isMultiplexed$okhttp() || object instanceof ConnectionShutdownException) {
            this.noNewExchanges = true;
            if (this.successCount == 0) {
                if (object != null) {
                    RealConnection realConnection = this;
                    cloneable2 = cloneable2.getClient();
                    realConnection.connectFailed$okhttp((OkHttpClient)cloneable2, realConnection.route, (IOException)object);
                }
                ++this.routeFailureCount;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Connection{").append(this.route.address().url().host()).append(':').append(this.route.address().url().port()).append(", proxy=").append(this.route.proxy()).append(" hostAddress=").append(this.route.socketAddress()).append(" cipherSuite=");
        Object object = this.handshake;
        if (object != null) {
            if ((object = ((Handshake)object).cipherSuite()) != null) return stringBuilder.append(object).append(" protocol=").append((Object)this.protocol).append('}').toString();
        }
        object = "none";
        return stringBuilder.append(object).append(" protocol=").append((Object)this.protocol).append('}').toString();
    }
}

