/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Interceptor$Chain;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Request$Builder;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RetryAndFollowUpInterceptor$Companion;

public final class RetryAndFollowUpInterceptor
implements Interceptor {
    public static final RetryAndFollowUpInterceptor$Companion Companion = new RetryAndFollowUpInterceptor$Companion(null);
    private final OkHttpClient client;

    public RetryAndFollowUpInterceptor(OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter(okHttpClient, "client");
        this.client = okHttpClient;
    }

    private final boolean recover(IOException iOException, RealCall realCall, Request request, boolean bl) {
        if (!this.client.retryOnConnectionFailure()) {
            return false;
        }
        if (bl && this.requestIsOneShot(iOException, request)) {
            return false;
        }
        if (!this.isRecoverable(iOException, bl)) {
            return false;
        }
        return realCall.retryAfterFailure();
    }

    private final boolean requestIsOneShot(IOException iOException, Request request) {
        RequestBody requestBody = request.body();
        return requestBody != null && requestBody.isOneShot() || iOException instanceof FileNotFoundException;
    }

    private final boolean isRecoverable(IOException iOException, boolean bl) {
        if (iOException instanceof ProtocolException) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            return iOException instanceof SocketTimeoutException && !bl;
        }
        if (iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        return !(iOException instanceof SSLPeerUnverifiedException);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Request followUpRequest(Response response, Exchange object) {
        Object object2;
        object2 = object == null || (object2 = ((Exchange)object).getConnection$okhttp()) == null ? null : ((RealConnection)object2).route();
        String string = response.request().method();
        switch (response.code()) {
            default: {
                return null;
            }
            case 503: {
                object = response.priorResponse();
                if (object != null && ((Response)object).code() == 503) {
                    return null;
                }
                if (super.retryAfter(response, Integer.MAX_VALUE) != 0) return null;
                return response.request();
            }
            case 421: {
                RequestBody requestBody = response.request().body();
                if (requestBody != null && requestBody.isOneShot()) {
                    return null;
                }
                if (object == null) return null;
                if (!((Exchange)object).isCoalescedConnection$okhttp()) {
                    return null;
                }
                ((Exchange)object).getConnection$okhttp().noCoalescedConnections$okhttp();
                return response.request();
            }
            case 408: {
                if (!((RetryAndFollowUpInterceptor)((Object)requestBody)).client.retryOnConnectionFailure()) {
                    return null;
                }
                object = response.request().body();
                if (object != null && ((RequestBody)object).isOneShot()) {
                    return null;
                }
                object = response.priorResponse();
                if (object != null && ((Response)object).code() == 408) {
                    return null;
                }
                if (super.retryAfter(response, 0) <= 0) return response.request();
                return null;
            }
            case 407: {
                Object object3 = object2;
                Intrinsics.checkNotNull(object3);
                if (((Route)object3).proxy().type() != Proxy.Type.HTTP) throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                return ((RetryAndFollowUpInterceptor)((Object)requestBody)).client.proxyAuthenticator().authenticate((Route)object2, response);
            }
            case 401: {
                return ((RetryAndFollowUpInterceptor)((Object)requestBody)).client.authenticator().authenticate((Route)object2, response);
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: 
        }
        return ((RetryAndFollowUpInterceptor)((Object)requestBody)).buildRedirectRequest(response, string);
    }

    private final Request buildRedirectRequest(Response response, String string) {
        if (!((RetryAndFollowUpInterceptor)((Object)request$Builder)).client.followRedirects()) {
            return null;
        }
        Object object = Response.header$default(response, "Location", null, 2, null);
        if (object == null) {
            return null;
        }
        object = response.request().url().resolve((String)object);
        if (object == null) {
            return null;
        }
        if (!Intrinsics.areEqual(((HttpUrl)object).scheme(), response.request().url().scheme()) && !((RetryAndFollowUpInterceptor)((Object)request$Builder)).client.followSslRedirects()) {
            return null;
        }
        Request$Builder request$Builder = response.request().newBuilder();
        if (HttpMethod.permitsRequestBody(string)) {
            int n = response.code();
            HttpMethod httpMethod = HttpMethod.INSTANCE;
            boolean bl = httpMethod.redirectsWithBody(string) || n == 308 || n == 307;
            if (httpMethod.redirectsToGet(string) && n != 308 && n != 307) {
                request$Builder.method("GET", null);
            } else {
                RequestBody requestBody = bl ? response.request().body() : null;
                request$Builder.method(string, requestBody);
            }
            if (!bl) {
                Request$Builder request$Builder2 = request$Builder;
                request$Builder2.removeHeader("Transfer-Encoding");
                request$Builder2.removeHeader("Content-Length");
                request$Builder2.removeHeader("Content-Type");
            }
        }
        if (!Util.canReuseConnectionFor(response.request().url(), (HttpUrl)object)) {
            request$Builder.removeHeader("Authorization");
        }
        return request$Builder.url((HttpUrl)object).build();
    }

    private final int retryAfter(Response response, int n) {
        String string = Response.header$default(response, "Retry-After", null, 2, null);
        if (string == null) {
            return n;
        }
        if (new Regex("\\d+").matches(string)) {
            Integer n2 = Integer.valueOf(string);
            Intrinsics.checkNotNullExpressionValue(n2, "valueOf(header)");
            return n2;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Response intercept(Interceptor$Chain var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

