/*
 * Decompiled with CFR 0.152.
 */
package com.chunksending.mixin;

import com.chunksending.ChunkSending;
import com.chunksending.IChunksendingPlayer;
import com.chunksending.config.CommonConfiguration;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerChunkSending
extends Player
implements IChunksendingPlayer {
    @Shadow
    public ServerGamePacketListenerImpl f_8906_;
    @Shadow
    private boolean f_8932_;
    @Unique
    private Map<ChunkPos, List<Packet<?>>> chunksToSend = new HashMap();

    public ServerPlayerChunkSending(Level p_250508_, BlockPos p_250289_, float p_251702_, GameProfile p_252153_) {
        super(p_250508_, p_250289_, p_251702_, p_252153_);
    }

    @Inject(method={"trackChunk"}, at={@At(value="HEAD")}, cancellable=true)
    private void chunksending$trackChunk(ChunkPos pos, Packet<?> chunkPacket, CallbackInfo ci) {
        ci.cancel();
        List<Packet<?>> packetList = this.chunksToSend.get(pos);
        if (packetList == null) {
            packetList = new ArrayList();
            this.chunksToSend.put(pos, packetList);
        }
        packetList.add(chunkPacket);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void chunksending$update(CallbackInfo ci) {
        if (this.chunksToSend.isEmpty()) {
            return;
        }
        if (this.f_8932_) {
            this.chunksToSend.clear();
            return;
        }
        ArrayList packets = new ArrayList(this.chunksToSend.entrySet());
        packets.sort(Comparator.comparingDouble(e -> ((ChunkPos)e.getKey()).m_151394_(this.m_146904_()).m_123331_((Vec3i)this.m_20183_())));
        int amount = ((CommonConfiguration)ChunkSending.config.getCommonConfig()).maxChunksPerTick + packets.size() / 10;
        for (int i = 0; i < packets.size() && i < amount; ++i) {
            Map.Entry entry = (Map.Entry)packets.get(i);
            for (Packet packet : (List)entry.getValue()) {
                this.f_8906_.m_9829_(packet);
            }
            this.chunksToSend.remove(entry.getKey());
        }
        if (((CommonConfiguration)ChunkSending.config.getCommonConfig()).debugLogging) {
            ChunkSending.LOGGER.info("Sent: " + amount + " packets to " + this.m_5446_().getString() + ", in queue:" + this.chunksToSend.size());
        }
    }

    @Override
    public boolean attachToPending(ChunkPos pos, Packet<?> packet) {
        List<Packet<?>> packetList = this.chunksToSend.get(pos);
        if (packetList == null) {
            return false;
        }
        packetList.add(packet);
        return true;
    }
}

