/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.electricity.connector;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.antarcticgardens.newage.content.electricity.connector.ElectricalConnectorBlock;
import org.antarcticgardens.newage.content.electricity.connector.ElectricalConnectorMode;
import org.antarcticgardens.newage.content.electricity.network.ElectricalNetwork;
import org.antarcticgardens.newage.content.electricity.network.NetworkEnergyContainer;
import org.antarcticgardens.newage.content.electricity.wire.WireType;

public class ElectricalConnectorBlockEntity
extends BlockEntity
implements BotariumEnergyBlock<NetworkEnergyContainer>,
IHaveGoggleInformation {
    private final Map<ElectricalConnectorBlockEntity, WireType> connectors = new HashMap<ElectricalConnectorBlockEntity, WireType>();
    private final Map<BlockPos, WireType> connectorPositions = new HashMap<BlockPos, WireType>();
    private ElectricalNetwork network;
    private NetworkEnergyContainer energyContainer;
    private boolean connectionsInitialized = false;

    public ElectricalConnectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected void m_183515_(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (Map.Entry<BlockPos, WireType> e : this.connectorPositions.entrySet()) {
            CompoundTag compound = new CompoundTag();
            compound.m_128365_("position", (Tag)NBTHelper.writeVec3i((Vec3i)((Vec3i)e.getKey())));
            compound.m_128365_("wire", (Tag)StringTag.m_129297_((String)e.getValue().name()));
            list.add((Object)compound);
        }
        nbt.m_128365_("connections", (Tag)list);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("connections", 10);
        this.connectorPositions.clear();
        for (Tag listTag : (Tag[])list.toArray((Object[])new Tag[0])) {
            CompoundTag ct;
            if (!(listTag instanceof CompoundTag) || !(ct = (CompoundTag)listTag).m_128441_("position") || !ct.m_128441_("wire")) continue;
            BlockPos pos = new BlockPos(NBTHelper.readVec3i((ListTag)((ListTag)ct.m_128423_("position"))));
            WireType wire = WireType.valueOf(ct.m_128461_("wire"));
            this.connectorPositions.put(pos, wire);
        }
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Map<BlockPos, WireType> getConnectorPositions() {
        return Collections.unmodifiableMap(this.connectorPositions);
    }

    public BlockPos getSupportingBlockPos() {
        return this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_());
    }

    protected void serverTick() {
        if (this.network == null) {
            this.setNetwork(new ElectricalNetwork(this));
        }
        if (!this.connectionsInitialized) {
            this.updateConnections();
            this.connectionsInitialized = true;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"tooltip.create_new_age.connector_info", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        Lang.translate((String)"tooltip.create_new_age.mode", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        ElectricalConnectorMode mode = (ElectricalConnectorMode)((Object)this.m_58900_().m_61143_(ElectricalConnectorBlock.MODE));
        Lang.translate((String)("tooltip.create_new_age.connector_mode." + mode.m_7912_()), (Object[])new Object[0]).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        return true;
    }

    protected void neighborChanged() {
        this.network.updateConsumersAndSources();
    }

    private void updateConnections() {
        for (Map.Entry<BlockPos, WireType> e : this.connectorPositions.entrySet()) {
            BlockEntity blockEntity = this.m_58904_().m_7702_(e.getKey());
            if (!(blockEntity instanceof ElectricalConnectorBlockEntity)) continue;
            ElectricalConnectorBlockEntity connector = (ElectricalConnectorBlockEntity)blockEntity;
            this.connect(connector, e.getValue());
        }
    }

    protected void remove(Level level) {
        if (!level.m_5776_()) {
            this.network.destroy();
        }
        for (Map.Entry<ElectricalConnectorBlockEntity, WireType> e : this.connectors.entrySet()) {
            e.getKey().disconnect(this);
            e.getKey().updateConnections();
            e.getKey().m_6596_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7726_().m_8450_(e.getKey().m_58899_());
            Containers.m_19010_((Level)level, (BlockPos)this.m_58899_(), (NonNullList)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{e.getValue().getDroppedItem()}));
        }
    }

    public void connect(ElectricalConnectorBlockEntity entity, WireType wireType) {
        if (!this.connectors.containsKey((Object)entity)) {
            this.connectors.put(entity, wireType);
        }
        entity.connectWithoutNetworking(this, wireType);
        if (!this.connectorPositions.containsKey(entity.m_58899_())) {
            this.connectorPositions.put(entity.m_58899_(), wireType);
        }
        entity.m_6596_();
        this.m_6596_();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.network.addNode(entity);
            serverLevel.m_7726_().m_8450_(entity.m_58899_());
            serverLevel.m_7726_().m_8450_(this.m_58899_());
        }
    }

    private void connectWithoutNetworking(ElectricalConnectorBlockEntity entity, WireType wireType) {
        if (!this.connectors.containsKey((Object)entity)) {
            this.connectors.put(entity, wireType);
        }
        if (!this.connectorPositions.containsKey(entity.m_58899_())) {
            this.connectorPositions.put(entity.m_58899_(), wireType);
        }
    }

    public boolean isConnected(BlockPos pos) {
        return this.connectorPositions.containsKey(pos);
    }

    public void disconnect(ElectricalConnectorBlockEntity entity) {
        this.connectors.remove((Object)entity);
        this.connectorPositions.remove(entity.m_58899_());
    }

    public Map<ElectricalConnectorBlockEntity, WireType> getConnectors() {
        return Collections.unmodifiableMap(this.connectors);
    }

    public void setNetwork(ElectricalNetwork network) {
        this.network = network;
        if (this.energyContainer == null) {
            this.energyContainer = new NetworkEnergyContainer(this, this.network);
        } else {
            this.energyContainer.setNetwork(this.network);
        }
    }

    public ElectricalNetwork getNetwork() {
        return this.network;
    }

    public NetworkEnergyContainer getEnergyStorage() {
        if (this.network == null) {
            this.setNetwork(new ElectricalNetwork(this));
        }
        return this.energyContainer;
    }
}

