/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.config;

import io.redspace.ironsrpgtweaks.config.ConfigHelper;
import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.hunger_module.RegistryGetter;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PotionItem;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="irons_rpg_tweaks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigEvents {
    @SubscribeEvent
    public static void onReload(ModConfigEvent event) {
        if (event.getConfig().getType().equals((Object)ModConfig.Type.SERVER)) {
            ConfigHelper.Damage.damageEntityBlacklist = ((List)ServerConfigs.DAMAGE_MODULE_ENTITY_BLACKLIST.get()).stream().map(itemName -> (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(itemName))).collect(Collectors.toSet());
            ConfigHelper.Hunger.foodStackBlacklist = ((List)ServerConfigs.FOOD_STACK_BLACKLIST.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))).collect(Collectors.toSet());
            if (((Boolean)ServerConfigs.HUNGER_MODULE_ENABLED.get()).booleanValue()) {
                int potionStack = Math.min((Integer)ServerConfigs.POTION_STACK_SIZE_OVERRIDE.get(), 64);
                int foodStack = Math.min((Integer)ServerConfigs.FOOD_STACK_SIZE_OVERRIDE.get(), 64);
                if (foodStack <= 0 && potionStack <= 0) {
                    return;
                }
                IForgeRegistry<Item> registry = RegistryGetter.getItem();
                registry.forEach(item -> {
                    if (!ConfigHelper.Hunger.foodStackBlacklist.contains(item)) {
                        if (potionStack > 0 && item instanceof PotionItem) {
                            item.f_41370_ = potionStack;
                        } else if (foodStack > 0 && item.m_41473_() != null) {
                            item.f_41370_ = Math.min(item.f_41370_, foodStack);
                        }
                    }
                });
            }
        }
    }
}

