/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.damage_module;

import io.redspace.ironsrpgtweaks.config.ConfigHelper;
import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.damage_module.PlayerDamageMode;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DamageServerEvents {
    public static final List<String> BLACKLIST_DAMAGE_SOURCES = List.of("lava", "inFire", "cactus", "inWall", "hotFloor", "lightningBolt", "sweetBerryBush", "outOfWorld", "drown");
    public static final List<String> BLACKLIST_ENTITY_TYPES = List.of("minecraft:slime", "minecraft:ender_dragon", "minecraft:magma_cube", "irons_spellbooks:wall_of_fire", "irons_spellbooks:void_tentacle");

    @SubscribeEvent
    public static void onTakeDamage(LivingDamageEvent event) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue()) {
            if (event.getEntity() instanceof Player && ServerConfigs.PLAYER_DAMAGE_MODE.get() == PlayerDamageMode.NONE || ServerConfigs.PLAYER_DAMAGE_MODE.get() == PlayerDamageMode.ONLY_LIVING && !(event.getSource().m_7640_() instanceof LivingEntity)) {
                return;
            }
            if (DamageServerEvents.testDamageSource(event.getSource())) {
                event.getEntity().f_19802_ = (Integer)ServerConfigs.IFRAME_COUNT.get();
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        if ((double)player.m_36403_(0.0f) < (Double)ServerConfigs.MINIMUM_ATTACK_STRENGTH.get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void modifyKnockback(LivingKnockBackEvent event) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue()) {
            event.setStrength((float)((double)event.getStrength() * (Double)ServerConfigs.KNOCKBACK_MODIFIER.get()));
        }
    }

    private static boolean testDamageSource(DamageSource source) {
        if (((List)ServerConfigs.DAMAGE_MODULE_DAMAGE_SOURCE_BLACKLIST.get()).contains(source.m_19385_())) {
            return false;
        }
        return !(source.m_7639_() != null && ConfigHelper.Damage.damageEntityBlacklist.contains(source.m_7639_().m_6095_()) || source.m_7640_() != null && ConfigHelper.Damage.damageEntityBlacklist.contains(source.m_7640_().m_6095_()));
    }
}

