/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.arithmetic.predicates;

import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaPredicate;
import at.petrak.hexcasting.api.casting.iota.Iota;
import java.util.Iterator;

@FunctionalInterface
public interface IotaMultiPredicate {
    public boolean test(Iterable<Iota> var1);

    public static IotaMultiPredicate all(IotaPredicate child) {
        return new All(child);
    }

    public static IotaMultiPredicate pair(IotaPredicate first, IotaPredicate second) {
        return new Pair(first, second);
    }

    public static IotaMultiPredicate triple(IotaPredicate first, IotaPredicate second, IotaPredicate third) {
        return new Triple(first, second, third);
    }

    public static IotaMultiPredicate any(IotaPredicate needs, IotaPredicate fallback) {
        return new Any(needs, fallback);
    }

    public static IotaMultiPredicate either(IotaMultiPredicate first, IotaMultiPredicate second) {
        return new Either(first, second);
    }

    public record All(IotaPredicate inner) implements IotaMultiPredicate
    {
        @Override
        public boolean test(Iterable<Iota> iotas) {
            for (Iota iota : iotas) {
                if (this.inner.test(iota)) continue;
                return false;
            }
            return true;
        }
    }

    public record Pair(IotaPredicate first, IotaPredicate second) implements IotaMultiPredicate
    {
        @Override
        public boolean test(Iterable<Iota> iotas) {
            Iterator<Iota> it = iotas.iterator();
            return it.hasNext() && this.first.test(it.next()) && it.hasNext() && this.second.test(it.next()) && !it.hasNext();
        }
    }

    public record Triple(IotaPredicate first, IotaPredicate second, IotaPredicate third) implements IotaMultiPredicate
    {
        @Override
        public boolean test(Iterable<Iota> iotas) {
            Iterator<Iota> it = iotas.iterator();
            return it.hasNext() && this.first.test(it.next()) && it.hasNext() && this.second.test(it.next()) && it.hasNext() && this.third.test(it.next()) && !it.hasNext();
        }
    }

    public record Any(IotaPredicate needs, IotaPredicate fallback) implements IotaMultiPredicate
    {
        @Override
        public boolean test(Iterable<Iota> iotas) {
            boolean ok = false;
            for (Iota iota : iotas) {
                if (this.needs.test(iota)) {
                    ok = true;
                    continue;
                }
                if (this.fallback.test(iota)) continue;
                return false;
            }
            return ok;
        }
    }

    public record Either(IotaMultiPredicate first, IotaMultiPredicate second) implements IotaMultiPredicate
    {
        @Override
        public boolean test(Iterable<Iota> iotas) {
            return this.first.test(iotas) || this.second.test(iotas);
        }
    }
}

