/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.circles;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.casting.circles.CircleExecutionState;
import at.petrak.hexcasting.api.casting.circles.ICircleComponent;
import at.petrak.hexcasting.api.misc.Result;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.common.items.magic.ItemCreativeUnlocker;
import at.petrak.hexcasting.common.lib.HexItems;
import com.mojang.datafixers.util.Pair;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityAbstractImpetus
extends HexBlockEntity
implements WorldlyContainer {
    private static final DecimalFormat DUST_AMOUNT = new DecimalFormat("###,###.##");
    private static final long MAX_CAPACITY = 9000000000000000000L;
    public static final String TAG_EXECUTION_STATE = "executor";
    public static final String TAG_MEDIA = "media";
    public static final String TAG_ERROR_MSG = "errorMsg";
    public static final String TAG_ERROR_DISPLAY = "errorDisplay";
    public static final String TAG_PIGMENT = "pigment";
    @Nullable
    CompoundTag lazyExecutionState;
    @Nullable
    protected CircleExecutionState executionState;
    protected long media = 0L;
    @Nullable
    protected Component displayMsg = null;
    @Nullable
    protected ItemStack displayItem = null;
    @Nullable
    protected FrozenPigment pigment = null;
    private static final int[] MAJOR_SCALE = new int[]{0, 2, 4, 5, 7, 9, 11, 12};
    private static final int[] MINOR_SCALE = new int[]{0, 2, 3, 5, 7, 8, 11, 12};
    private static final int[] DORIAN_SCALE = new int[]{0, 2, 3, 5, 7, 9, 10, 12};
    private static final int[] MIXOLYDIAN_SCALE = new int[]{0, 2, 4, 5, 7, 9, 10, 12};
    private static final int[] BLUES_SCALE = new int[]{0, 3, 5, 6, 7, 10, 12};
    private static final int[] BAD_TIME = new int[]{0, 0, 12, 7, 6, 5, 3, 0, 3, 5};
    private static final int[] SUSSY_BAKA = new int[]{5, 8, 10, 11, 10, 8, 5, 3, 7, 5};
    private static final int[] SLOTS = new int[]{0};

    public BlockEntityAbstractImpetus(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    public Direction getStartDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
    }

    @Nullable
    public Component getDisplayMsg() {
        return this.displayMsg;
    }

    public void clearDisplay() {
        this.displayMsg = null;
        this.displayItem = null;
        this.sync();
    }

    public void postDisplay(Component error, ItemStack display) {
        this.displayMsg = error;
        this.displayItem = display;
        this.sync();
    }

    public void postMishap(Component mishapDisplay) {
        this.postDisplay(mishapDisplay, new ItemStack((ItemLike)Items.f_42710_));
    }

    public void postPrint(Component printDisplay) {
        this.postDisplay(printDisplay, new ItemStack((ItemLike)Items.f_42517_));
    }

    public void postNoExits(BlockPos pos) {
        this.postDisplay((Component)Component.m_237110_((String)"hexcasting.tooltip.circle.no_exit", (Object[])new Object[]{Component.m_237113_((String)pos.m_123344_()).m_130940_(ChatFormatting.RED)}), new ItemStack((ItemLike)Items.f_42438_));
    }

    public void tickExecution() {
        if (this.f_58857_ == null) {
            return;
        }
        this.m_6596_();
        CircleExecutionState state = this.getExecutionState();
        if (state == null) {
            return;
        }
        boolean shouldContinue = state.tick(this);
        if (!shouldContinue) {
            this.endExecution();
            this.executionState = null;
        } else {
            this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), state.getTickSpeed());
        }
    }

    public void endExecution() {
        if (this.executionState == null) {
            return;
        }
        this.executionState.endExecution(this);
    }

    @Nullable
    public CircleExecutionState getExecutionState() {
        if (this.f_58857_ == null) {
            throw new IllegalStateException("didn't you read the doc comment, don't call this if the level is null");
        }
        if (this.executionState != null) {
            return this.executionState;
        }
        if (this.lazyExecutionState != null) {
            this.executionState = CircleExecutionState.load(this.lazyExecutionState, (ServerLevel)this.f_58857_);
        }
        return this.executionState;
    }

    public void startExecution(@Nullable ServerPlayer player) {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.executionState != null) {
            return;
        }
        Result<CircleExecutionState, BlockPos> result = CircleExecutionState.createNew(this, player);
        if (result.isErr()) {
            BlockPos errPos = result.unwrapErr();
            if (errPos == null) {
                ICircleComponent.sfx(this.m_58899_(), this.m_58900_(), this.f_58857_, null, false);
                this.postNoExits(this.m_58899_());
            } else {
                ICircleComponent.sfx(errPos, this.f_58857_.m_8055_(errPos), this.f_58857_, null, false);
                this.postDisplay((Component)Component.m_237110_((String)"hexcasting.tooltip.circle.no_closure", (Object[])new Object[]{Component.m_237113_((String)errPos.m_123344_()).m_130940_(ChatFormatting.RED)}), new ItemStack((ItemLike)Items.f_42655_));
            }
            return;
        }
        this.executionState = result.unwrap();
        this.clearDisplay();
        ServerLevel serverLevel = (ServerLevel)this.f_58857_;
        serverLevel.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), this.executionState.getTickSpeed());
        serverLevel.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockCircleComponent.ENERGIZED, (Comparable)Boolean.valueOf(true)));
    }

    @Contract(pure=true)
    protected static AABB getBounds(List<BlockPos> poses) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : poses) {
            if (pos.m_123341_() < minX) {
                minX = pos.m_123341_();
            }
            if (pos.m_123342_() < minY) {
                minY = pos.m_123342_();
            }
            if (pos.m_123343_() < minZ) {
                minZ = pos.m_123343_();
            }
            if (pos.m_123341_() > maxX) {
                maxX = pos.m_123341_();
            }
            if (pos.m_123342_() > maxY) {
                maxY = pos.m_123342_();
            }
            if (pos.m_123343_() <= maxZ) continue;
            maxZ = pos.m_123343_();
        }
        return new AABB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
    }

    public long getMedia() {
        return this.media;
    }

    public void setMedia(long media) {
        this.media = media;
        this.sync();
    }

    public long extractMediaFromInsertedItem(ItemStack stack, boolean simulate) {
        if (this.media < 0L) {
            return 0L;
        }
        return MediaHelper.extractMedia(stack, this.remainingMediaCapacity(), true, simulate);
    }

    public void insertMedia(ItemStack stack) {
        if (this.getMedia() >= 0L && !stack.m_41619_() && stack.m_41720_() == HexItems.CREATIVE_UNLOCKER) {
            this.setInfiniteMedia();
            stack.m_41774_(1);
        } else {
            long mediamount = this.extractMediaFromInsertedItem(stack, false);
            if (mediamount > 0L) {
                this.media = Math.min(mediamount + this.media, 9000000000000000000L);
                this.sync();
            }
        }
    }

    public void setInfiniteMedia() {
        this.media = -1L;
        this.sync();
    }

    public long remainingMediaCapacity() {
        if (this.media < 0L) {
            return 0L;
        }
        return Math.max(0L, 9000000000000000000L - this.media);
    }

    public FrozenPigment getPigment() {
        if (this.pigment != null) {
            return this.pigment;
        }
        if (this.executionState != null && this.executionState.casterPigment != null) {
            return this.executionState.casterPigment;
        }
        return FrozenPigment.DEFAULT.get();
    }

    @Nullable
    public FrozenPigment setPigment(@Nullable FrozenPigment pigment) {
        this.pigment = pigment;
        return this.pigment;
    }

    @Override
    protected void saveModData(CompoundTag tag) {
        if (this.executionState != null) {
            tag.m_128365_(TAG_EXECUTION_STATE, (Tag)this.executionState.save());
        }
        tag.m_128356_(TAG_MEDIA, this.media);
        if (this.displayMsg != null && this.displayItem != null) {
            tag.m_128359_(TAG_ERROR_MSG, Component.Serializer.m_130703_((Component)this.displayMsg));
            CompoundTag itemTag = new CompoundTag();
            this.displayItem.m_41739_(itemTag);
            tag.m_128365_(TAG_ERROR_DISPLAY, (Tag)itemTag);
        }
        if (this.pigment != null) {
            tag.m_128365_(TAG_PIGMENT, (Tag)this.pigment.serializeToNBT());
        }
    }

    @Override
    protected void loadModData(CompoundTag tag) {
        this.executionState = null;
        this.lazyExecutionState = tag.m_128425_(TAG_EXECUTION_STATE, 10) ? tag.m_128469_(TAG_EXECUTION_STATE) : null;
        if (tag.m_128425_(TAG_MEDIA, 4)) {
            this.media = tag.m_128454_(TAG_MEDIA);
        }
        if (tag.m_128425_(TAG_ERROR_MSG, 8) && tag.m_128425_(TAG_ERROR_DISPLAY, 10)) {
            MutableComponent msg = Component.Serializer.m_130701_((String)tag.m_128461_(TAG_ERROR_MSG));
            ItemStack display = ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_ERROR_DISPLAY));
            this.displayMsg = msg;
            this.displayItem = display;
        } else {
            this.displayMsg = null;
            this.displayItem = null;
        }
        if (tag.m_128425_(TAG_PIGMENT, 10)) {
            this.pigment = FrozenPigment.fromNBT(tag.m_128469_(TAG_PIGMENT));
        }
    }

    public void applyScryingLensOverlay(List<Pair<ItemStack, Component>> lines, BlockState state, BlockPos pos, Player observer, Level world, Direction hitFace) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BlockEntityAbstractImpetus) {
            BlockEntityAbstractImpetus beai = (BlockEntityAbstractImpetus)blockEntity;
            if (beai.getMedia() < 0L) {
                lines.add((Pair<ItemStack, Component>)new Pair((Object)new ItemStack((ItemLike)HexItems.AMETHYST_DUST), (Object)ItemCreativeUnlocker.infiniteMedia(world)));
            } else {
                float dustCount = (float)beai.getMedia() / 10000.0f;
                MutableComponent dustCmp = Component.m_237110_((String)"hexcasting.tooltip.media", (Object[])new Object[]{DUST_AMOUNT.format(dustCount)});
                lines.add((Pair<ItemStack, Component>)new Pair((Object)new ItemStack((ItemLike)HexItems.AMETHYST_DUST), (Object)dustCmp));
            }
            if (this.displayMsg != null && this.displayItem != null) {
                lines.add((Pair<ItemStack, Component>)new Pair((Object)this.displayItem, (Object)this.displayMsg));
            }
        }
    }

    protected int semitoneFromScale(int note) {
        BlockState blockBelow = this.f_58857_.m_8055_(this.m_58899_().m_7495_());
        int[] scale = MAJOR_SCALE;
        if (blockBelow.m_60713_(Blocks.f_50723_)) {
            scale = MINOR_SCALE;
        } else if (blockBelow.m_204336_(BlockTags.f_13103_) || blockBelow.m_204336_(BlockTags.f_13036_)) {
            scale = DORIAN_SCALE;
        } else if (blockBelow.m_60713_(Blocks.f_50039_) || blockBelow.m_60713_(Blocks.f_50032_)) {
            scale = MIXOLYDIAN_SCALE;
        } else if (blockBelow.m_60713_(Blocks.f_50105_) || blockBelow.m_60713_(Blocks.f_50501_) || blockBelow.m_60713_(Blocks.f_50517_) || blockBelow.m_60713_(Blocks.f_50298_) || blockBelow.m_60713_(Blocks.f_50537_) || blockBelow.m_60713_(Blocks.f_50211_) || blockBelow.m_60713_(Blocks.f_50367_)) {
            scale = BLUES_SCALE;
        } else if (blockBelow.m_60713_(Blocks.f_50453_)) {
            scale = BAD_TIME;
        } else if (blockBelow.m_60713_(Blocks.f_50715_)) {
            scale = SUSSY_BAKA;
        }
        note = Mth.m_14045_((int)note, (int)0, (int)(scale.length - 1));
        return scale[note];
    }

    public int[] m_7071_(Direction var1) {
        return SLOTS;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction dir) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int var1, ItemStack var2, Direction var3) {
        return false;
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return true;
    }

    public ItemStack m_8020_(int index) {
        return ItemStack.f_41583_.m_41777_();
    }

    public ItemStack m_7407_(int index, int count) {
        return ItemStack.f_41583_.m_41777_();
    }

    public ItemStack m_8016_(int index) {
        return ItemStack.f_41583_.m_41777_();
    }

    public void m_6836_(int index, ItemStack stack) {
        this.insertMedia(stack);
    }

    public boolean m_6542_(Player player) {
        return false;
    }

    public void m_6211_() {
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (this.remainingMediaCapacity() == 0L) {
            return false;
        }
        if (stack.m_150930_((Item)HexItems.CREATIVE_UNLOCKER)) {
            return true;
        }
        long mediamount = this.extractMediaFromInsertedItem(stack, true);
        return mediamount > 0L;
    }
}

