/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.eval.env;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.advancements.HexAdvancementTriggers;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.eval.CastResult;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.MishapEnvironment;
import at.petrak.hexcasting.api.casting.eval.env.PlayerBasedMishapEnv;
import at.petrak.hexcasting.api.casting.eval.sideeffects.OperatorSideEffect;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.mod.HexStatistics;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.common.lib.HexDamageTypes;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerBasedCastEnv
extends CastingEnvironment {
    public static final double AMBIT_RADIUS = 32.0;
    public static final double SENTINEL_RADIUS = 16.0;
    protected final ServerPlayer caster;
    protected final InteractionHand castingHand;

    protected PlayerBasedCastEnv(ServerPlayer caster, InteractionHand castingHand) {
        super(caster.m_284548_());
        this.caster = caster;
        this.castingHand = castingHand;
    }

    @Override
    public LivingEntity getCastingEntity() {
        return this.caster;
    }

    @Override
    public ServerPlayer getCaster() {
        return this.caster;
    }

    @Override
    public void postExecution(CastResult result) {
        super.postExecution(result);
        for (OperatorSideEffect sideEffect : result.getSideEffects()) {
            if (!(sideEffect instanceof OperatorSideEffect.DoMishap)) continue;
            OperatorSideEffect.DoMishap doMishap = (OperatorSideEffect.DoMishap)sideEffect;
            this.sendMishapMsgToPlayer(doMishap);
        }
    }

    @Override
    protected List<ItemStack> getUsableStacks(CastingEnvironment.StackDiscoveryMode mode) {
        return this.getUsableStacksForPlayer(mode, this.castingHand, this.caster);
    }

    @Override
    protected List<CastingEnvironment.HeldItemInfo> getPrimaryStacks() {
        return this.getPrimaryStacksForPlayer(this.castingHand, this.caster);
    }

    @Override
    public boolean replaceItem(Predicate<ItemStack> stackOk, ItemStack replaceWith, @Nullable InteractionHand hand) {
        return this.replaceItemForPlayer(stackOk, replaceWith, hand, this.caster);
    }

    @Override
    public boolean isVecInRangeEnvironment(Vec3 vec) {
        Sentinel sentinel = HexAPI.instance().getSentinel(this.caster);
        if (sentinel != null && sentinel.extendsRange() && this.caster.m_9236_().m_46472_() == sentinel.dimension() && vec.m_82557_(sentinel.position()) <= 256.00000000001) {
            return true;
        }
        return vec.m_82557_(this.caster.m_20182_()) <= 1024.00000000001;
    }

    @Override
    public boolean hasEditPermissionsAtEnvironment(BlockPos pos) {
        return this.caster.f_8941_.m_9290_() != GameType.ADVENTURE && this.world.m_7966_((Player)this.caster, pos);
    }

    protected long extractMediaFromInventory(long costLeft, boolean allowOvercast, boolean simulate) {
        ADMediaHolder source;
        long found;
        List<ADMediaHolder> sources = MediaHelper.scanPlayerForMediaStuff(this.caster);
        long startCost = costLeft;
        Iterator<ADMediaHolder> iterator = sources.iterator();
        while (iterator.hasNext() && (costLeft -= (found = MediaHelper.extractMedia(source = iterator.next(), costLeft, false, simulate))) > 0L) {
        }
        if (costLeft > 0L && allowOvercast) {
            double mediaToHealth = HexConfig.common().mediaToHealthRate();
            double healthToRemove = Math.max((double)costLeft / mediaToHealth, 0.5);
            if (simulate) {
                long simulatedRemovedMedia = Mth.m_14165_((double)(Math.min((double)this.caster.m_21223_(), healthToRemove) * mediaToHealth));
                costLeft -= simulatedRemovedMedia;
            } else {
                double mediaAbleToCastFromHP = (double)this.caster.m_21223_() * mediaToHealth;
                Mishap.trulyHurt((LivingEntity)this.caster, this.caster.m_269291_().m_269079_(HexDamageTypes.OVERCAST), (float)healthToRemove);
                int actuallyTaken = Mth.m_14165_((double)(mediaAbleToCastFromHP - (double)this.caster.m_21223_() * mediaToHealth));
                HexAdvancementTriggers.OVERCAST_TRIGGER.trigger(this.caster, actuallyTaken);
                this.caster.m_36222_(HexStatistics.MEDIA_OVERCAST, actuallyTaken);
                costLeft -= (long)actuallyTaken;
            }
        }
        if (!simulate) {
            this.caster.m_36222_(HexStatistics.MEDIA_USED, (int)(startCost - costLeft));
            HexAdvancementTriggers.SPEND_MEDIA_TRIGGER.trigger(this.caster, startCost - costLeft, costLeft < 0L ? -costLeft : 0L);
        }
        return costLeft;
    }

    protected boolean canOvercast() {
        Advancement adv = this.world.m_7654_().m_129889_().m_136041_(HexAPI.modLoc("y_u_no_cast_angy"));
        PlayerAdvancements advs = this.caster.m_8960_();
        return advs.m_135996_(adv).m_8193_();
    }

    @Override
    @Nullable
    public FrozenPigment setPigment(@Nullable FrozenPigment pigment) {
        return IXplatAbstractions.INSTANCE.setPigment((Player)this.caster, pigment);
    }

    @Override
    public void produceParticles(ParticleSpray particles, FrozenPigment pigment) {
        particles.sprayParticles(this.world, pigment);
    }

    @Override
    public Vec3 mishapSprayPos() {
        return this.caster.m_20182_();
    }

    @Override
    public MishapEnvironment getMishapEnvironment() {
        return new PlayerBasedMishapEnv(this.caster);
    }

    protected void sendMishapMsgToPlayer(OperatorSideEffect.DoMishap mishap) {
        Component msg = mishap.getMishap().errorMessageWithName(this, mishap.getErrorCtx());
        if (msg != null) {
            this.caster.m_213846_(msg);
        }
    }

    @Override
    protected boolean isCreativeMode() {
        return this.caster.m_150110_().f_35937_;
    }

    @Override
    public void printMessage(Component message) {
        this.caster.m_213846_(message);
    }
}

