/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleIota
extends Iota {
    public static final double TOLERANCE = 1.0E-4;
    public static IotaType<DoubleIota> TYPE = new IotaType<DoubleIota>(){

        @Override
        @Nullable
        public DoubleIota deserialize(Tag tag, ServerLevel world) throws IllegalArgumentException {
            return DoubleIota.deserialize(tag);
        }

        @Override
        public Component display(Tag tag) {
            return DoubleIota.display(DoubleIota.deserialize(tag).getDouble());
        }

        @Override
        public int color() {
            return -11141291;
        }
    };

    public DoubleIota(double d) {
        super(HexIotaTypes.DOUBLE, d);
    }

    public double getDouble() {
        return HexUtils.fixNAN((Double)this.payload);
    }

    @Override
    public boolean isTruthy() {
        return this.getDouble() != 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean toleratesOther(Iota that) {
        if (!DoubleIota.typesMatch(this, that)) return false;
        if (!(that instanceof DoubleIota)) return false;
        DoubleIota dd = (DoubleIota)that;
        if (!DoubleIota.tolerates(this.getDouble(), dd.getDouble())) return false;
        return true;
    }

    public static boolean tolerates(double a, double b) {
        return Math.abs(a - b) < 1.0E-4;
    }

    @Override
    @NotNull
    public Tag serialize() {
        return DoubleTag.m_128500_((double)this.getDouble());
    }

    public static DoubleIota deserialize(Tag tag) throws IllegalArgumentException {
        DoubleTag dtag = (DoubleTag)HexUtils.downcast(tag, DoubleTag.f_128494_);
        return new DoubleIota(dtag.m_7061_());
    }

    public static Component display(double d) {
        return Component.m_237113_((String)String.format("%.2f", d)).m_130940_(ChatFormatting.GREEN);
    }
}

