/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.api.client.ScryingLensOverlayRegistry;
import at.petrak.hexcasting.api.pigment.ColorProvider;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.api.utils.QuaternionfUtils;
import at.petrak.hexcasting.client.ClientTickCounter;
import at.petrak.hexcasting.common.lib.HexAttributes;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class HexAdditionalRenderers {
    public static void overlayLevel(PoseStack ps, float partialTick) {
        Sentinel sentinel;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (sentinel = IXplatAbstractions.INSTANCE.getSentinel((Player)player)) != null && player.m_9236_().m_46472_().equals(sentinel.dimension())) {
            HexAdditionalRenderers.renderSentinel(sentinel, player, ps, partialTick);
        }
    }

    public static void overlayGui(GuiGraphics graphics, float partialTicks) {
        HexAdditionalRenderers.tryRenderScryingLensOverlay(graphics, partialTicks);
    }

    private static void renderSentinel(Sentinel sentinel, LocalPlayer owner, PoseStack ps, float partialTicks) {
        ps.m_85836_();
        Minecraft mc = Minecraft.m_91087_();
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 playerPos = camera.m_90583_();
        ps.m_85837_(sentinel.position().f_82479_ - playerPos.f_82479_, sentinel.position().f_82480_ - playerPos.f_82480_, sentinel.position().f_82481_ - playerPos.f_82481_);
        float time = ClientTickCounter.getTotal() / 2.0f;
        float bobSpeed = 0.05f;
        float magnitude = 0.1f;
        ps.m_252880_(0.0f, Mth.m_14031_((float)(bobSpeed * time)) * magnitude, 0.0f);
        float spinSpeed = 0.033333335f;
        ps.m_252781_(QuaternionfUtils.fromXYZ(new Vector3f(0.0f, spinSpeed * time, 0.0f)));
        if (sentinel.extendsRange()) {
            ps.m_252781_(QuaternionfUtils.fromXYZ(new Vector3f(spinSpeed * time / 8.0f, 0.0f, 0.0f)));
        }
        float scale = 0.5f;
        ps.m_85841_(scale, scale, scale);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buf = tess.m_85915_();
        Matrix4f neo = ps.m_85850_().m_252922_();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172757_);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.lineWidth((float)5.0f);
        FrozenPigment pigment = IXplatAbstractions.INSTANCE.getPigment((Player)owner);
        ColorProvider colProvider = pigment.getColorProvider();
        BiConsumer<float[], float[]> v = (l, r) -> {
            int lcolor = colProvider.getColor(time, new Vec3((double)l[0], (double)l[1], (double)l[2]));
            int rcolor = colProvider.getColor(time, new Vec3((double)r[0], (double)r[1], (double)r[2]));
            Vector3f normal = new Vector3f(r[0] - l[0], r[1] - l[1], r[2] - l[2]);
            normal.normalize();
            buf.m_252986_(neo, l[0], l[1], l[2]).m_193479_(lcolor).m_252939_(ps.m_85850_().m_252943_(), normal.x(), normal.y(), normal.z()).m_5752_();
            buf.m_252986_(neo, r[0], r[1], r[2]).m_193479_(rcolor).m_252939_(ps.m_85850_().m_252943_(), -normal.x(), -normal.y(), -normal.z()).m_5752_();
        };
        buf.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
        for (int side = 0; side <= 1; ++side) {
            int i;
            float[][] ring = side == 0 ? Icos.BOTTOM_RING : Icos.TOP_RING;
            float[] apex = side == 0 ? Icos.BOTTOM : Icos.TOP;
            for (i = 0; i < 5; ++i) {
                v.accept(apex, ring[i]);
            }
            for (i = 0; i < 5; ++i) {
                v.accept(ring[i % 5], ring[(i + 1) % 5]);
            }
        }
        for (int i = 0; i < 5; ++i) {
            float[] bottom = Icos.BOTTOM_RING[i];
            v.accept(Icos.TOP_RING[(i + 2) % 5], bottom);
            v.accept(bottom, Icos.TOP_RING[(i + 3) % 5]);
        }
        tess.m_85914_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        ps.m_85849_();
    }

    private static void tryRenderScryingLensOverlay(GuiGraphics graphics, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        PoseStack ps = graphics.m_280168_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (player == null || level == null) {
            return;
        }
        if (player.m_21133_(HexAttributes.SCRY_SIGHT) <= 0.0) {
            return;
        }
        HitResult hitRes = mc.f_91077_;
        if (hitRes != null && hitRes.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult bhr = (BlockHitResult)hitRes;
            BlockPos pos = bhr.m_82425_();
            BlockState bs = level.m_8055_(pos);
            List<Pair<ItemStack, Component>> lines = ScryingLensOverlayRegistry.getLines(bs, pos, (Player)player, (Level)level, bhr.m_82434_());
            int totalHeight = 8;
            ArrayList actualLines = Lists.newArrayList();
            Window window = mc.m_91268_();
            int maxWidth = (int)((float)window.m_85445_() / 2.0f * 0.8f);
            for (Pair<ItemStack, Component> pair : lines) {
                Objects.requireNonNull(mc.f_91062_);
                totalHeight += 9 + 6;
                Component text = (Component)pair.getSecond();
                List textLines = mc.f_91062_.m_92865_().m_92414_((FormattedText)text, maxWidth, Style.f_131099_);
                actualLines.add(Pair.of((Object)((ItemStack)pair.getFirst()), (Object)textLines));
                if (textLines.size() <= 1) continue;
                Objects.requireNonNull(mc.f_91062_);
                totalHeight += 9 * (textLines.size() - 1);
            }
            if (!lines.isEmpty()) {
                float x = (float)window.m_85445_() / 2.0f + 8.0f;
                float y = (float)window.m_85446_() / 2.0f - (float)totalHeight;
                ps.m_85836_();
                ps.m_252880_(x, y, 0.0f);
                for (Pair pair : actualLines) {
                    ItemStack stack = (ItemStack)pair.getFirst();
                    if (!stack.m_41619_()) {
                        graphics.m_280480_((ItemStack)pair.getFirst(), 0, 0);
                    }
                    int tx = stack.m_41619_() ? 0 : 18;
                    int ty = 5;
                    List text = (List)pair.getSecond();
                    for (FormattedText line : text) {
                        FormattedCharSequence actualLine = Language.m_128107_().m_5536_(line);
                        graphics.m_280648_(mc.f_91062_, actualLine, tx, ty, -1);
                        Objects.requireNonNull(mc.f_91062_);
                        ps.m_252880_(0.0f, 9.0f, 0.0f);
                    }
                    if (text.isEmpty()) {
                        Objects.requireNonNull(mc.f_91062_);
                        ps.m_252880_(0.0f, 9.0f, 0.0f);
                    }
                    ps.m_252880_(0.0f, 6.0f, 0.0f);
                }
                ps.m_85849_();
            }
        }
    }

    private static class Icos {
        public static float[] TOP = new float[]{0.0f, 1.0f, 0.0f};
        public static float[] BOTTOM = new float[]{0.0f, -1.0f, 0.0f};
        public static float[][] TOP_RING = new float[5][];
        public static float[][] BOTTOM_RING = new float[5][];

        private Icos() {
        }

        static {
            float theta = (float)Mth.m_14136_((double)0.5, (double)1.0);
            for (int i = 0; i < 5; ++i) {
                float phi = (float)i / 5.0f * ((float)Math.PI * 2);
                float x = Mth.m_14089_((float)theta) * Mth.m_14089_((float)phi);
                float y = Mth.m_14031_((float)theta);
                float z = Mth.m_14089_((float)theta) * Mth.m_14031_((float)phi);
                Icos.TOP_RING[i] = new float[]{x, y, z};
                Icos.BOTTOM_RING[i] = new float[]{-x, -y, -z};
            }
        }
    }
}

