/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.client.ClientTickCounter;
import at.petrak.hexcasting.client.render.RenderLib;
import at.petrak.hexcasting.client.render.VCDrawHelper;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a<\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n\u001a<\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017\u001ad\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!\u001a>\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0001\u001a.\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017\u001a \u0010*\u001a\b\u0012\u0004\u0012\u00020\n0\u001a\"\u0004\b\u0000\u0010+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0-\u001a8\u0010.\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100/2\u0006\u00100\u001a\u0002012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u00020\u0001\u001a\u001e\u00104\u001a\u00020!2\u0006\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020!\u001ab\u00107\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u001a2\u0006\u00109\u001a\u00020\n2\u0006\u0010:\u001a\u00020\u00012\u0006\u0010;\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!\u001a^\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u00105\u001a\u00020\u00012\u0006\u00106\u001a\u00020\u00012\u0006\u0010C\u001a\u00020\u00012\u0006\u0010D\u001a\u00020\u00012\u0006\u0010E\u001a\u00020\u00012\u0014\b\u0002\u0010F\u001a\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020H0GH\u0007\u001a6\u0010I\u001a\u00020\f2\u0006\u0010J\u001a\u00020K2\u0006\u00105\u001a\u00020\u00012\u0006\u00106\u001a\u00020\u00012\u0006\u0010L\u001a\u00020\u00012\u0006\u0010M\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\n\u001a\u0016\u0010N\u001a\u00020\u00112\u0006\u0010O\u001a\u00020\u00112\u0006\u0010P\u001a\u00020\u0001\u001a\u000e\u0010Q\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010R\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006S"}, d2={"CAP_THETA", "", "DEFAULT_LAST_SEGMENT_LEN_PROP", "DEFAULT_READABILITY_OFFSET", "NOISE", "Lnet/minecraft/world/level/levelgen/synth/SimplexNoise;", "getNOISE", "()Lnet/minecraft/world/level/levelgen/synth/SimplexNoise;", "dodge", "n", "", "drawLineSeq", "", "mat", "Lorg/joml/Matrix4f;", "points", "", "Lnet/minecraft/world/phys/Vec2;", "width", "z", "tail", "head", "vcHelper", "Lat/petrak/hexcasting/client/render/VCDrawHelper;", "drawPatternFromPoints", "dupIndices", "", "drawLast", "", "flowIrregular", "readabilityOffset", "lastSegmentLenProportion", "seed", "", "drawSpot", "point", "radius", "r", "g", "b", "a", "color", "findDupIndices", "T", "pts", "", "getCenteredPattern", "Lkotlin/Pair;", "pattern", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "height", "minSize", "getNoise", "x", "y", "makeZappy", "barePoints", "hops", "variance", "speed", "renderEntity", "graphics", "Lnet/minecraft/client/gui/GuiGraphics;", "entity", "Lnet/minecraft/world/entity/Entity;", "world", "Lnet/minecraft/world/level/Level;", "rotation", "renderScale", "offset", "bufferTransformer", "Lkotlin/Function1;", "Lnet/minecraft/client/renderer/MultiBufferSource;", "renderQuad", "ps", "Lcom/mojang/blaze3d/vertex/PoseStack;", "w", "h", "rotate", "vec", "theta", "screen", "screenCol", "hexcasting-forge-1.20.1"})
@JvmName(name="RenderLib")
public final class RenderLib {
    @NotNull
    private static final SimplexNoise NOISE = new SimplexNoise((RandomSource)new SingleThreadedRandomSource(9001L));
    public static final float CAP_THETA = 18.0f;
    public static final float DEFAULT_READABILITY_OFFSET = 0.2f;
    public static final float DEFAULT_LAST_SEGMENT_LEN_PROP = 0.8f;

    @NotNull
    public static final SimplexNoise getNOISE() {
        return NOISE;
    }

    public static final double getNoise(double x, double y, double z) {
        return NOISE.m_75467_(x * 0.6, y * 0.6, z * 0.6) / 2.0;
    }

    public static final void drawLineSeq(@NotNull Matrix4f mat, @NotNull List<? extends Vec2> points, float width, float z, int tail, int head) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        Intrinsics.checkNotNullParameter(points, (String)"points");
        RenderLib.drawLineSeq(mat, points, width, tail, head, new VCDrawHelper.Basic(z, null, 2, null));
    }

    public static final void drawLineSeq(@NotNull Matrix4f mat, @NotNull List<? extends Vec2> points, float width, int tail, int head, @NotNull VCDrawHelper vcHelper) {
        Vec2 p2;
        Vec2 p1;
        int i;
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)vcHelper, (String)"vcHelper");
        if (points.size() <= 1) {
            return;
        }
        float r1 = FastColor.ARGB32.m_13665_((int)tail);
        float g1 = FastColor.ARGB32.m_13667_((int)tail);
        float b1 = FastColor.ARGB32.m_13669_((int)tail);
        int a = FastColor.ARGB32.m_13655_((int)tail);
        float a1 = a;
        int headSource = Screen.m_96637_() != HexConfig.client().ctrlTogglesOffStrokeOrder() ? head : tail;
        float r2 = FastColor.ARGB32.m_13665_((int)headSource);
        float g2 = FastColor.ARGB32.m_13667_((int)headSource);
        float b2 = FastColor.ARGB32.m_13669_((int)headSource);
        float a2 = FastColor.ARGB32.m_13655_((int)headSource);
        Ref.ObjectRef vc = new Ref.ObjectRef();
        vc.element = vcHelper.vcSetupAndSupply(VertexFormat.Mode.TRIANGLES);
        int n = points.size();
        float[] joinAngles = new float[n];
        float[] joinOffsets = new float[n];
        for (i = 2; i < n; ++i) {
            float angle;
            Vec2 p0 = points.get(i - 2);
            p1 = points.get(i - 1);
            p2 = points.get(i);
            Vec2 prev = p1.m_165910_(p0.m_165913_());
            Vec2 next = p2.m_165910_(p1.m_165913_());
            joinAngles[i - 1] = angle = (float)Mth.m_14136_((double)(prev.f_82470_ * next.f_82471_ - prev.f_82471_ * next.f_82470_), (double)(prev.f_82470_ * next.f_82470_ + prev.f_82471_ * next.f_82471_));
            float clamp = RangesKt.coerceAtMost((float)prev.m_165907_(), (float)next.m_165907_()) / (width * 0.5f);
            joinOffsets[i - 1] = Mth.m_14036_((float)(Mth.m_14031_((float)angle) / (1.0f + Mth.m_14089_((float)angle))), (float)(-clamp), (float)clamp);
        }
        int n2 = points.size() - 1;
        block1: for (i = 0; i < n2; ++i) {
            p1 = points.get(i);
            p2 = points.get(i + 1);
            Vec2 tangent = p2.m_165910_(p1.m_165913_()).m_165902_().m_165903_(width * 0.5f);
            Vec2 normal = new Vec2(-tangent.f_82471_, tangent.f_82470_);
            int color1 = RenderLib.drawLineSeq$color(a1, a2, r1, r2, g1, g2, b1, b2, (float)i / (float)n);
            int color2 = RenderLib.drawLineSeq$color(a1, a2, r1, r2, g1, g2, b1, b2, ((float)i + 1.0f) / (float)n);
            float jlow = joinOffsets[i];
            float jhigh = joinOffsets[i + 1];
            Vec2 p1Down = p1.m_165910_(tangent.m_165903_(Math.max(0.0f, jlow))).m_165910_(normal);
            Vec2 p1Up = p1.m_165910_(tangent.m_165903_(Math.max(0.0f, -jlow))).m_165910_(normal.m_165913_());
            Vec2 p2Down = p2.m_165910_(tangent.m_165903_(Math.max(0.0f, jhigh)).m_165913_()).m_165910_(normal);
            Vec2 p2Up = p2.m_165910_(tangent.m_165903_(Math.max(0.0f, -jhigh)).m_165913_()).m_165910_(normal.m_165913_());
            VertexConsumer vertexConsumer = (VertexConsumer)vc.element;
            Intrinsics.checkNotNullExpressionValue((Object)p1Down, (String)"p1Down");
            vcHelper.vertex(vertexConsumer, color1, p1Down, mat);
            vcHelper.vertex((VertexConsumer)vc.element, color1, p1, mat);
            VertexConsumer vertexConsumer2 = (VertexConsumer)vc.element;
            Intrinsics.checkNotNullExpressionValue((Object)p1Up, (String)"p1Up");
            vcHelper.vertex(vertexConsumer2, color1, p1Up, mat);
            vcHelper.vertex((VertexConsumer)vc.element, color1, p1Down, mat);
            vcHelper.vertex((VertexConsumer)vc.element, color1, p1Up, mat);
            VertexConsumer vertexConsumer3 = (VertexConsumer)vc.element;
            Intrinsics.checkNotNullExpressionValue((Object)p2Up, (String)"p2Up");
            vcHelper.vertex(vertexConsumer3, color2, p2Up, mat);
            vcHelper.vertex((VertexConsumer)vc.element, color1, p1Down, mat);
            vcHelper.vertex((VertexConsumer)vc.element, color2, p2Up, mat);
            vcHelper.vertex((VertexConsumer)vc.element, color2, p2, mat);
            vcHelper.vertex((VertexConsumer)vc.element, color1, p1Down, mat);
            vcHelper.vertex((VertexConsumer)vc.element, color2, p2, mat);
            VertexConsumer vertexConsumer4 = (VertexConsumer)vc.element;
            Intrinsics.checkNotNullExpressionValue((Object)p2Down, (String)"p2Down");
            vcHelper.vertex(vertexConsumer4, color2, p2Down, mat);
            if (i <= 0) continue;
            float sangle = joinAngles[i];
            float angle = Math.abs(sangle);
            Vec2 rnormal = normal.m_165913_();
            int joinSteps = Mth.m_14167_((float)(angle * (float)180 / 56.548668f));
            if (joinSteps < 1) continue;
            if (sangle < 0.0f) {
                Vec2 prevVert = new Vec2(p1.f_82470_ - rnormal.f_82470_, p1.f_82471_ - rnormal.f_82471_);
                int j = 1;
                if (j > joinSteps) continue;
                while (true) {
                    Intrinsics.checkNotNullExpressionValue((Object)rnormal, (String)"rnormal");
                    Vec2 fan = RenderLib.rotate(rnormal, -sangle * ((float)j / (float)joinSteps));
                    Vec2 fanShift = new Vec2(p1.f_82470_ - fan.f_82470_, p1.f_82471_ - fan.f_82471_);
                    vcHelper.vertex((VertexConsumer)vc.element, color1, p1, mat);
                    vcHelper.vertex((VertexConsumer)vc.element, color1, prevVert, mat);
                    vcHelper.vertex((VertexConsumer)vc.element, color1, fanShift, mat);
                    prevVert = fanShift;
                    if (j == joinSteps) continue block1;
                    ++j;
                }
            }
            Vec2 startFan = RenderLib.rotate(normal, -sangle);
            Vec2 prevVert = new Vec2(p1.f_82470_ - startFan.f_82470_, p1.f_82471_ - startFan.f_82471_);
            for (int j = joinSteps - 1; -1 < j; --j) {
                Vec2 fan = RenderLib.rotate(normal, -sangle * ((float)j / (float)joinSteps));
                Vec2 fanShift = new Vec2(p1.f_82470_ - fan.f_82470_, p1.f_82471_ - fan.f_82471_);
                vcHelper.vertex((VertexConsumer)vc.element, color1, p1, mat);
                vcHelper.vertex((VertexConsumer)vc.element, color1, prevVert, mat);
                vcHelper.vertex((VertexConsumer)vc.element, color1, fanShift, mat);
                prevVert = fanShift;
            }
        }
        vcHelper.vcEndDrawer((VertexConsumer)vc.element);
        RenderLib.drawLineSeq$drawCaps(width, (Ref.ObjectRef<VertexConsumer>)vc, vcHelper, mat, FastColor.ARGB32.m_13660_((int)((int)a1), (int)((int)r1), (int)((int)g1), (int)((int)b1)), points.get(0), points.get(1));
        RenderLib.drawLineSeq$drawCaps(width, (Ref.ObjectRef<VertexConsumer>)vc, vcHelper, mat, FastColor.ARGB32.m_13660_((int)((int)a2), (int)((int)r2), (int)((int)g2), (int)((int)b2)), points.get(n - 1), points.get(n - 2));
    }

    @NotNull
    public static final Vec2 rotate(@NotNull Vec2 vec, float theta) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        float cos = Mth.m_14089_((float)theta);
        float sin = Mth.m_14031_((float)theta);
        return new Vec2(vec.f_82470_ * cos - vec.f_82471_ * sin, vec.f_82471_ * cos + vec.f_82470_ * sin);
    }

    public static final void drawPatternFromPoints(@NotNull Matrix4f mat, @NotNull List<? extends Vec2> points, @Nullable Set<Integer> dupIndices, boolean drawLast, int tail, int head, float flowIrregular, float readabilityOffset, float lastSegmentLenProportion, double seed) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        Intrinsics.checkNotNullParameter(points, (String)"points");
        List<Vec2> zappyPts = RenderLib.makeZappy(points, dupIndices, 10, 2.5f, 0.1f, flowIrregular, readabilityOffset, lastSegmentLenProportion, seed);
        List nodes = drawLast ? points : CollectionsKt.dropLast(points, (int)1);
        RenderLib.drawLineSeq(mat, zappyPts, 5.0f, 0.0f, tail, head);
        RenderLib.drawLineSeq(mat, zappyPts, 2.0f, 1.0f, RenderLib.screenCol(tail), RenderLib.screenCol(head));
        for (Vec2 node : nodes) {
            RenderLib.drawSpot(mat, node, 2.0f, RenderLib.dodge(FastColor.ARGB32.m_13665_((int)head)) / 255.0f, RenderLib.dodge(FastColor.ARGB32.m_13667_((int)head)) / 255.0f, RenderLib.dodge(FastColor.ARGB32.m_13669_((int)head)) / 255.0f, (float)FastColor.ARGB32.m_13655_((int)head) / 255.0f);
        }
    }

    @NotNull
    public static final List<Vec2> makeZappy(@NotNull List<? extends Vec2> barePoints, @Nullable Set<Integer> dupIndices, int hops, float variance, float speed, float flowIrregular, float readabilityOffset, float lastSegmentLenProportion, double seed) {
        List list;
        Intrinsics.checkNotNullParameter(barePoints, (String)"barePoints");
        if (barePoints.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List points = new ArrayList();
        List daisyChain = new ArrayList();
        if (dupIndices != null) {
            Iterator iterator = CollectionsKt.zipWithNext((Iterable)barePoints).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                Pair pair = (Pair)iterator.next();
                Vec2 head = (Vec2)pair.component1();
                Vec2 tail = (Vec2)pair.component2();
                Vec2 tangent = tail.m_165910_(head.m_165913_()).m_165903_(readabilityOffset);
                if (i != 0 && dupIndices.contains(i)) {
                    Vec2 vec2 = head.m_165910_(tangent);
                    Intrinsics.checkNotNullExpressionValue((Object)vec2, (String)"head.add(tangent)");
                    daisyChain.add(vec2);
                } else {
                    daisyChain.add(head);
                }
                if (i == barePoints.size() - 2) {
                    daisyChain.add(tail);
                    points.addAll((Collection)RenderLib.makeZappy$zappify(speed, hops, variance, lastSegmentLenProportion, flowIrregular, seed, daisyChain, true));
                    continue;
                }
                if (!dupIndices.contains(i + 1)) continue;
                Vec2 vec2 = tail.m_165910_(tangent.m_165913_());
                Intrinsics.checkNotNullExpressionValue((Object)vec2, (String)"tail.add(tangent.negated())");
                daisyChain.add(vec2);
                points.addAll((Collection)RenderLib.makeZappy$zappify(speed, hops, variance, lastSegmentLenProportion, flowIrregular, seed, daisyChain, false));
                daisyChain.clear();
            }
            list = points;
        } else {
            list = RenderLib.makeZappy$zappify(speed, hops, variance, lastSegmentLenProportion, flowIrregular, seed, barePoints, true);
        }
        return list;
    }

    @NotNull
    public static final <T> Set<Integer> findDupIndices(@NotNull Iterable<? extends T> pts) {
        Intrinsics.checkNotNullParameter(pts, (String)"pts");
        HashMap<T, Integer> dedup = new HashMap<T, Integer>();
        HashSet<Integer> found = new HashSet<Integer>();
        Iterator<T> iterator = pts.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            T pt = iterator.next();
            Integer ix = (Integer)dedup.get(pt);
            if (ix != null) {
                found.add(i);
                found.add(ix);
                continue;
            }
            dedup.put(pt, i);
        }
        return found;
    }

    public static final void drawSpot(@NotNull Matrix4f mat, @NotNull Vec2 point, float radius, float r, float g, float b, float a) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        RenderLib.drawSpot(mat, point, radius, FastColor.ARGB32.m_13660_((int)((int)(a * (float)255)), (int)((int)(r * (float)255)), (int)((int)(g * (float)255)), (int)((int)(b * (float)255))), new VCDrawHelper.Basic(1.0f, null, 2, null));
    }

    public static final void drawSpot(@NotNull Matrix4f mat, @NotNull Vec2 point, float radius, int color, @NotNull VCDrawHelper vcHelper) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)vcHelper, (String)"vcHelper");
        VertexConsumer vc = vcHelper.vcSetupAndSupply(VertexFormat.Mode.TRIANGLE_FAN);
        vcHelper.vertex(vc, color, point, mat);
        int fracOfCircle = 6;
        int i = 0;
        while (true) {
            float theta = (float)i / (float)fracOfCircle * ((float)Math.PI * 2);
            float rx = Mth.m_14089_((float)theta) * radius + point.f_82470_;
            float ry = Mth.m_14031_((float)theta) * radius + point.f_82471_;
            vcHelper.vertex(vc, color, new Vec2(rx, ry), mat);
            if (i == fracOfCircle) break;
            ++i;
        }
        vcHelper.vcEndDrawer(vc);
    }

    public static final int screenCol(int n) {
        return FastColor.ARGB32.m_13660_((int)FastColor.ARGB32.m_13655_((int)n), (int)RenderLib.screen(FastColor.ARGB32.m_13665_((int)n)), (int)RenderLib.screen(FastColor.ARGB32.m_13667_((int)n)), (int)RenderLib.screen(FastColor.ARGB32.m_13669_((int)n)));
    }

    public static final int screen(int n) {
        return (n + 255) / 2;
    }

    public static final float dodge(int n) {
        return (float)n * 0.9f;
    }

    @NotNull
    public static final Pair<Float, List<Vec2>> getCenteredPattern(@NotNull HexPattern pattern, float width, float height, float minSize) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Vec2 com1 = HexPattern.getCenter$default(pattern, 1.0f, null, 2, null);
        Vec2 vec2 = Vec2.f_82462_;
        Intrinsics.checkNotNullExpressionValue((Object)vec2, (String)"ZERO");
        List<Vec2> lines1 = pattern.toLines(1.0f, vec2);
        float maxDx = -1.0f;
        float maxDy = -1.0f;
        for (Vec2 dot : lines1) {
            float dy;
            float dx = Mth.m_14154_((float)(dot.f_82470_ - com1.f_82470_));
            if (dx > maxDx) {
                maxDx = dx;
            }
            if (!((dy = Mth.m_14154_((float)(dot.f_82471_ - com1.f_82471_))) > maxDy)) continue;
            maxDy = dy;
        }
        float scale = Math.min(minSize, Math.min(width / 3.0f / maxDx, height / 3.0f / maxDy));
        Vec2 com2 = HexPattern.getCenter$default(pattern, scale, null, 2, null);
        Vec2 vec22 = com2.m_165913_();
        Intrinsics.checkNotNullExpressionValue((Object)vec22, (String)"com2.negated()");
        List<Vec2> lines2 = pattern.toLines(scale, vec22);
        return TuplesKt.to((Object)Float.valueOf(scale), lines2);
    }

    @JvmOverloads
    public static final void renderEntity(@NotNull GuiGraphics graphics, @NotNull Entity entity, @NotNull Level world, float x, float y, float rotation, float renderScale, float offset, @NotNull Function1<? super MultiBufferSource, ? extends MultiBufferSource> bufferTransformer) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(bufferTransformer, (String)"bufferTransformer");
        float rotation2 = Screen.m_96638_() ? 0.0f : rotation;
        PoseStack ps = graphics.m_280168_();
        ps.m_85836_();
        ps.m_85837_((double)x, (double)y, 50.0);
        ps.m_85841_(renderScale, renderScale, renderScale);
        ps.m_85837_(0.0, (double)offset, 0.0);
        ps.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        ps.m_252781_(Axis.f_252436_.m_252977_(rotation2));
        EntityRenderDispatcher erd = Minecraft.m_91087_().m_91290_();
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        erd.m_114468_(false);
        Intrinsics.checkNotNullExpressionValue((Object)immediate, (String)"immediate");
        erd.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, ps, (MultiBufferSource)bufferTransformer.invoke((Object)immediate), 0xF000F0);
        erd.m_114468_(true);
        immediate.m_109911_();
        ps.m_85849_();
    }

    public static /* synthetic */ void renderEntity$default(GuiGraphics guiGraphics, Entity entity, Level level, float f, float f2, float f3, float f4, float f5, Function1 function1, int n, Object object) {
        if ((n & 0x100) != 0) {
            function1 = renderEntity.1.INSTANCE;
        }
        RenderLib.renderEntity(guiGraphics, entity, level, f, f2, f3, f4, f5, (Function1<? super MultiBufferSource, ? extends MultiBufferSource>)function1);
    }

    public static final void renderQuad(@NotNull PoseStack ps, float x, float y, float w, float h, int color) {
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        Matrix4f mat = ps.m_85850_().m_252922_();
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buf = tess.m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buf.m_252986_(mat, x, y, 0.0f).m_193479_(color).m_5752_();
        buf.m_252986_(mat, x, y + h, 0.0f).m_193479_(color).m_5752_();
        buf.m_252986_(mat, x + w, y + h, 0.0f).m_193479_(color).m_5752_();
        buf.m_252986_(mat, x + w, y, 0.0f).m_193479_(color).m_5752_();
        tess.m_85914_();
    }

    @JvmOverloads
    public static final void renderEntity(@NotNull GuiGraphics graphics, @NotNull Entity entity, @NotNull Level world, float x, float y, float rotation, float renderScale, float offset) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        RenderLib.renderEntity$default(graphics, entity, world, x, y, rotation, renderScale, offset, null, 256, null);
    }

    private static final int drawLineSeq$color(float a1, float a2, float r1, float r2, float g1, float g2, float b1, float b2, float time) {
        return FastColor.ARGB32.m_13660_((int)((int)Mth.m_14179_((float)time, (float)a1, (float)a2)), (int)((int)Mth.m_14179_((float)time, (float)r1, (float)r2)), (int)((int)Mth.m_14179_((float)time, (float)g1, (float)g2)), (int)((int)Mth.m_14179_((float)time, (float)b1, (float)b2)));
    }

    private static final void drawLineSeq$drawCaps(float $width, Ref.ObjectRef<VertexConsumer> vc, VCDrawHelper $vcHelper, Matrix4f $mat, int color, Vec2 point, Vec2 prev) {
        Vec2 tangent = point.m_165910_(prev.m_165913_()).m_165902_().m_165903_(0.5f * $width);
        Vec2 normal = new Vec2(-tangent.f_82471_, tangent.f_82470_);
        int joinSteps = Mth.m_14167_((float)10.0f);
        vc.element = $vcHelper.vcSetupAndSupply(VertexFormat.Mode.TRIANGLE_FAN);
        $vcHelper.vertex((VertexConsumer)vc.element, color, point, $mat);
        for (int j = joinSteps; -1 < j; --j) {
            Vec2 fan = RenderLib.rotate(normal, (float)(-Math.PI) * ((float)j / (float)joinSteps));
            $vcHelper.vertex((VertexConsumer)vc.element, color, new Vec2(point.f_82470_ + fan.f_82470_, point.f_82471_ + fan.f_82471_), $mat);
        }
        $vcHelper.vcEndDrawer((VertexConsumer)vc.element);
    }

    private static final List<Vec2> makeZappy$zappify(float $speed, int $hops, float $variance, float $lastSegmentLenProportion, float $flowIrregular, double $seed, List<? extends Vec2> points, boolean truncateLast) {
        Function1 scaleVariance2 = makeZappy.zappify.scaleVariance.1.INSTANCE;
        double zSeed = (double)ClientTickCounter.getTotal() * (double)$speed;
        ArrayList<Vec2> zappyPts = new ArrayList<Vec2>(points.size() * $hops);
        zappyPts.add(points.get(0));
        Iterator iterator = CollectionsKt.zipWithNext((Iterable)points).iterator();
        int n = 0;
        block0: while (iterator.hasNext()) {
            int i = n++;
            Pair pair = (Pair)iterator.next();
            Vec2 src = (Vec2)pair.component1();
            Vec2 target = (Vec2)pair.component2();
            Vec2 delta = target.m_165910_(src.m_165913_());
            float hopDist = Mth.m_14116_((float)src.m_165914_(target)) / (float)$hops;
            float maxVariance = hopDist * $variance;
            int j = 1;
            int maxJ = truncateLast && i == points.size() - 2 ? MathKt.roundToInt((float)($lastSegmentLenProportion * (float)$hops)) : $hops;
            if (j > maxJ) continue;
            while (true) {
                double progress = (double)j / (double)($hops + 1);
                Vec2 pos = src.m_165910_(delta.m_165903_((float)progress));
                double minorPerturb = RenderLib.getNoise(i, j, Math.sin(zSeed)) * (double)$flowIrregular;
                float theta = (float)((double)3 * RenderLib.getNoise((double)i + progress + minorPerturb - zSeed, 1337.0, $seed) * (Math.PI * 2));
                float r = (float)(RenderLib.getNoise((double)i + progress - zSeed, 69420.0, $seed) * (double)maxVariance * ((Number)scaleVariance2.invoke((Object)progress)).doubleValue());
                Vec2 randomHop = new Vec2(r * Mth.m_14089_((float)theta), r * Mth.m_14031_((float)theta));
                zappyPts.add(pos.m_165910_(randomHop));
                if (j == $hops) {
                    zappyPts.add(target);
                }
                if (j == maxJ) continue block0;
                ++j;
            }
        }
        return zappyPts;
    }
}

