/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.entities;

import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.entities.HexEntities;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.common.msgs.MsgNewWallScrollS2C;
import at.petrak.hexcasting.common.msgs.MsgRecalcWallScrollDisplayS2C;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityWallScroll
extends HangingEntity {
    private static final EntityDataAccessor<Boolean> SHOWS_STROKE_ORDER = SynchedEntityData.m_135353_(EntityWallScroll.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public ItemStack scroll;
    @Nullable
    public HexPattern pattern;
    public boolean isAncient;
    public int blockSize;

    public EntityWallScroll(EntityType<? extends EntityWallScroll> type, Level world) {
        super(type, world);
    }

    public EntityWallScroll(Level world, BlockPos pos, Direction dir, ItemStack scroll, boolean showStrokeOrder, int blockSize) {
        super(HexEntities.WALL_SCROLL, world, pos);
        this.m_6022_(dir);
        this.blockSize = blockSize;
        this.f_19804_.m_135381_(SHOWS_STROKE_ORDER, (Object)showStrokeOrder);
        this.scroll = scroll;
        this.recalculateDisplay();
        this.m_7087_();
    }

    public void recalculateDisplay() {
        CompoundTag patternTag = NBTHelper.getCompound(this.scroll, "pattern");
        if (patternTag != null) {
            this.pattern = HexPattern.fromNBT(patternTag);
            this.isAncient = NBTHelper.hasString(this.scroll, "op_id");
        } else {
            this.pattern = null;
            this.isAncient = false;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOWS_STROKE_ORDER, (Object)false);
    }

    public boolean getShowsStrokeOrder() {
        return (Boolean)this.f_19804_.m_135370_(SHOWS_STROKE_ORDER);
    }

    public void setShowsStrokeOrder(boolean b) {
        this.f_19804_.m_135381_(SHOWS_STROKE_ORDER, (Object)b);
    }

    public int m_7076_() {
        return 16 * this.blockSize;
    }

    public int m_7068_() {
        return 16 * this.blockSize;
    }

    public void m_5553_(@Nullable Entity pBrokenEntity) {
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
            if (pBrokenEntity instanceof Player) {
                Player player = (Player)pBrokenEntity;
                if (player.m_150110_().f_35937_) {
                    return;
                }
            }
            this.m_19983_(this.scroll);
        }
    }

    public InteractionResult m_7111_(Player pPlayer, Vec3 pVec, InteractionHand pHand) {
        ItemStack handStack = pPlayer.m_21120_(pHand);
        if (handStack.m_150930_(HexItems.AMETHYST_DUST) && !this.getShowsStrokeOrder()) {
            if (!pPlayer.m_150110_().f_35937_) {
                handStack.m_41774_(1);
            }
            this.setShowsStrokeOrder(true);
            pPlayer.m_9236_().m_6269_(pPlayer, (Entity)this, HexSounds.SCROLL_DUST, SoundSource.PLAYERS, 1.0f, 1.0f);
            Level level = pPlayer.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel slevel = (ServerLevel)level;
                IXplatAbstractions.INSTANCE.sendPacketNear(this.m_20182_(), 32.0, slevel, new MsgRecalcWallScrollDisplayS2C(this.m_19879_(), true));
            } else {
                this.recalculateDisplay();
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(pPlayer, pVec, pHand);
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12176_, 1.0f, 1.0f);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return IXplatAbstractions.INSTANCE.toVanillaClientboundPacket(new MsgNewWallScrollS2C(new ClientboundAddEntityPacket((Entity)this), this.f_31698_, this.f_31699_, this.scroll, this.getShowsStrokeOrder(), this.blockSize));
    }

    public void readSpawnData(BlockPos pos, Direction dir, ItemStack scrollItem, boolean showsStrokeOrder, int blockSize) {
        this.f_31698_ = pos;
        this.scroll = scrollItem;
        this.blockSize = blockSize;
        this.m_6022_(dir);
        this.setShowsStrokeOrder(showsStrokeOrder);
        this.recalculateDisplay();
        this.m_7087_();
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128344_("direction", (byte)this.f_31699_.ordinal());
        tag.m_128365_("scroll", (Tag)HexUtils.serializeToNBT(this.scroll));
        tag.m_128379_("showsStrokeOrder", this.getShowsStrokeOrder());
        tag.m_128405_("blockSize", this.blockSize);
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        this.f_31699_ = Direction.values()[tag.m_128445_("direction")];
        this.scroll = ItemStack.m_41712_((CompoundTag)tag.m_128469_("scroll"));
        this.blockSize = tag.m_128451_("blockSize");
        this.m_6022_(this.f_31699_);
        this.setShowsStrokeOrder(tag.m_128471_("showsStrokeOrder"));
        this.recalculateDisplay();
        this.m_7087_();
        super.m_7378_(tag);
    }

    public void m_7678_(double pX, double pY, double pZ, float pYaw, float pPitch) {
        this.m_6034_(pX, pY, pZ);
    }

    public void m_6453_(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport) {
        BlockPos blockpos = this.f_31698_.m_7918_((int)(pX - this.m_20185_()), (int)(pY - this.m_20186_()), (int)(pZ - this.m_20189_()));
        this.m_6034_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.scroll.m_41777_();
    }
}

