/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.xplat;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.addldata.ADHexHolder;
import at.petrak.hexcasting.api.addldata.ADIotaHolder;
import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.addldata.ADPigment;
import at.petrak.hexcasting.api.addldata.ADVariantItem;
import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.arithmetic.Arithmetic;
import at.petrak.hexcasting.api.casting.castables.SpecialHandler;
import at.petrak.hexcasting.api.casting.eval.ResolvedPattern;
import at.petrak.hexcasting.api.casting.eval.env.StaffCastEnv;
import at.petrak.hexcasting.api.casting.eval.sideeffects.EvalSound;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.eval.vm.ContinuationFrame;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.pigment.ColorProvider;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.player.AltioraAbility;
import at.petrak.hexcasting.api.player.FlightAbility;
import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.HexRegistries;
import at.petrak.hexcasting.common.lib.hex.HexContinuationTypes;
import at.petrak.hexcasting.common.lib.hex.HexEvalSounds;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import at.petrak.hexcasting.common.msgs.IMessage;
import at.petrak.hexcasting.forge.cap.CapSyncers;
import at.petrak.hexcasting.forge.cap.HexCapabilities;
import at.petrak.hexcasting.forge.interop.curios.CuriosApiInterop;
import at.petrak.hexcasting.forge.mixin.ForgeAccessorBuiltInRegistries;
import at.petrak.hexcasting.forge.network.ForgePacketHandler;
import at.petrak.hexcasting.forge.network.MsgBrainsweepAck;
import at.petrak.hexcasting.forge.recipe.ForgeUnsealedIngredient;
import at.petrak.hexcasting.interop.pehkui.PehkuiInterop;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import at.petrak.hexcasting.xplat.IXplatTags;
import at.petrak.hexcasting.xplat.Platform;
import com.google.common.base.Suppliers;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.loot.CanToolPerformAction;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.caelus.api.CaelusApi;
import virtuoel.pehkui.api.ScaleTypes;

public class ForgeXplatImpl
implements IXplatAbstractions {
    private static final IXplatTags TAGS = new IXplatTags(){

        @Override
        public TagKey<Item> amethystDust() {
            return HexTags.Items.create(new ResourceLocation("forge", "dusts/amethyst"));
        }

        @Override
        public TagKey<Item> gems() {
            return HexTags.Items.create(new ResourceLocation("forge", "gems"));
        }
    };
    private static final Supplier<Registry<ActionRegistryEntry>> ACTION_REGISTRY = Suppliers.memoize(() -> ForgeAccessorBuiltInRegistries.hex$registerSimple(HexRegistries.ACTION, null));
    private static final Supplier<Registry<SpecialHandler.Factory<?>>> SPECIAL_HANDLER_REGISTRY = Suppliers.memoize(() -> ForgeAccessorBuiltInRegistries.hex$registerSimple(HexRegistries.SPECIAL_HANDLER, null));
    private static final Supplier<Registry<IotaType<?>>> IOTA_TYPE_REGISTRY = Suppliers.memoize(() -> ForgeAccessorBuiltInRegistries.hex$registerDefaulted(HexRegistries.IOTA_TYPE, HexAPI.modLoc("null").toString(), registry -> HexIotaTypes.NULL));
    private static final Supplier<Registry<Arithmetic>> ARITHMETIC_REGISTRY = Suppliers.memoize(() -> ForgeAccessorBuiltInRegistries.hex$registerSimple(HexRegistries.ARITHMETIC, null));
    private static final Supplier<Registry<ContinuationFrame.Type<?>>> CONTINUATION_TYPE_REGISTRY = Suppliers.memoize(() -> ForgeAccessorBuiltInRegistries.hex$registerDefaulted(HexRegistries.CONTINUATION_TYPE, HexAPI.modLoc("end").toString(), registry -> HexContinuationTypes.END));
    private static final Supplier<Registry<EvalSound>> EVAL_SOUND_REGISTRY = Suppliers.memoize(() -> ForgeAccessorBuiltInRegistries.hex$registerDefaulted(HexRegistries.EVAL_SOUND, HexAPI.modLoc("nothing").toString(), registry -> HexEvalSounds.NOTHING));
    private static PehkuiInterop.ApiAbstraction PEHKUI_API = null;
    public static final String TAG_BRAINSWEPT = "hexcasting:brainswept";
    public static final String TAG_SENTINEL_EXISTS = "hexcasting:sentinel_exists";
    public static final String TAG_SENTINEL_GREATER = "hexcasting:sentinel_extends_range";
    public static final String TAG_SENTINEL_POSITION = "hexcasting:sentinel_position";
    public static final String TAG_SENTINEL_DIMENSION = "hexcasting:sentinel_dimension";
    public static final String TAG_PIGMENT = "hexcasting:pigment";
    public static final String TAG_FLIGHT_ALLOWED = "hexcasting:flight_allowed";
    public static final String TAG_FLIGHT_TIME = "hexcasting:flight_time";
    public static final String TAG_FLIGHT_ORIGIN = "hexcasting:flight_origin";
    public static final String TAG_FLIGHT_DIMENSION = "hexcasting:flight_dimension";
    public static final String TAG_FLIGHT_RADIUS = "hexcasting:flight_radius";
    public static final String TAG_ALTIORA_ALLOWED = "hexcasting:altiora_allowed";
    public static final String TAG_ALTIORA_GRACE = "hexcasting:altiora_grace_period";
    public static final UUID ALTIORA_ATTRIBUTE_ID = UUID.fromString("91897c79-3ebb-468c-a265-40418ed01c41");
    public static final String TAG_HARNESS = "hexcasting:spell_harness";
    public static final String TAG_PATTERNS = "hexcasting:spell_patterns";

    @Override
    public Platform platform() {
        return Platform.FORGE;
    }

    @Override
    public boolean isPhysicalClient() {
        return FMLLoader.getDist() == Dist.CLIENT;
    }

    @Override
    public boolean isModPresent(String id) {
        return ModList.get().isLoaded(id);
    }

    @Override
    public void initPlatformSpecific() {
        if (this.isModPresent("curios")) {
            CuriosApiInterop.init();
        }
    }

    @Override
    public void setBrainsweepAddlData(Mob mob) {
        mob.getPersistentData().m_128379_(TAG_BRAINSWEPT, true);
        if (mob.m_9236_() instanceof ServerLevel) {
            ForgePacketHandler.getNetwork().send(PacketDistributor.TRACKING_ENTITY.with(() -> mob), (Object)MsgBrainsweepAck.of((Entity)mob));
        }
    }

    @Override
    public void setFlight(ServerPlayer player, FlightAbility flight) {
        CompoundTag tag = player.getPersistentData();
        tag.m_128379_(TAG_FLIGHT_ALLOWED, flight != null);
        if (flight != null) {
            tag.m_128405_(TAG_FLIGHT_TIME, flight.timeLeft());
            tag.m_128365_(TAG_FLIGHT_ORIGIN, (Tag)HexUtils.serializeToNBT(flight.origin()));
            tag.m_128359_(TAG_FLIGHT_DIMENSION, flight.dimension().m_135782_().toString());
            tag.m_128347_(TAG_FLIGHT_RADIUS, flight.radius());
        } else {
            tag.m_128473_(TAG_FLIGHT_TIME);
            tag.m_128473_(TAG_FLIGHT_ORIGIN);
            tag.m_128473_(TAG_FLIGHT_DIMENSION);
            tag.m_128473_(TAG_FLIGHT_RADIUS);
        }
    }

    @Override
    public void setAltiora(Player player, @Nullable AltioraAbility altiora) {
        CompoundTag tag = player.getPersistentData();
        tag.m_128379_(TAG_ALTIORA_ALLOWED, altiora != null);
        if (altiora != null) {
            tag.m_128405_(TAG_ALTIORA_GRACE, altiora.gracePeriod());
        } else {
            tag.m_128473_(TAG_ALTIORA_ALLOWED);
        }
        Attribute elytraing = CaelusApi.getInstance().getFlightAttribute();
        AttributeInstance inst = player.m_21204_().m_22146_(elytraing);
        if (altiora != null) {
            if (inst.m_22111_(ALTIORA_ATTRIBUTE_ID) == null) {
                inst.m_22118_(new AttributeModifier(ALTIORA_ATTRIBUTE_ID, "Altiora", 1.0, AttributeModifier.Operation.ADDITION));
            }
        } else {
            inst.m_22120_(ALTIORA_ATTRIBUTE_ID);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CapSyncers.syncAltiora(serverPlayer);
        }
    }

    @Override
    @Nullable
    public FrozenPigment setPigment(Player player, @Nullable FrozenPigment pigment) {
        FrozenPigment old = this.getPigment(player);
        CompoundTag tag = player.getPersistentData();
        if (pigment != null) {
            tag.m_128365_(TAG_PIGMENT, (Tag)pigment.serializeToNBT());
        } else {
            tag.m_128473_(TAG_PIGMENT);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CapSyncers.syncPigment(serverPlayer);
        }
        return old;
    }

    @Override
    public void setSentinel(Player player, @Nullable Sentinel sentinel) {
        CompoundTag tag = player.getPersistentData();
        tag.m_128379_(TAG_SENTINEL_EXISTS, sentinel != null);
        if (sentinel != null) {
            tag.m_128379_(TAG_SENTINEL_GREATER, sentinel.extendsRange());
            tag.m_128365_(TAG_SENTINEL_POSITION, (Tag)HexUtils.serializeToNBT(sentinel.position()));
            tag.m_128359_(TAG_SENTINEL_DIMENSION, sentinel.dimension().m_135782_().toString());
        } else {
            tag.m_128473_(TAG_SENTINEL_GREATER);
            tag.m_128473_(TAG_SENTINEL_POSITION);
            tag.m_128473_(TAG_SENTINEL_DIMENSION);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CapSyncers.syncSentinel(serverPlayer);
        }
    }

    @Override
    public void setStaffcastImage(ServerPlayer player, @Nullable CastingImage image) {
        player.getPersistentData().m_128365_(TAG_HARNESS, (Tag)(image == null ? new CompoundTag() : image.serializeToNbt()));
    }

    @Override
    public void setPatterns(ServerPlayer player, List<ResolvedPattern> patterns) {
        ListTag listTag = new ListTag();
        for (ResolvedPattern pattern : patterns) {
            listTag.add((Object)pattern.serializeToNBT());
        }
        player.getPersistentData().m_128365_(TAG_PATTERNS, (Tag)listTag);
    }

    @Override
    public boolean isBrainswept(Mob e) {
        return e.getPersistentData().m_128471_(TAG_BRAINSWEPT);
    }

    @Override
    public FlightAbility getFlight(ServerPlayer player) {
        CompoundTag tag = player.getPersistentData();
        boolean allowed = tag.m_128471_(TAG_FLIGHT_ALLOWED);
        if (allowed) {
            int timeLeft = tag.m_128451_(TAG_FLIGHT_TIME);
            Vec3 origin = HexUtils.vecFromNBT(tag.m_128469_(TAG_FLIGHT_ORIGIN));
            double radius = tag.m_128459_(TAG_FLIGHT_RADIUS);
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_(TAG_FLIGHT_DIMENSION)));
            return new FlightAbility(timeLeft, (ResourceKey<Level>)dimension, origin, radius);
        }
        return null;
    }

    @Override
    public AltioraAbility getAltiora(Player player) {
        CompoundTag tag = player.getPersistentData();
        boolean allowed = tag.m_128471_(TAG_ALTIORA_ALLOWED);
        if (allowed) {
            int grace = tag.m_128451_(TAG_ALTIORA_GRACE);
            return new AltioraAbility(grace);
        }
        return null;
    }

    @Override
    public FrozenPigment getPigment(Player player) {
        return FrozenPigment.fromNBT(player.getPersistentData().m_128469_(TAG_PIGMENT));
    }

    @Override
    public Sentinel getSentinel(Player player) {
        CompoundTag tag = player.getPersistentData();
        boolean exists = tag.m_128471_(TAG_SENTINEL_EXISTS);
        if (!exists) {
            return null;
        }
        boolean extendsRange = tag.m_128471_(TAG_SENTINEL_GREATER);
        Vec3 position = HexUtils.vecFromNBT(tag.m_128469_(TAG_SENTINEL_POSITION));
        ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_(TAG_SENTINEL_DIMENSION)));
        return new Sentinel(extendsRange, position, (ResourceKey<Level>)dimension);
    }

    @Override
    public CastingVM getStaffcastVM(ServerPlayer player, InteractionHand hand) {
        StaffCastEnv ctx = new StaffCastEnv(player, hand);
        return new CastingVM(CastingImage.loadFromNbt(player.getPersistentData().m_128469_(TAG_HARNESS), player.m_284548_()), ctx);
    }

    @Override
    public List<ResolvedPattern> getPatternsSavedInUi(ServerPlayer player) {
        ListTag patternsTag = player.getPersistentData().m_128437_(TAG_PATTERNS, 10);
        ArrayList<ResolvedPattern> patterns = new ArrayList<ResolvedPattern>(patternsTag.size());
        for (int i = 0; i < patternsTag.size(); ++i) {
            patterns.add(ResolvedPattern.fromNBT(patternsTag.m_128728_(i)));
        }
        return patterns;
    }

    @Override
    public void clearCastingData(ServerPlayer player) {
        player.getPersistentData().m_128473_(TAG_HARNESS);
        player.getPersistentData().m_128473_(TAG_PATTERNS);
    }

    @Override
    @Nullable
    public ADMediaHolder findMediaHolder(ItemStack stack) {
        Optional maybeCap = stack.getCapability(HexCapabilities.MEDIA).resolve();
        return maybeCap.orElse(null);
    }

    @Override
    @Nullable
    public ADMediaHolder findMediaHolder(ServerPlayer player) {
        Optional maybeCap = player.getCapability(HexCapabilities.MEDIA).resolve();
        return maybeCap.orElse(null);
    }

    @Override
    @Nullable
    public ADIotaHolder findDataHolder(ItemStack stack) {
        Optional maybeCap = stack.getCapability(HexCapabilities.IOTA).resolve();
        return maybeCap.orElse(null);
    }

    @Override
    @Nullable
    public ADIotaHolder findDataHolder(Entity entity) {
        Optional maybeCap = entity.getCapability(HexCapabilities.IOTA).resolve();
        return maybeCap.orElse(null);
    }

    @Override
    @Nullable
    public ADHexHolder findHexHolder(ItemStack stack) {
        Optional maybeCap = stack.getCapability(HexCapabilities.STORED_HEX).resolve();
        return maybeCap.orElse(null);
    }

    @Override
    @Nullable
    public ADVariantItem findVariantHolder(ItemStack stack) {
        Optional maybeCap = stack.getCapability(HexCapabilities.VARIANT_ITEM).resolve();
        return maybeCap.orElse(null);
    }

    @Override
    public boolean isPigment(ItemStack stack) {
        return stack.getCapability(HexCapabilities.COLOR).isPresent();
    }

    @Override
    public ColorProvider getColorProvider(FrozenPigment pigment) {
        Optional maybePigment = pigment.item().getCapability(HexCapabilities.COLOR).resolve();
        if (maybePigment.isPresent()) {
            return ((ADPigment)maybePigment.get()).provideColor(pigment.owner());
        }
        return ColorProvider.MISSING;
    }

    @Override
    public void sendPacketToPlayer(ServerPlayer target, IMessage packet) {
        ForgePacketHandler.getNetwork().send(PacketDistributor.PLAYER.with(() -> target), (Object)packet);
    }

    @Override
    public void sendPacketNear(Vec3 pos, double radius, ServerLevel dimension, IMessage packet) {
        ForgePacketHandler.getNetwork().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(pos.f_82479_, pos.f_82480_, pos.f_82481_, radius * radius, dimension.m_46472_())), (Object)packet);
    }

    @Override
    public void sendPacketTracking(Entity entity, IMessage packet) {
        ForgePacketHandler.getNetwork().send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)packet);
    }

    @Override
    public Packet<ClientGamePacketListener> toVanillaClientboundPacket(IMessage message) {
        return ForgePacketHandler.getNetwork().toVanillaPacket((Object)message, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BiFunction<BlockPos, BlockState, T> func, Block ... blocks) {
        return BlockEntityType.Builder.m_155273_(func::apply, (Block[])blocks).m_58966_(null);
    }

    @Override
    public boolean tryPlaceFluid(Level level, InteractionHand hand, BlockPos pos, Fluid fluid) {
        Optional handler = FluidUtil.getFluidHandler((Level)level, (BlockPos)pos, (Direction)Direction.UP).resolve();
        return handler.isPresent() && ((IFluidHandler)handler.get()).fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE) > 0;
    }

    @Override
    public boolean drainAllFluid(Level level, BlockPos pos) {
        Optional handler = FluidUtil.getFluidHandler((Level)level, (BlockPos)pos, (Direction)Direction.UP).resolve();
        if (handler.isPresent()) {
            boolean any = false;
            IFluidHandler pool = (IFluidHandler)handler.get();
            for (int i = 0; i < pool.getTanks(); ++i) {
                if (pool.drain(pool.getFluidInTank(i), IFluidHandler.FluidAction.EXECUTE).isEmpty()) continue;
                any = true;
            }
            return any;
        }
        return false;
    }

    @Override
    public Ingredient getUnsealedIngredient(ItemStack stack) {
        return ForgeUnsealedIngredient.of(stack);
    }

    @Override
    public boolean isCorrectTierForDrops(Tier tier, BlockState bs) {
        return !bs.m_60834_() || TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)bs);
    }

    @Override
    public Item.Properties addEquipSlotFabric(EquipmentSlot slot) {
        return new Item.Properties();
    }

    @Override
    public IXplatTags tags() {
        return TAGS;
    }

    @Override
    public LootItemCondition.Builder isShearsCondition() {
        return CanToolPerformAction.canToolPerformAction((ToolAction)ToolActions.SHEARS_DIG);
    }

    @Override
    public String getModName(String namespace) {
        if (namespace.equals("c")) {
            return "Common";
        }
        Optional container = ModList.get().getModContainerById(namespace);
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getModInfo().getDisplayName();
        }
        return namespace;
    }

    @Override
    public Registry<ActionRegistryEntry> getActionRegistry() {
        return ACTION_REGISTRY.get();
    }

    @Override
    public Registry<SpecialHandler.Factory<?>> getSpecialHandlerRegistry() {
        return SPECIAL_HANDLER_REGISTRY.get();
    }

    @Override
    public Registry<IotaType<?>> getIotaTypeRegistry() {
        return IOTA_TYPE_REGISTRY.get();
    }

    @Override
    public Registry<Arithmetic> getArithmeticRegistry() {
        return ARITHMETIC_REGISTRY.get();
    }

    @Override
    public Registry<ContinuationFrame.Type<?>> getContinuationTypeRegistry() {
        return CONTINUATION_TYPE_REGISTRY.get();
    }

    @Override
    public Registry<EvalSound> getEvalSoundRegistry() {
        return EVAL_SOUND_REGISTRY.get();
    }

    @Override
    public boolean isBreakingAllowed(ServerLevel world, BlockPos pos, BlockState state, @Nullable Player player) {
        if (player == null) {
            player = FakePlayerFactory.get((ServerLevel)world, (GameProfile)HEXCASTING);
        }
        return !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent((Level)world, pos, state, player));
    }

    @Override
    public boolean isPlacingAllowed(ServerLevel world, BlockPos pos, ItemStack blockStack, @Nullable Player player) {
        if (player == null) {
            player = FakePlayerFactory.get((ServerLevel)world, (GameProfile)HEXCASTING);
        }
        ItemStack cached = player.m_21205_();
        player.m_21008_(InteractionHand.MAIN_HAND, blockStack.m_41777_());
        PlayerInteractEvent.RightClickBlock evt = ForgeHooks.onRightClickBlock((Player)player, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (BlockHitResult)new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.DOWN, pos, true));
        player.m_21008_(InteractionHand.MAIN_HAND, cached);
        return !evt.isCanceled();
    }

    @Override
    public PehkuiInterop.ApiAbstraction getPehkuiApi() {
        if (!this.isModPresent("pehkui")) {
            throw new IllegalArgumentException("cannot get the pehkui api without pehkui");
        }
        if (PEHKUI_API == null) {
            PEHKUI_API = new PehkuiInterop.ApiAbstraction(){

                @Override
                public float getScale(Entity e) {
                    return ScaleTypes.BASE.getScaleData(e).getScale();
                }

                @Override
                public void setScale(Entity e, float scale) {
                    ScaleTypes.BASE.getScaleData(e).setScale(scale);
                }
            };
        }
        return PEHKUI_API;
    }
}

