/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.interop.patchouli;

import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.recipe.BrainsweepRecipe;
import at.petrak.hexcasting.common.recipe.HexRecipeStuffRegistry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class BrainsweepProcessor
implements IComponentProcessor {
    private BrainsweepRecipe recipe;
    @Nullable
    private String exampleEntityString;

    public void setup(Level level, IVariableProvider vars) {
        ResourceLocation id = new ResourceLocation(vars.get("recipe").asString());
        RecipeManager recman = level.m_7465_();
        List brainsweepings = recman.m_44013_(HexRecipeStuffRegistry.BRAINSWEEP_TYPE);
        for (BrainsweepRecipe poisonApples : brainsweepings) {
            if (!poisonApples.m_6423_().equals((Object)id)) continue;
            this.recipe = poisonApples;
            break;
        }
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return null;
        }
        switch (key) {
            case "header": {
                return IVariable.from((Object)this.recipe.result().m_60734_().m_49954_());
            }
            case "input": {
                List<ItemStack> inputStacks = this.recipe.blockIn().getDisplayedStacks();
                return IVariable.from((Object)inputStacks.toArray(new ItemStack[0]));
            }
            case "result": {
                return IVariable.from((Object)new ItemStack((ItemLike)this.recipe.result().m_60734_()));
            }
            case "entity": {
                if (this.exampleEntityString == null) {
                    Entity entity = this.recipe.entityIn().exampleEntity((Level)Minecraft.m_91087_().f_91073_);
                    if (entity == null) {
                        return null;
                    }
                    StringBuilder bob = new StringBuilder();
                    bob.append(BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()));
                    CompoundTag tag = new CompoundTag();
                    entity.m_20223_(tag);
                    bob.append(tag.toString());
                    this.exampleEntityString = bob.toString();
                }
                return IVariable.wrap((String)this.exampleEntityString);
            }
            case "entityTooltip": {
                Minecraft mc = Minecraft.m_91087_();
                return IVariable.wrapList(this.recipe.entityIn().getTooltip(mc.f_91066_.f_92125_).stream().map(IVariable::from).toList());
            }
            case "mediaCost": {
                record ItemCost(Item item, int cost) {
                    public boolean dividesEvenly(int dividend) {
                        return dividend % this.cost == 0;
                    }
                }
                ItemCost[] costs = new ItemCost[]{new ItemCost(HexItems.AMETHYST_DUST, 10000), new ItemCost(Items.f_151049_, 50000), new ItemCost(HexItems.CHARGED_AMETHYST, 100000)};
                List<IVariable> validItemStacks = Arrays.stream(costs).filter(itemCost -> itemCost.dividesEvenly((int)this.recipe.mediaCost())).map(validItemCost -> new ItemStack((ItemLike)validItemCost.item, (int)this.recipe.mediaCost() / validItemCost.cost)).map(IVariable::from).toList();
                if (!validItemStacks.isEmpty()) {
                    return IVariable.wrapList(validItemStacks);
                }
                return IVariable.from((Object)new ItemStack((ItemLike)HexItems.AMETHYST_DUST, (int)(this.recipe.mediaCost() / 10000L)));
            }
        }
        return null;
    }
}

