/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import codechicken.lib.inventory.InventoryUtils;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;

public class BlockToStackHelper {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    public static FakePlayer harvester = null;
    public static List<ItemStack> itemCollection = null;

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.addListener(BlockToStackHelper::entityJoinWorld);
    }

    public static void entityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof ItemEntity && itemCollection != null && !event.isCanceled()) {
            itemCollection.add(((ItemEntity)event.getEntity()).m_32055_());
            event.setCanceled(true);
        }
    }

    public static List<ItemStack> breakAndCollect(Level world, BlockPos pos, int xp) {
        return BlockToStackHelper.breakAndCollectWithPlayer(world, pos, null, xp);
    }

    public static List<ItemStack> breakAndCollectWithPlayer(Level world, BlockPos pos, Player player, int xp) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (!(world instanceof ServerLevel)) {
            return stacks;
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (player == null) {
            player = BlockToStackHelper.getHarvester((ServerLevel)world);
        }
        itemCollection = new ArrayList<ItemStack>();
        BlockEntity tile = world.m_7702_(pos);
        if (state.onDestroyedByPlayer(world, pos, player, true, world.m_6425_(pos))) {
            block.m_6786_((LevelAccessor)world, pos, state);
            block.m_6240_(world, player, pos, state, tile, player.m_21205_());
        }
        stacks.addAll(itemCollection);
        itemCollection = null;
        return stacks;
    }

    public static void breakAndCollect(Level world, BlockPos pos, InventoryDynamic inventoryDynamic, int xp) {
        BlockToStackHelper.breakAndCollectWithPlayer(world, pos, inventoryDynamic, null, xp);
    }

    public static void breakAndCollectWithPlayer(Level world, BlockPos pos, InventoryDynamic inventoryDynamic, Player player, int xp) {
        List<ItemStack> stacks = BlockToStackHelper.breakAndCollectWithPlayer(world, pos, player, xp);
        for (ItemStack stack : stacks) {
            if (stack == null || stack.m_41619_()) continue;
            InventoryUtils.insertItem((Container)inventoryDynamic, (ItemStack)stack, (boolean)false);
        }
        inventoryDynamic.xp += xp;
    }

    public static FakePlayer getHarvester(ServerLevel world) {
        if (harvester == null) {
            harvester = FakePlayerFactory.get((ServerLevel)world, (GameProfile)new GameProfile(UUID.fromString("060e69c4-6aed-11e6-8b77-86f30ca893d3"), "[Brandons-Core]"));
            harvester.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42390_));
        }
        return harvester;
    }

    public static void startItemCapture() {
        itemCollection = new ArrayList<ItemStack>();
    }

    public static Set<ItemStack> collectAndEndCapture() {
        LinkedHashSet<ItemStack> dropsCopy = new LinkedHashSet<ItemStack>(itemCollection);
        itemCollection = null;
        return dropsCopy;
    }
}

