/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.blocks;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.tile.EldrinCapacitorTile;
import com.mna.api.blocks.tile.IEldrinCapacitorTile;
import com.mna.api.gui.EldrinCapacitorPermissionsContainer;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public abstract class EldrinCapacitorBlock
extends Block
implements EntityBlock {
    protected Affinity[] affinities;

    public EldrinCapacitorBlock(BlockBehaviour.Properties pProperties, Affinity ... affinities) {
        super(pProperties);
        this.affinities = affinities;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        Consumer<FriendlyByteBuf> dataWriter = this.getContainerBufferWriter(state, level, pos, player, hand, hitResult);
        MenuProvider provider = this.getProvider(state, level, pos, player, hand, hitResult);
        if (provider == null || dataWriter == null) {
            return InteractionResult.SUCCESS;
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, dataWriter);
        return InteractionResult.SUCCESS;
    }

    protected MenuProvider getProvider(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity be = level.m_7702_(pos);
        if (be == null || !(be instanceof EldrinCapacitorTile)) {
            return null;
        }
        EldrinCapacitorTile cap = (EldrinCapacitorTile)be;
        if (cap.getPlacedBy() != player.m_36316_().getId()) {
            return null;
        }
        return new SimpleMenuProvider((id, playerInv, user) -> new EldrinCapacitorPermissionsContainer(id, playerInv, cap), (Component)Component.m_237119_());
    }

    protected Consumer<FriendlyByteBuf> getContainerBufferWriter(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity workbench = level.m_7702_(pos);
        if (workbench != null && workbench instanceof EldrinCapacitorTile) {
            EldrinCapacitorTile ecTile = (EldrinCapacitorTile)workbench;
            return ecTile;
        }
        return null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        if (pPlacer instanceof Player) {
            Player player = (Player)pPlacer;
            BlockEntity be = pLevel.m_7702_(pPos);
            if (be instanceof IEldrinCapacitorTile) {
                IEldrinCapacitorTile capTile = (IEldrinCapacitorTile)be;
                capTile.setPlacedBy(player);
                pLevel.m_46745_(pPos).getCapability(ManaAndArtificeMod.getChunkMagicCapability()).ifPresent(magic -> magic.pushKnownEldrinSupplier(pPos));
            }
        }
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void m_6810_(BlockState state, Level pLevel, BlockPos pPos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            pLevel.m_46745_(pPos).getCapability(ManaAndArtificeMod.getChunkMagicCapability()).ifPresent(magic -> magic.popKnownEldrinSupplier(pPos));
        }
        super.m_6810_(state, pLevel, pPos, newState, isMoving);
    }
}

