/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.blocks;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.blocks.BlockWithOffset;
import com.mna.api.blocks.WaterloggableBlock;
import com.mna.api.blocks.WaterloggableBlockWithOffset;
import com.mna.api.blocks.interfaces.IDontCreateBlockItem;
import com.mna.api.blocks.tile.IOffsetTile;
import com.mna.blocks.BlockInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FillerBlock
extends WaterloggableBlock
implements IDontCreateBlockItem,
EntityBlock {
    public FillerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK).m_60955_().m_60978_(1.5f).m_60960_(BlockInit.NEVER), false);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        BlockPos offsetPos = this.getOffsetPos((BlockGetter)world, pos);
        if (!world.m_46859_(offsetPos) && !offsetPos.equals((Object)pos)) {
            world.m_7471_(offsetPos, true);
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos offsetPos = this.getOffsetPos((BlockGetter)world, pos);
        if (!(world.m_46859_(offsetPos) || offsetPos.equals((Object)pos) || newState.m_60734_().equals(Blocks.f_50375_))) {
            world.m_46961_(offsetPos, true);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public PushReaction getPistonPushReaction(BlockState p_149656_1_) {
        return PushReaction.BLOCK;
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return BlockPathTypes.BLOCKED;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        BlockPos offsetPos = this.getOffsetPos((BlockGetter)world, pos);
        if (!world.m_46859_(offsetPos) && !offsetPos.equals((Object)pos)) {
            BlockHitResult brtr = new BlockHitResult(rayTrace.m_82450_(), rayTrace.m_82434_(), offsetPos, rayTrace.m_82436_());
            return world.m_8055_(offsetPos).m_60664_(world, player, hand, brtr);
        }
        return InteractionResult.CONSUME;
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        BlockPos offsetPos = this.getOffsetPos((BlockGetter)level, pos);
        if (!level.m_46859_(offsetPos) && !offsetPos.equals((Object)pos)) {
            level.m_8055_(offsetPos).onNeighborChange(level, offsetPos, neighbor);
        }
        super.onNeighborChange(state, level, offsetPos, neighbor);
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        BlockPos offsetPos = this.getOffsetPos((BlockGetter)pLevel, pPos);
        if (!pLevel.m_46859_(offsetPos) && !offsetPos.equals((Object)pPos)) {
            pLevel.m_8055_(offsetPos).m_60690_(pLevel, offsetPos, pNeighborBlock, pNeighborPos, pMovedByPiston);
        }
        super.m_6861_(pState, pLevel, pPos, pNeighborBlock, pNeighborPos, pMovedByPiston);
    }

    public boolean m_6104_(BlockState p_200122_1_, BlockState p_200122_2_, Direction p_200122_3_) {
        return true;
    }

    private BlockPos getOffsetPos(BlockGetter world, BlockPos origin) {
        IOffsetTile tile = (IOffsetTile)world.m_7702_(origin);
        if (tile == null) {
            return origin;
        }
        BlockPos offset = tile.getOffset();
        return origin.m_121955_((Vec3i)offset);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ManaAndArtificeMod.getTileHelper().createOffsetTile(pos, state);
    }

    public static void setAtOffsetFrom(LevelAccessor world, BlockPos pos, BlockPos offset) {
        Block filler = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("mna", "filler_block"));
        BlockPos offsetPos = pos.m_121955_((Vec3i)offset);
        world.m_7731_(offsetPos, filler.m_49966_(), 3);
        ((IOffsetTile)world.m_7702_(offsetPos)).setOffset(new BlockPos(offset.m_123341_() * -1, offset.m_123342_() * -1, offset.m_123343_() * -1));
    }

    public boolean m_7420_(BlockState p_200123_1_, BlockGetter p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.INVISIBLE;
    }

    protected void m_142387_(Level world, Player player, BlockPos pos, BlockState state) {
        BlockPos offsetPos = this.getOffsetPos((BlockGetter)world, pos);
        BlockState offsetState = world.m_8055_(offsetPos);
        world.m_5898_(player, 2001, pos, FillerBlock.m_49956_((BlockState)offsetState));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        BlockPos offsetPos = this.getOffsetPos(pLevel, pPos);
        if (!offsetPos.equals((Object)pPos)) {
            BlockState offsetState = pLevel.m_8055_(offsetPos);
            Block block = offsetState.m_60734_();
            if (block instanceof BlockWithOffset) {
                BlockWithOffset bwo = (BlockWithOffset)block;
                return bwo.getOffsetShape(pPos.m_121996_((Vec3i)offsetPos), offsetState, offsetPos, pLevel, pContext);
            }
            block = offsetState.m_60734_();
            if (block instanceof WaterloggableBlockWithOffset) {
                WaterloggableBlockWithOffset bwo = (WaterloggableBlockWithOffset)block;
                return bwo.getOffsetShape(pPos.m_121996_((Vec3i)offsetPos), offsetState, offsetPos, pLevel, pContext);
            }
        }
        return Shapes.m_83144_();
    }
}

