/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.blocks;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.WaterloggableBlockWithOffset;
import com.mna.api.blocks.tile.pylon.PylonTileBase;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class PylonBlock
extends WaterloggableBlockWithOffset
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected HashMap<Affinity, Float> powerRequirements = new HashMap();
    protected float radius = 32.0f;
    protected String runeword;
    private static final VoxelShape MAIN_WE = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static final VoxelShape MAIN_NS = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape OFFSET_1_WE = Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0);
    private static final VoxelShape OFFSET_1_NS = Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
    private static final VoxelShape OFFSET_2_WE = Block.m_49796_((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)16.0, (double)14.0);
    private static final VoxelShape OFFSET_2_NS = Block.m_49796_((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)16.0, (double)11.0);

    public PylonBlock(BlockBehaviour.Properties properties, String runeword, BlockPos ... offsets) {
        super(properties, false, offsets);
        this.runeword = runeword;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity block = pLevel.m_7702_(pPos);
        if (block != null && block instanceof PylonTileBase) {
            PylonTileBase pylonTile = (PylonTileBase)block;
            ItemStack stack = pPlayer.m_21120_(pHand);
            if (!stack.m_41619_()) {
                Item debugOrb = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mna", "debug_wand"));
                Item item = stack.m_41720_();
                if (item instanceof DyeItem) {
                    DyeItem dye = (DyeItem)item;
                    if (!pLevel.m_5776_()) {
                        int clr = dye.m_41089_().m_41071_();
                        pylonTile.setColor(new int[]{FastColor.ARGB32.m_13665_((int)clr), FastColor.ARGB32.m_13667_((int)clr), FastColor.ARGB32.m_13669_((int)clr)});
                    }
                } else if (stack.m_41720_() == debugOrb && !pLevel.m_5776_()) {
                    pylonTile.setMapMakerMode();
                    pPlayer.m_213846_((Component)Component.m_237113_((String)"Pylon map maker mode enabled.  Eldrin power requirements removed, and ownership information deleted."));
                }
            }
            if (!pLevel.f_46443_ && !ManaAndArtificeMod.checkMagicUnlock((ServerLevel)pLevel, pPlayer)) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)pylonTile, (BlockPos)pPos);
            }
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity living, ItemStack stack) {
        if (living instanceof Player) {
            Player player = (Player)living;
            PylonTileBase tile = (PylonTileBase)world.m_7702_(pos);
            tile.setOwner(player);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public PylonBlock addPowerRequirement(Affinity aff, float amount) {
        this.powerRequirements.put(aff, Float.valueOf(Math.max(amount, 0.0f)));
        return this;
    }

    public PylonBlock setRadius(float radius) {
        this.radius = radius;
        return this;
    }

    public float getRadius() {
        return this.radius;
    }

    public HashMap<Affinity, Float> getPowerConsumption() {
        return this.powerRequirements;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        boolean sideways = facing == Direction.EAST || facing == Direction.WEST;
        return sideways ? MAIN_WE : MAIN_NS;
    }

    @Override
    public VoxelShape getOffsetShape(BlockPos delta, BlockState state, BlockPos parentPos, BlockGetter pLevel, CollisionContext pContext) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean sideways = facing == Direction.EAST || facing == Direction.WEST;
        switch (delta.m_123342_()) {
            case 1: {
                return sideways ? OFFSET_1_WE : OFFSET_1_NS;
            }
            case 2: {
                return sideways ? OFFSET_2_WE : OFFSET_2_NS;
            }
        }
        return Shapes.m_83144_();
    }
}

