/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.capabilities;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ChronoAnchorData {
    private float health;
    private float mana;
    private int hunger;
    private BlockPos position;
    private ResourceKey<Level> dimension;
    private boolean isValid = false;

    public float getHealth() {
        return this.health;
    }

    public float getMana() {
        return this.mana;
    }

    public int getHunger() {
        return this.hunger;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    protected void setHealth(float health) {
        this.health = health;
    }

    protected void setMana(float mana) {
        this.mana = mana;
    }

    protected void setHunger(int hunger) {
        this.hunger = hunger;
    }

    protected void setPosition(BlockPos position, ResourceKey<Level> dimension) {
        this.position = position;
        this.dimension = dimension;
    }

    public boolean canRevert(Player player) {
        return this.dimension != null && this.dimension.compareTo(player.m_9236_().m_46472_()) == 0;
    }

    public void fromPlayer(Player player) {
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        this.setHealth(player.m_21223_());
        this.setMana(magic == null ? 0.0f : magic.getCastingResource().getAmount());
        this.setPosition(player.m_20183_(), (ResourceKey<Level>)player.m_9236_().m_46472_());
        this.setHunger(player.m_36324_().m_38702_());
        this.isValid = true;
    }

    public void revert(Player player) {
        if (!this.isValid) {
            return;
        }
        if (!this.canRevert(player)) {
            return;
        }
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic != null) {
            magic.getCastingResource().setAmount(this.getMana());
        }
        player.m_21153_(this.getHealth());
        player.m_36324_().m_38705_(this.getHunger());
        player.m_6021_((double)this.getPosition().m_123341_(), (double)this.getPosition().m_123342_(), (double)this.getPosition().m_123343_());
        player.f_19789_ = 0.0f;
        this.isValid = false;
    }

    public void writeToNBT(CompoundTag compound) {
        if (!this.isValid) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("health", this.getHealth());
        nbt.m_128350_("mana", this.getMana());
        nbt.m_128405_("hunger", this.getHunger());
        nbt.m_128405_("x", this.getPosition().m_123341_());
        nbt.m_128405_("y", this.getPosition().m_123342_());
        nbt.m_128405_("z", this.getPosition().m_123343_());
        nbt.m_128359_("dimension_key_value", this.dimension.m_135782_().toString());
        compound.m_128365_("chrono_anchor_data", (Tag)nbt);
    }

    public void readFromNBT(CompoundTag compound) {
        CompoundTag nbt;
        if (compound.m_128441_("chrono_anchor_data") && (nbt = compound.m_128469_("chrono_anchor_data")).m_128441_("health") && nbt.m_128441_("mana") && nbt.m_128441_("hunger") && nbt.m_128441_("x") && nbt.m_128441_("y") && nbt.m_128441_("z") && nbt.m_128441_("dimension_key_value")) {
            this.setHealth(nbt.m_128457_("health"));
            this.setMana(nbt.m_128457_("mana"));
            this.setHunger(nbt.m_128451_("hunger"));
            BlockPos position = new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dimension_key_value")));
            this.setPosition(position, (ResourceKey<Level>)dimension);
            this.isValid = true;
        }
    }
}

