/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.gui;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.tile.EldrinCapacitorTile;
import com.mna.api.faction.IFaction;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;

public class EldrinCapacitorPermissionsContainer
extends AbstractContainerMenu {
    private static final int MAX_INTERACT_DISTANCE = 256;
    private Player user;
    private EldrinCapacitorTile tile;

    public EldrinCapacitorPermissionsContainer(int i, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(i, playerInventory, ((EldrinCapacitorTile)playerInventory.f_35978_.m_9236_().m_7702_(packetBuffer.m_130135_())).readFrom(packetBuffer));
    }

    public EldrinCapacitorPermissionsContainer(int i, Inventory playerInv, EldrinCapacitorTile tile) {
        super(ManaAndArtificeMod.getContainerHelper().GetEldrinPermissionsContainerType(), i);
        this.user = playerInv.f_35978_;
        this.tile = tile;
        this.m_38884_(tile);
        tile.addContainer(this);
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.tile.removeContainer(this);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player pPlayer) {
        if (this.user == null || this.tile == null || this.user != pPlayer) {
            return false;
        }
        return this.tile.m_58899_().m_203198_(pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_()) <= 256.0;
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        switch (pId) {
            case 0: {
                this.toggleShareTeam();
                break;
            }
            case 1: {
                this.toggleShareFaction();
                break;
            }
            case 2: {
                this.toggleSharePublic();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void m_7511_(int pId, int pData) {
        super.m_7511_(pId, pData);
        this.m_38946_();
    }

    public boolean userCanEdit() {
        return this.user.m_36316_().getId().equals(this.tile.getPlacedBy());
    }

    public boolean shareTeam() {
        return ((DataSlot)this.f_38842_.get(0)).m_6501_() == 1;
    }

    public boolean shareFaction() {
        return ((DataSlot)this.f_38842_.get(1)).m_6501_() == 1;
    }

    public boolean sharePublic() {
        return ((DataSlot)this.f_38842_.get(2)).m_6501_() == 1;
    }

    public float getAmount(Affinity affinity) {
        int dataSlotIndex = -1;
        switch (affinity.getShiftAffinity()) {
            case ARCANE: {
                dataSlotIndex = 3;
                break;
            }
            case EARTH: {
                dataSlotIndex = 7;
                break;
            }
            case ENDER: {
                dataSlotIndex = 4;
                break;
            }
            case FIRE: {
                dataSlotIndex = 5;
                break;
            }
            case WATER: {
                dataSlotIndex = 6;
                break;
            }
            case WIND: {
                dataSlotIndex = 8;
                break;
            }
            default: {
                return 0.0f;
            }
        }
        return (float)((DataSlot)this.f_38842_.get(dataSlotIndex)).m_6501_() / 100.0f;
    }

    public float getCapacity(Affinity affinity) {
        return this.tile.getCapacity(affinity);
    }

    public float getChargeRate() {
        return (float)((DataSlot)this.f_38842_.get(9)).m_6501_() / 100.0f * 20.0f;
    }

    public float getDispersalRate() {
        return (float)((DataSlot)this.f_38842_.get(11)).m_6501_() / 100.0f * 20.0f;
    }

    public float getDispersalRadius() {
        return (float)((DataSlot)this.f_38842_.get(10)).m_6501_() / 100.0f;
    }

    public void toggleShareTeam() {
        DataSlot dataSlot = (DataSlot)this.f_38842_.get(0);
        if (dataSlot.m_6501_() == 1) {
            dataSlot.m_6422_(0);
        } else {
            dataSlot.m_6422_(1);
        }
    }

    public void toggleShareFaction() {
        DataSlot dataSlot = (DataSlot)this.f_38842_.get(1);
        if (dataSlot.m_6501_() == 1) {
            dataSlot.m_6422_(0);
        } else {
            dataSlot.m_6422_(1);
        }
    }

    public void toggleSharePublic() {
        DataSlot dataSlot = (DataSlot)this.f_38842_.get(2);
        if (dataSlot.m_6501_() == 1) {
            dataSlot.m_6422_(0);
        } else {
            dataSlot.m_6422_(1);
        }
    }

    @Nullable
    public IFaction getShareFaction() {
        return this.tile.getPlacedByFaction();
    }

    @Nullable
    public String getShareTeam() {
        return this.tile.getPlacedByTeam();
    }

    @Nullable
    public String getPlacedByPlayerName() {
        return this.tile.getPlacedByPlayerName();
    }

    public boolean supplies(Affinity affinity) {
        return this.tile.supplies(affinity);
    }
}

