/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.spells;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.spells.SpellCastingResult;
import com.mna.api.spells.base.ISpellDefinition;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface ICanContainSpell {
    public static final String TRANSCRIBED = "isTranscribedSpellItem";

    default public boolean containsSpell(ItemStack stack) {
        if (ManaAndArtificeMod.getSpellHelper() == null) {
            return false;
        }
        return ManaAndArtificeMod.getSpellHelper().containsSpell(stack);
    }

    @Nonnull
    @Deprecated(forRemoval=true)
    default public ISpellDefinition getSpell(ItemStack stack) {
        return this.getSpell(stack, null);
    }

    @Nonnull
    default public ISpellDefinition getSpell(ItemStack stack, @Nullable Player player) {
        if (ManaAndArtificeMod.getSpellHelper() == null) {
            return ISpellDefinition.EMPTY;
        }
        return ManaAndArtificeMod.getSpellHelper().parseSpellDefinition(stack, player);
    }

    default public ItemStack setSpell(ItemStack stack, ISpellDefinition spell) {
        spell.writeToNBT(stack.m_41784_());
        return stack;
    }

    default public boolean canAcceptSpell(ItemStack stack) {
        return true;
    }

    default public boolean canAcceptSpell(ItemStack stack, ISpellDefinition spell) {
        return true;
    }

    default public void setTranscribedSpell(ItemStack stack) {
        stack.m_41784_().m_128379_(TRANSCRIBED, true);
    }

    default public boolean isTranscribedSpell(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        return stack.m_41784_().m_128471_(TRANSCRIBED);
    }

    default public boolean castFromCurioSlot(ItemStack curioStack, Player caster) {
        if (caster.m_6117_()) {
            return false;
        }
        ISpellDefinition spell = this.getSpell(curioStack, caster);
        if (!spell.isValid()) {
            return false;
        }
        if (caster.m_36335_().m_41519_(curioStack.m_41720_())) {
            return false;
        }
        if (spell.getShape().getPart().replacesHeldItem()) {
            caster.m_213846_((Component)Component.m_237115_((String)"gui.mna.curio-cast.no-bound"));
            return false;
        }
        if (spell.isChanneled()) {
            caster.m_213846_((Component)Component.m_237115_((String)"gui.mna.curio-cast.no-channeled"));
            return false;
        }
        boolean hasCharges = spell.isChargedSpell(curioStack);
        caster.m_21011_(InteractionHand.OFF_HAND, true);
        SpellCastingResult result = ManaAndArtificeMod.getSpellHelper().playerCast(curioStack, caster, InteractionHand.OFF_HAND, !hasCharges, true);
        if (result.getCode().isConsideredSuccess() && hasCharges) {
            spell.consumeCharges(curioStack, caster);
        }
        ManaAndArtificeMod.getSpellHelper().setCooldown(curioStack, caster, spell);
        return true;
    }
}

