/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.artifice;

import com.mna.api.blocks.WaterloggableBlockWithOffset;
import com.mna.api.entities.construct.ConstructSlot;
import com.mna.api.entities.construct.ItemConstructPart;
import com.mna.api.tools.BlockUtilities;
import com.mna.blocks.BlockInit;
import com.mna.blocks.tileentities.ConstructWorkbenchTile;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.items.ItemInit;
import com.mna.items.constructs.BellOfBidding;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;

public class ConstructWorkbenchBlock
extends WaterloggableBlockWithOffset
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty HAS_PART = BooleanProperty.m_61465_((String)"has_construct_part");
    private final BlockPos[] offsetsWE = new BlockPos[]{new BlockPos(0, 0, -1), new BlockPos(0, 0, 1), new BlockPos(0, 1, 0), new BlockPos(0, 1, -1), new BlockPos(0, 1, 1), new BlockPos(0, 2, 0), new BlockPos(0, 2, -1), new BlockPos(0, 2, 1)};
    private final BlockPos[] offsetsNS = new BlockPos[]{new BlockPos(-1, 0, 0), new BlockPos(1, 0, 0), new BlockPos(0, 1, 0), new BlockPos(-1, 1, 0), new BlockPos(1, 1, 0), new BlockPos(0, 2, 0), new BlockPos(-1, 2, 0), new BlockPos(1, 2, 0)};
    private static final VoxelShape TOP_RIGHT_CORNER = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)7.0, (double)9.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.0, (double)4.0, (double)5.0, (double)12.0, (double)16.0, (double)11.0), Block.m_49796_((double)7.0, (double)9.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0)});
    private static final VoxelShape TOP_LEFT_CORNER = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)5.0, (double)7.0, (double)16.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)4.0, (double)5.0, (double)9.0, (double)16.0, (double)11.0), Block.m_49796_((double)7.0, (double)0.0, (double)5.0, (double)16.0, (double)9.0, (double)11.0)});
    private static final VoxelShape MIDDLE_LEFT = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)3.0, (double)14.0, (double)2.0, (double)13.0), (VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)5.0, (double)14.0, (double)16.0, (double)11.0));
    private static final VoxelShape MIDDLE_RIGHT = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)8.0, (double)2.0, (double)13.0), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)5.0, (double)8.0, (double)16.0, (double)11.0));
    private static final VoxelShape BOTTOM_LEFT = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOTTOM_RIGHT = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape TOP_CENTER = Block.m_49796_((double)0.0, (double)9.5, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
    private static final VoxelShape CENTER_THIN_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
    private static final VoxelShape[] CENTERS = new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, CENTER_THIN_NORTH), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, CENTER_THIN_NORTH), CENTER_THIN_NORTH, BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, CENTER_THIN_NORTH)};
    private static final VoxelShape[] TOP_RIGHT_CORNERS = new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, TOP_RIGHT_CORNER), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, TOP_RIGHT_CORNER), TOP_RIGHT_CORNER, BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, TOP_RIGHT_CORNER)};
    private static final VoxelShape[] TOP_LEFT_CORNERS = new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, TOP_LEFT_CORNER), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, TOP_LEFT_CORNER), TOP_LEFT_CORNER, BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, TOP_LEFT_CORNER)};
    private static final VoxelShape[] MIDDLE_LEFTS = new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, MIDDLE_LEFT), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, MIDDLE_LEFT), MIDDLE_LEFT, BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, MIDDLE_LEFT)};
    private static final VoxelShape[] MIDDLE_RIGHTS = new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, MIDDLE_RIGHT), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, MIDDLE_RIGHT), MIDDLE_RIGHT, BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, MIDDLE_RIGHT)};
    private static final VoxelShape[] BOTTOM_LEFTS = new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, BOTTOM_LEFT), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, BOTTOM_LEFT), BOTTOM_LEFT, BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, BOTTOM_LEFT)};
    private static final VoxelShape[] BOTTOM_RIGHTS = new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, BOTTOM_RIGHT), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, BOTTOM_RIGHT), BOTTOM_RIGHT, BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, BOTTOM_RIGHT)};
    private static final VoxelShape[] TOP_CENTERS = new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, TOP_CENTER), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, TOP_CENTER), TOP_CENTER, BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, TOP_CENTER)};
    private static final VoxelShape[] MIDDLE_LEFTS_FULL = new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)MIDDLE_LEFT)), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)MIDDLE_LEFT)), Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)MIDDLE_LEFT), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)MIDDLE_LEFT))};
    private static final VoxelShape[] MIDDLE_RIGHTS_FULL = new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)MIDDLE_RIGHT)), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)MIDDLE_RIGHT)), Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)MIDDLE_RIGHT), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)MIDDLE_RIGHT))};
    private static final VoxelShape[] BOTTOM_LEFTS_FULL = new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)BOTTOM_LEFT)), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)BOTTOM_LEFT)), Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)BOTTOM_LEFT), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)BOTTOM_LEFT))};
    private static final VoxelShape[] BOTTOM_RIGHTS_FULL = new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)BOTTOM_RIGHT)), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)BOTTOM_RIGHT)), Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)BOTTOM_RIGHT), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)BOTTOM_RIGHT))};
    private static final VoxelShape[] TOP_CENTERS_FULL = new VoxelShape[]{BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)TOP_CENTER)), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)TOP_CENTER)), Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)TOP_CENTER), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, Shapes.m_83110_((VoxelShape)CENTER_THIN_NORTH, (VoxelShape)TOP_CENTER))};

    public ConstructWorkbenchBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60955_().m_60960_(BlockInit.NEVER).m_60978_(3.0f).m_60953_(b -> 15), false, new BlockPos[0]);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_PART, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{HAS_PART});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
        BlockPos pos = context.m_8083_();
        for (BlockPos offset : this.getOffsets(state)) {
            FluidState flState;
            BlockPos offsetPos = pos.m_121955_((Vec3i)offset);
            if (context.m_43725_().m_46859_(offsetPos) || (flState = context.m_43725_().m_6425_(offsetPos)) != null && !flState.m_76178_() && (flState.m_76152_() == Fluids.f_76193_ || flState.m_76152_() == Fluids.f_76192_)) continue;
            return null;
        }
        return state;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ConstructWorkbenchTile(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == TileEntityInit.CONSTRUCT_WORKBENCH.get() ? (lvl, pos, state1, be) -> ConstructWorkbenchTile.Tick(lvl, pos, state1, (ConstructWorkbenchTile)be) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        if (player instanceof FakePlayer) {
            return InteractionResult.FAIL;
        }
        ItemStack activeStack = player.m_21120_(handIn);
        ConstructWorkbenchTile te = (ConstructWorkbenchTile)worldIn.m_7702_(pos);
        if (te == null) {
            return InteractionResult.FAIL;
        }
        if (activeStack.m_41619_()) {
            if (te.startCrafting(player)) {
                return InteractionResult.SUCCESS;
            }
        } else if (activeStack.m_41720_() == ItemInit.ANIMUS_DUST.get() && te.summonConstructImmediately(player)) {
            if (!player.m_7500_()) {
                activeStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!(activeStack.m_41720_() instanceof ItemConstructPart)) {
            ItemStack pop = te.popPart();
            if (!pop.m_41619_() && !player.m_36356_(pop)) {
                player.m_19983_(pop);
            }
            return InteractionResult.SUCCESS;
        }
        ItemStack result = te.placePart(activeStack);
        if (result.equals(activeStack)) {
            return InteractionResult.PASS;
        }
        if (!player.m_7500_()) {
            activeStack.m_41774_(1);
        }
        if (!result.m_41619_() && !player.m_36356_(result)) {
            player.m_19983_(result);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropInventory(worldIn, pos, null);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    private void dropInventory(Level world, BlockPos pos, @Nullable BlockEntity te) {
        if (world.f_46443_) {
            return;
        }
        ConstructWorkbenchTile wb = (ConstructWorkbenchTile)(te != null ? te : world.m_7702_(pos));
        if (wb != null) {
            for (ConstructSlot slot : ConstructSlot.values()) {
                wb.getConstruct().getPart(slot).ifPresent(p -> {
                    ItemEntity ie = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)p));
                    ie.m_32060_();
                    world.m_7967_((Entity)ie);
                });
            }
        }
    }

    @Override
    protected BlockPos[] getOffsets(BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        if (dir == Direction.EAST || dir == Direction.WEST) {
            return this.offsetsWE;
        }
        return this.offsetsNS;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Player player;
        EntityCollisionContext ecc;
        Entity entity;
        boolean full = (Boolean)pState.m_61143_((Property)HAS_PART);
        Direction dir = (Direction)pState.m_61143_((Property)FACING);
        if (pContext instanceof EntityCollisionContext && (entity = (ecc = (EntityCollisionContext)pContext).m_193113_()) instanceof Player && ((player = (Player)entity).m_21205_().m_41720_() instanceof ItemConstructPart || player.m_21206_().m_41720_() instanceof ItemConstructPart || player.m_21205_().m_41720_() instanceof BellOfBidding || player.m_21206_().m_41720_() instanceof BellOfBidding)) {
            full = true;
        }
        if (full) {
            return CENTERS[dir.m_122416_() % CENTERS.length];
        }
        return Shapes.m_83040_();
    }

    @Override
    public VoxelShape getOffsetShape(BlockPos delta, BlockState state, BlockPos parentPos, BlockGetter pLevel, CollisionContext pContext) {
        Player player;
        EntityCollisionContext ecc;
        Entity entity;
        VoxelShape[] voxelShapeArray;
        boolean full = (Boolean)state.m_61143_((Property)HAS_PART);
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        if (full) {
            voxelShapeArray = CENTERS;
        } else {
            VoxelShape[] voxelShapeArray2 = new VoxelShape[1];
            voxelShapeArray = voxelShapeArray2;
            voxelShapeArray2[0] = Shapes.m_83040_();
        }
        VoxelShape[] lookup = voxelShapeArray;
        if (pContext instanceof EntityCollisionContext && (entity = (ecc = (EntityCollisionContext)pContext).m_193113_()) instanceof Player && ((player = (Player)entity).m_21205_().m_41720_() instanceof ItemConstructPart || player.m_21206_().m_41720_() instanceof ItemConstructPart || player.m_21205_().m_41720_() instanceof BellOfBidding || player.m_21206_().m_41720_() instanceof BellOfBidding)) {
            full = true;
        }
        int deltaH = delta.m_123341_() + delta.m_123343_();
        if (dir == Direction.SOUTH || dir == Direction.WEST) {
            deltaH *= -1;
        }
        block0 : switch (deltaH) {
            case -1: {
                switch (delta.m_123342_()) {
                    case 0: {
                        lookup = full ? BOTTOM_RIGHTS_FULL : BOTTOM_RIGHTS;
                        break;
                    }
                    case 1: {
                        lookup = full ? MIDDLE_RIGHTS_FULL : MIDDLE_RIGHTS;
                        break;
                    }
                    case 2: {
                        lookup = TOP_RIGHT_CORNERS;
                    }
                }
                break;
            }
            case 0: {
                switch (delta.m_123342_()) {
                    case 1: {
                        if (!full) break;
                        lookup = CENTERS;
                        break;
                    }
                    case 2: {
                        lookup = full ? TOP_CENTERS_FULL : TOP_CENTERS;
                    }
                }
                break;
            }
            case 1: {
                switch (delta.m_123342_()) {
                    case 0: {
                        lookup = full ? BOTTOM_LEFTS_FULL : BOTTOM_LEFTS;
                        break block0;
                    }
                    case 1: {
                        lookup = full ? MIDDLE_LEFTS_FULL : MIDDLE_LEFTS;
                        break block0;
                    }
                    case 2: {
                        lookup = TOP_LEFT_CORNERS;
                    }
                }
            }
        }
        int idx = dir.m_122416_();
        if (idx >= lookup.length) {
            idx = 0;
        }
        return lookup[idx];
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        BlockEntity blockEntity;
        if (pLevel.m_5776_() && pEntity.m_20184_().m_82553_() > 0.1 && (blockEntity = pLevel.m_7702_(pPos)) instanceof ConstructWorkbenchTile) {
            ConstructWorkbenchTile tile = (ConstructWorkbenchTile)blockEntity;
            tile.swing();
        }
    }
}

