/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.decoration;

import com.mna.api.blocks.WaterloggableBlockWithOffset;
import com.mna.api.tools.BlockUtilities;
import com.mna.api.tools.RLoc;
import com.mna.blocks.BlockInit;
import com.mna.blocks.decoration.BookshelfBlock;
import com.mna.blocks.tileentities.ScrollShelfTile;
import com.mna.gui.containers.block.ContainerScrollShelf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class ScrollshelfBlock
extends WaterloggableBlockWithOffset
implements EntityBlock {
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)RLoc.create("container.scrollshelf").toString());
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83124_((VoxelShape)BookshelfBlock.BASE_OUTER_NORTH, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)4.0, (double)7.0, (double)14.0, (double)11.0, (double)16.0), Block.m_49796_((double)2.0, (double)11.0, (double)6.0, (double)14.0, (double)12.0, (double)16.0), Block.m_49796_((double)2.0, (double)12.0, (double)9.0, (double)14.0, (double)16.0, (double)16.0)});
    private static final VoxelShape SHAPE_SOUTH = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, SHAPE_NORTH);
    private static final VoxelShape SHAPE_WEST = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, SHAPE_NORTH);
    private static final VoxelShape SHAPE_EAST = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, SHAPE_NORTH);
    private static VoxelShape OFFSET_1_NORTH = Shapes.m_83110_((VoxelShape)BookshelfBlock.OFFSET_1_OUTER_NORTH, (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)9.0, (double)14.0, (double)12.0, (double)16.0));
    private static final VoxelShape OFFSET_1_SOUTH = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, OFFSET_1_NORTH);
    private static final VoxelShape OFFSET_1_WEST = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, OFFSET_1_NORTH);
    private static final VoxelShape OFFSET_1_EAST = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, OFFSET_1_NORTH);

    public ScrollshelfBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(3.0f).m_60955_().m_60960_(BlockInit.NEVER), false, new BlockPos(0, 1, 0));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ScrollShelfTile(pos, state);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropInventory(worldIn, pos, state);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    private void dropInventory(Level world, BlockPos pos, BlockState state) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity != null && tileEntity instanceof ScrollShelfTile) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)tileEntity));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider provider = this.getProvider(state, level, pos, player, hand, hitResult);
        if (provider == null) {
            return InteractionResult.SUCCESS;
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    protected MenuProvider getProvider(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity be = level.m_7702_(pos);
        if (be == null || !(be instanceof ScrollShelfTile)) {
            return null;
        }
        return new SimpleMenuProvider((id, playerInv, user) -> new ContainerScrollShelf(id, playerInv, (ScrollShelfTile)be), CONTAINER_TITLE);
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        return 1.0f;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction dir = (Direction)pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        switch (dir) {
            case EAST: {
                return SHAPE_EAST;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return Shapes.m_83144_();
    }

    @Override
    public VoxelShape getOffsetShape(BlockPos delta, BlockState parentState, BlockPos parentPos, BlockGetter pLevel, CollisionContext pContext) {
        Direction dir = (Direction)parentState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        switch (dir) {
            case EAST: {
                return OFFSET_1_EAST;
            }
            case NORTH: {
                return OFFSET_1_NORTH;
            }
            case SOUTH: {
                return OFFSET_1_SOUTH;
            }
            case WEST: {
                return OFFSET_1_WEST;
            }
        }
        return Shapes.m_83144_();
    }
}

