/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.blocks.artifice.FluidJugBlock;
import com.mna.blocks.tileentities.init.TileEntityInit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidJugTile
extends BlockEntity
implements IFluidHandler {
    private FluidStack infiniteFluid = null;
    private FluidStack containedFluid = FluidStack.EMPTY;
    private int capacity = 16000;
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this);

    public FluidJugTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public FluidJugTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)TileEntityInit.FLUID_JUG.get(), pos, state);
    }

    private void spawnFluidFillParticles() {
        int numParticles = this.containedFluid.getAmount() == this.capacity ? 50 : 1;
        for (int i = 0; i < numParticles; ++i) {
            this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, (double)this.m_58899_().m_123341_() + 0.5, (double)(this.m_58899_().m_123342_() + 1), (double)this.m_58899_().m_123343_() + 0.5, ((double)this.m_58904_().m_213780_().m_188501_() - 0.5) * 2.0, (double)this.m_58904_().m_213780_().m_188501_(), ((double)this.m_58904_().m_213780_().m_188501_() - 0.5) * 2.0);
        }
    }

    public boolean isInfinite() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof FluidJugBlock) {
            return ((FluidJugBlock)block).is_infinite();
        }
        return false;
    }

    private FluidStack infiniteFluidType() {
        if (this.infiniteFluid == null) {
            ResourceLocation flType;
            this.infiniteFluid = FluidStack.EMPTY;
            Block block = this.m_58900_().m_60734_();
            if (block instanceof FluidJugBlock && ForgeRegistries.FLUIDS.containsKey(flType = ((FluidJugBlock)block).getFluidType())) {
                this.infiniteFluid = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(flType), this.capacity);
            }
        }
        return this.infiniteFluid;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        if (this.isInfinite()) {
            return this.infiniteFluidType();
        }
        return this.containedFluid;
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        if (this.isInfinite()) {
            return stack.getFluid().equals(this.infiniteFluidType().getFluid());
        }
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.isInfinite()) {
            return resource.getFluid().equals(this.infiniteFluidType().getFluid()) ? resource.getAmount() : 0;
        }
        if (resource.isEmpty()) {
            return 0;
        }
        if (!this.containedFluid.isEmpty() && !this.containedFluid.isFluidEqual(resource)) {
            return 0;
        }
        int amount = Math.min(resource.getAmount(), this.capacity - this.containedFluid.getAmount());
        if (action != IFluidHandler.FluidAction.SIMULATE) {
            if (this.containedFluid.isEmpty()) {
                this.containedFluid = new FluidStack(resource.getFluid(), 0);
            }
            this.containedFluid.setAmount(this.containedFluid.getAmount() + amount);
            if (!this.m_58904_().m_5776_()) {
                this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        }
        return amount;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!(this.isInfinite() || !this.containedFluid.isEmpty() && this.containedFluid.isFluidEqual(resource))) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.isInfinite()) {
            FluidStack flOutput = this.infiniteFluidType().copy();
            flOutput.setAmount(maxDrain);
            return flOutput;
        }
        if (this.containedFluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int amount = Math.min(maxDrain, this.containedFluid.getAmount());
        FluidStack output = new FluidStack(this.containedFluid.getFluid(), amount);
        if (action != IFluidHandler.FluidAction.SIMULATE) {
            this.containedFluid.shrink(amount);
            if (this.containedFluid.getAmount() <= 0) {
                this.containedFluid = FluidStack.EMPTY;
            }
            if (!this.m_58904_().m_5776_()) {
                this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        }
        return output;
    }

    public float getFillPct() {
        if (this.isInfinite()) {
            return 1.0f;
        }
        return (float)this.containedFluid.getAmount() / (float)this.capacity;
    }

    public FluidStack getContainedFluid() {
        return this.getFluidInTank(0);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.containedFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.containedFluid.writeToNBT(tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public CompoundTag m_5995_() {
        CompoundTag base = super.m_5995_();
        this.m_183515_(base);
        return base;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        int prevAmt = this.containedFluid.getAmount();
        this.m_142466_(tag);
        if (this.containedFluid.getAmount() != prevAmt && this.m_58904_().m_5776_()) {
            this.spawnFluidFillParticles();
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        int prevAmt = this.containedFluid.getAmount();
        this.m_142466_(tag);
        if (this.containedFluid.getAmount() > prevAmt && this.m_58904_().m_5776_()) {
            this.spawnFluidFillParticles();
        }
    }
}

