/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.blocks.BlockInit;
import com.mna.blocks.manaweaving.ManaweaveProjectorBlock;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.blocks.tileentities.pylon.ManaPylonTile;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

public class ManaResevoirTile
extends BlockEntity {
    public static final float MAX_MANA = 100.0f;
    private static final float maxStealPerSecond = 5.0f;
    private static final int RADIUS = 2;
    private static final int PYLON_RADIUS = 8;
    private int tickCount = 0;
    private float mana = 0.0f;
    private ArrayList<BlockPos> knownPylonPositions = new ArrayList();
    private ArrayList<BlockPos> toRemove = new ArrayList();

    public ManaResevoirTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.MANA_RESEVOIR.get(), pos, state);
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, ManaResevoirTile tile) {
        ++tile.tickCount;
        if (level.m_5776_()) {
            tile.spawnParticles();
        } else {
            tile.runLogic_server();
        }
    }

    private void spawnParticles() {
        BlockPos blockPos = this.m_58899_();
        if ((Integer)this.m_58900_().m_61143_((Property)ManaweaveProjectorBlock.FILL_LEVEL) != 4) {
            if (this.tickCount % 40 == 0) {
                this.scanForNearbyPylons(8);
            }
            if (this.tickCount % 2 == 0) {
                List players = this.f_58857_.m_45976_(Player.class, new AABB(this.m_58899_()).m_82400_(2.0));
                for (Player player : players) {
                    Vec3 pos = player.m_20182_();
                    this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_LERP_POINT.get())), pos.m_7096_(), pos.m_7098_() + (double)1.2f, pos.m_7094_(), (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f));
                }
                this.toRemove.clear();
                for (BlockPos pos : this.knownPylonPositions) {
                    if (!this.m_58904_().m_46749_(pos)) continue;
                    if (this.m_58904_().m_8055_(pos).m_60734_() == BlockInit.PYLON_MANA.get()) {
                        this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_LERP_POINT.get())), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.2f), (double)((float)pos.m_123343_() + 0.5f), (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f));
                        continue;
                    }
                    this.toRemove.add(pos);
                }
                this.knownPylonPositions.removeAll(this.toRemove);
            }
        }
    }

    private void runLogic_server() {
        if (this.mana < 100.0f && !this.m_58904_().m_276867_(this.m_58899_())) {
            if (this.tickCount % 40 == 0) {
                this.scanForNearbyPylons(8);
            }
            if (this.tickCount % 2 == 0) {
                this.getManaFromAllNearby();
                this.getManaFromPylons();
                this.updateBlockState();
            }
        }
    }

    private void updateBlockState() {
        if (this.m_58904_().m_5776_()) {
            return;
        }
        BlockState state = this.m_58900_();
        boolean hasChange = false;
        int fillAmt = (int)Math.floor(this.mana / 100.0f * 4.0f);
        if ((Integer)state.m_61143_((Property)ManaweaveProjectorBlock.FILL_LEVEL) != fillAmt) {
            state = (BlockState)state.m_61124_((Property)ManaweaveProjectorBlock.FILL_LEVEL, (Comparable)Integer.valueOf(fillAmt));
            hasChange = true;
        }
        if (hasChange) {
            this.m_58904_().m_7731_(this.m_58899_(), state, 2);
            this.m_58904_().m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    private void getManaFromAllNearby() {
        List players = this.f_58857_.m_45976_(Player.class, new AABB(this.m_58899_()).m_82400_(2.0));
        for (Player player : players) {
            this.getManaFromPlayer(player);
        }
    }

    private void getManaFromPylons() {
        this.toRemove.clear();
        for (BlockPos pos : this.knownPylonPositions) {
            BlockEntity blockEntity;
            if (!this.m_58904_().m_46749_(pos)) continue;
            if (this.m_58904_().m_8055_(pos).m_60734_() == BlockInit.PYLON_MANA.get() && (blockEntity = this.m_58904_().m_7702_(pos)) instanceof ManaPylonTile) {
                ManaPylonTile tile = (ManaPylonTile)blockEntity;
                if (!tile.isActiveAndPoweredUp()) continue;
                float consumed = tile.consumePower(0.25f) * 40.0f;
                this.mana = Math.min(this.mana + consumed, 100.0f);
                continue;
            }
            this.toRemove.add(pos);
        }
        this.knownPylonPositions.removeAll(this.toRemove);
    }

    private void scanForNearbyPylons(int radius) {
        this.knownPylonPositions.clear();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    BlockPos pos = this.m_58899_().m_7918_(i, j, k);
                    if (!this.m_58904_().m_46749_(pos) || this.f_58857_.m_8055_(pos).m_60734_() != BlockInit.PYLON_MANA.get()) continue;
                    this.knownPylonPositions.add(pos);
                }
            }
        }
    }

    private void getManaFromPlayer(Player player) {
        float stealAmount = Math.min(100.0f - this.mana, 5.0f);
        if (stealAmount == 0.0f) {
            return;
        }
        LazyOptional magicContainer = player.getCapability(PlayerMagicProvider.MAGIC);
        if (magicContainer.isPresent()) {
            IPlayerMagic magic = (IPlayerMagic)magicContainer.orElse(null);
            if (magic.getCastingResource().getAmount() < stealAmount) {
                stealAmount = magic.getCastingResource().getAmount();
            }
            magic.getCastingResource().consume((LivingEntity)player, stealAmount);
            this.mana += stealAmount;
        }
    }

    public float getMana() {
        return this.mana;
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128350_("mana", this.mana);
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("mana")) {
            this.mana = compound.m_128457_("mana");
        }
        super.m_142466_(compound);
    }
}

