/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.blocks.BlockInit;
import com.mna.blocks.manaweaving.ManaweaveProjectorBlock;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.blocks.tileentities.pylon.ManaPylonTile;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.manaweaving.Manaweave;
import com.mna.events.EventDispatcher;
import com.mna.recipes.manaweaving.ManaweavingPattern;
import com.mna.recipes.manaweaving.ManaweavingPatternHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

public class ManaweaveProjectorTile
extends BlockEntity {
    private static final String NBT_PATTERN_ID = "manaweave_pattern_id";
    public static final float MAX_MANA = 100.0f;
    private static final float maxStealPerSecond = 5.0f;
    private static final int RADIUS = 2;
    private static final int PYLON_RADIUS = 8;
    private int tickCount = 0;
    private float mana = 0.0f;
    private ResourceLocation __patternRLoc = null;
    private ManaweavingPattern __pattern;
    private boolean spawning = false;
    private LivingEntity activator;
    private ArrayList<BlockPos> knownPylonPositions = new ArrayList();
    private ArrayList<BlockPos> toRemove = new ArrayList();

    public ManaweaveProjectorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.MANAWEAVE_PROJECTOR.get(), pos, state);
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, ManaweaveProjectorTile tile) {
        ++tile.tickCount;
        if (level.m_5776_()) {
            tile.spawnParticles();
        } else {
            tile.runLogic_server();
        }
    }

    private void spawnParticles() {
        BlockPos blockPos = this.m_58899_();
        if (((Boolean)this.m_58900_().m_61143_((Property)ManaweaveProjectorBlock.PROJECTING)).booleanValue()) {
            this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_VELOCITY.get())), (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f), (double)-0.1f + Math.random() * (double)0.2f, (double)0.15f, (double)-0.1f + Math.random() * (double)0.2f);
        } else if ((Integer)this.m_58900_().m_61143_((Property)ManaweaveProjectorBlock.FILL_LEVEL) != 4) {
            if (this.tickCount % 40 == 0) {
                this.scanForNearbyPylons(8);
            }
            if (this.tickCount % 2 == 0) {
                List players = this.f_58857_.m_45976_(Player.class, new AABB(this.m_58899_()).m_82400_(2.0));
                for (Player player : players) {
                    Vec3 pos = player.m_20182_();
                    this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_LERP_POINT.get())), pos.m_7096_(), pos.m_7098_() + (double)1.2f, pos.m_7094_(), (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f));
                }
                this.toRemove.clear();
                for (BlockPos pos : this.knownPylonPositions) {
                    if (!this.m_58904_().m_46749_(pos)) continue;
                    if (this.m_58904_().m_8055_(pos).m_60734_() == BlockInit.PYLON_MANA.get()) {
                        this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_LERP_POINT.get())), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.2f), (double)((float)pos.m_123343_() + 0.5f), (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f));
                        continue;
                    }
                    this.toRemove.add(pos);
                }
                this.knownPylonPositions.removeAll(this.toRemove);
            }
        }
    }

    private void runLogic_server() {
        if (!this.spawning) {
            if (this.mana < 100.0f && !this.m_58904_().m_276867_(this.m_58899_())) {
                if (this.tickCount % 40 == 0) {
                    this.scanForNearbyPylons(8);
                }
                if (this.tickCount % 2 == 0) {
                    this.getManaFromAllNearby();
                    this.getManaFromPylons();
                    this.updateBlockState();
                }
            }
        } else {
            this.mana -= 1.0f;
            if (this.mana <= 0.0f) {
                this.mana = 0.0f;
                if (!EventDispatcher.DispatchManaweavePatternDrawn(this.getPattern(), this.activator)) {
                    return;
                }
                BlockPos spawnPos = this.m_58899_();
                Manaweave weave = new Manaweave(this.m_58904_());
                weave.m_6034_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_() + 1, (double)spawnPos.m_123343_() + 0.5);
                weave.setPattern(this.getPattern().m_6423_());
                weave.setCaster(this.activator, InteractionHand.MAIN_HAND);
                this.m_58904_().m_7967_((Entity)weave);
                this.activator = null;
                this.spawning = false;
                this.scanForNearbyPylons(8);
            }
            this.updateBlockState();
        }
    }

    private void updateBlockState() {
        if (this.m_58904_().m_5776_()) {
            return;
        }
        BlockState state = this.m_58900_();
        boolean hasChange = false;
        if ((Boolean)state.m_61143_((Property)ManaweaveProjectorBlock.PROJECTING) != this.spawning) {
            state = (BlockState)state.m_61124_((Property)ManaweaveProjectorBlock.PROJECTING, (Comparable)Boolean.valueOf(this.spawning));
            hasChange = true;
        }
        int fillAmt = (int)Math.floor(this.mana / 100.0f * 4.0f);
        if ((Integer)state.m_61143_((Property)ManaweaveProjectorBlock.FILL_LEVEL) != fillAmt) {
            state = (BlockState)state.m_61124_((Property)ManaweaveProjectorBlock.FILL_LEVEL, (Comparable)Integer.valueOf(fillAmt));
            hasChange = true;
        }
        if (hasChange) {
            this.m_58904_().m_7731_(this.m_58899_(), state, 2);
            this.m_58904_().m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    public void trySpawnManaweaveEntity(Player player) {
        if (this.mana < 100.0f || this.m_58904_().m_5776_() || this.getPattern() == null || this.spawning) {
            return;
        }
        this.activator = player;
        this.spawning = true;
        this.updateBlockState();
    }

    private void getManaFromAllNearby() {
        List players = this.f_58857_.m_45976_(Player.class, new AABB(this.m_58899_()).m_82400_(2.0));
        for (Player player : players) {
            this.getManaFromPlayer(player);
        }
    }

    private void getManaFromPylons() {
        this.toRemove.clear();
        for (BlockPos pos : this.knownPylonPositions) {
            BlockEntity blockEntity;
            if (!this.m_58904_().m_46749_(pos)) continue;
            if (this.m_58904_().m_8055_(pos).m_60734_() == BlockInit.PYLON_MANA.get() && (blockEntity = this.m_58904_().m_7702_(pos)) instanceof ManaPylonTile) {
                ManaPylonTile tile = (ManaPylonTile)blockEntity;
                if (!tile.isActiveAndPoweredUp()) continue;
                float consumed = tile.consumePower(0.25f) * 40.0f;
                this.mana = Math.min(this.mana + consumed, 100.0f);
                continue;
            }
            this.toRemove.add(pos);
        }
        this.knownPylonPositions.removeAll(this.toRemove);
    }

    private void scanForNearbyPylons(int radius) {
        this.knownPylonPositions.clear();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    BlockPos pos = this.m_58899_().m_7918_(i, j, k);
                    if (!this.m_58904_().m_46749_(pos) || this.f_58857_.m_8055_(pos).m_60734_() != BlockInit.PYLON_MANA.get()) continue;
                    this.knownPylonPositions.add(pos);
                }
            }
        }
    }

    private void getManaFromPlayer(Player player) {
        float stealAmount = Math.min(100.0f - this.mana, 5.0f);
        if (stealAmount == 0.0f) {
            return;
        }
        LazyOptional magicContainer = player.getCapability(PlayerMagicProvider.MAGIC);
        if (magicContainer.isPresent()) {
            IPlayerMagic magic = (IPlayerMagic)magicContainer.orElse(null);
            if (magic.getCastingResource().getAmount() < stealAmount) {
                stealAmount = magic.getCastingResource().getAmount();
            }
            magic.getCastingResource().consume((LivingEntity)player, stealAmount);
            this.mana += stealAmount;
        }
    }

    private void lookupManaweavePattern(ResourceLocation rLoc) {
        this.__pattern = ManaweavingPatternHelper.GetManaweavingRecipe(this.m_58904_(), rLoc);
    }

    public float getMana() {
        return this.mana;
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128350_("mana", this.mana);
        compound.m_128359_(NBT_PATTERN_ID, this.__pattern != null ? this.__pattern.m_6423_().toString() : (this.__patternRLoc != null ? this.__patternRLoc.toString() : ""));
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("mana")) {
            this.mana = compound.m_128457_("mana");
        }
        if (compound.m_128441_(NBT_PATTERN_ID)) {
            this.__patternRLoc = new ResourceLocation(compound.m_128461_(NBT_PATTERN_ID));
        }
        super.m_142466_(compound);
    }

    @Nullable
    public ManaweavingPattern getPattern() {
        if (this.__pattern == null) {
            this.lookupManaweavePattern(this.__patternRLoc != null ? this.__patternRLoc : new ResourceLocation("mna", "manaweave_patterns/triangle"));
        }
        return this.__pattern;
    }

    public void setPattern(ResourceLocation rLoc, @Nullable Player player) {
        if (player != null) {
            ManaweavingPattern newPattern = ManaweavingPatternHelper.GetManaweavingRecipe(this.m_58904_(), rLoc);
            IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
            if (progression != null && newPattern != null && newPattern.getTier() > progression.getTier()) {
                player.m_213846_((Component)Component.m_237115_((String)"item.mna.manaweaver_wand.low_tier"));
                return;
            }
        }
        this.__patternRLoc = rLoc;
        this.__pattern = null;
    }

    public CompoundTag m_5995_() {
        CompoundTag base = super.m_5995_();
        base.m_128359_(NBT_PATTERN_ID, this.__pattern != null ? this.__pattern.m_6423_().toString() : (this.__patternRLoc != null ? this.__patternRLoc.toString() : ""));
        return base;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.setPattern(new ResourceLocation(tag.m_128461_(NBT_PATTERN_ID)), null);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag data = pkt.m_131708_();
        this.setPattern(new ResourceLocation(data.m_128461_(NBT_PATTERN_ID)), null);
    }
}

