/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.api.blocks.tile.TileEntityWithInventory;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.tools.MATags;
import com.mna.api.tools.RLoc;
import com.mna.blocks.BlockInit;
import com.mna.blocks.runeforging.PedestalBlock;
import com.mna.blocks.runeforging.RuneforgeBlock;
import com.mna.blocks.tileentities.PedestalTile;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.recipes.RecipeInit;
import com.mna.recipes.arcanefurnace.ArcaneFurnaceRecipe;
import com.mna.tools.ContainerTools;
import com.mna.tools.InventoryUtilities;
import com.mna.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeBlockEntity;

public class RuneForgeTile
extends TileEntityWithInventory
implements IForgeBlockEntity {
    private static final ResourceLocation tag_blacklist = RLoc.create("arcane_furnace_doubling_blacklist");
    private static final int MAX_ITEMS = 64;
    public static final int INVENTORY_SLOT_INDEX = 0;
    int smeltTicks = 0;
    int burnTime = 0;
    private boolean ignoreRecipeCheck = false;
    private boolean isRepairing = false;
    private ItemStack __cachedRecipeOutput;
    private ArcaneFurnaceRecipe __cachedRecipe;

    public RuneForgeTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state, 64);
    }

    public RuneForgeTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)TileEntityInit.RUNEFORGE.get(), pos, state);
    }

    @Override
    public void m_6836_(int index, ItemStack stack) {
        super.m_6836_(index, stack);
        if (!this.m_58904_().m_5776_()) {
            boolean active = false;
            this.m_58904_().m_7731_(this.m_58899_(), (BlockState)((BlockState)((BlockState)((BlockState)this.m_58900_().m_61124_((Property)RuneforgeBlock.ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RuneforgeBlock.ORE_DOUBLING, (Comparable)Boolean.valueOf(this.hasMultiUpgrade()))).m_61124_((Property)RuneforgeBlock.REPAIR, (Comparable)Boolean.valueOf(this.hasRepairUpgrade()))).m_61124_((Property)RuneforgeBlock.SPEED, (Comparable)Boolean.valueOf(this.hasSpeedUpgrade())), 1);
            if (!this.ignoreRecipeCheck) {
                active = this.cacheRecipe();
            }
            if (active) {
                this.smeltTicks = 0;
                this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)RuneforgeBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
            }
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    public ItemStack m_7407_(int index, int count) {
        ItemStack output = super.m_7407_(index, count);
        if (!output.m_41619_()) {
            this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)RuneforgeBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
        } else {
            this.m_58904_().m_7731_(this.m_58899_(), this.m_58900_(), 3);
        }
        return output;
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
        super.m_6596_();
    }

    private boolean cacheRecipe() {
        CraftingContainer inv = ContainerTools.createTemporaryContainer(this.m_8020_(0));
        ArcaneFurnaceRecipe smeltRecipe = this.m_58904_().m_7465_().m_44015_((RecipeType)RecipeInit.ARCANE_FURNACE_TYPE.get(), (Container)inv, this.f_58857_).orElse(null);
        this.__cachedRecipeOutput = null;
        ItemStack ingredient = this.m_8020_(0);
        if (this.hasRepairUpgrade()) {
            if (!MATags.isItemEqual(ingredient, tag_blacklist)) {
                this.isRepairing = true;
                return true;
            }
            return false;
        }
        boolean ret = false;
        if (smeltRecipe != null) {
            this.__cachedRecipe = smeltRecipe;
            this.__cachedRecipeOutput = smeltRecipe.getResultItem();
            this.__cachedRecipeOutput.m_41764_(this.__cachedRecipeOutput.m_41613_() * this.m_8020_(0).m_41613_());
            this.burnTime = smeltRecipe.getBurnTime() * this.m_8020_(0).m_41613_();
            ret = true;
        } else {
            Optional cook_recipe = this.m_58904_().m_7465_().m_44015_(RecipeType.f_44111_, (Container)inv, this.f_58857_);
            if (cook_recipe.isPresent()) {
                this.__cachedRecipeOutput = ((CampfireCookingRecipe)cook_recipe.get()).m_5874_((Container)inv, this.f_58857_.m_9598_());
                this.__cachedRecipeOutput.m_41764_(this.__cachedRecipeOutput.m_41613_() * this.m_8020_(0).m_41613_());
                this.burnTime = ((CampfireCookingRecipe)cook_recipe.get()).m_43753_() / 2 * this.m_8020_(0).m_41613_();
                ret = true;
            } else {
                Optional furnace_recipe = this.m_58904_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)inv, this.f_58857_);
                if (furnace_recipe.isPresent()) {
                    this.__cachedRecipeOutput = ((SmeltingRecipe)furnace_recipe.get()).m_5874_((Container)inv, this.f_58857_.m_9598_());
                    this.__cachedRecipeOutput.m_41764_(this.__cachedRecipeOutput.m_41613_() * this.m_8020_(0).m_41613_());
                    this.burnTime = ((SmeltingRecipe)furnace_recipe.get()).m_43753_() * 2 * this.m_8020_(0).m_41613_();
                    ret = true;
                } else {
                    Optional blasting_recipe = this.m_58904_().m_7465_().m_44015_(RecipeType.f_44109_, (Container)inv, this.f_58857_);
                    if (blasting_recipe.isPresent()) {
                        this.__cachedRecipeOutput = ((BlastingRecipe)blasting_recipe.get()).m_5874_((Container)inv, this.f_58857_.m_9598_());
                        this.__cachedRecipeOutput.m_41764_(this.__cachedRecipeOutput.m_41613_() * this.m_8020_(0).m_41613_());
                        this.burnTime = ((BlastingRecipe)blasting_recipe.get()).m_43753_() * 2 * this.m_8020_(0).m_41613_();
                        ret = true;
                    }
                }
            }
        }
        if ((Integer)this.m_58900_().m_61143_((Property)RuneforgeBlock.MATERIAL) == 1) {
            this.burnTime /= 8;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)RuneforgeBlock.SPEED)).booleanValue()) {
            this.burnTime /= 6;
        }
        if (ret && this.burnTime < 1) {
            this.burnTime = 1;
        }
        if (!MATags.isItemEqual(ingredient, tag_blacklist) && ret && this.hasMultiUpgrade()) {
            this.__cachedRecipeOutput.m_41764_(Math.min(this.__cachedRecipeOutput.m_41613_() * 2, 64));
        }
        return ret;
    }

    private boolean hasMultiUpgrade() {
        switch ((Direction)this.m_58900_().m_61143_((Property)RuneforgeBlock.FACING)) {
            case EAST: 
            case WEST: {
                return this.getPedestalUpgradeType(new BlockPos(Direction.NORTH.m_122429_(), Direction.NORTH.m_122430_(), Direction.NORTH.m_122431_())) == CrystalUpgrade.DOUBLE && this.getPedestalUpgradeType(new BlockPos(Direction.SOUTH.m_122429_(), Direction.SOUTH.m_122430_(), Direction.SOUTH.m_122431_())) == CrystalUpgrade.DOUBLE;
            }
        }
        return this.getPedestalUpgradeType(new BlockPos(Direction.EAST.m_122429_(), Direction.EAST.m_122430_(), Direction.EAST.m_122431_())) == CrystalUpgrade.DOUBLE && this.getPedestalUpgradeType(new BlockPos(Direction.WEST.m_122429_(), Direction.WEST.m_122430_(), Direction.WEST.m_122431_())) == CrystalUpgrade.DOUBLE;
    }

    private boolean hasRepairUpgrade() {
        switch ((Direction)this.m_58900_().m_61143_((Property)RuneforgeBlock.FACING)) {
            case EAST: 
            case WEST: {
                return this.getPedestalUpgradeType(new BlockPos(Direction.NORTH.m_122429_(), Direction.NORTH.m_122430_(), Direction.NORTH.m_122431_())) == CrystalUpgrade.REPAIR && this.getPedestalUpgradeType(new BlockPos(Direction.SOUTH.m_122429_(), Direction.SOUTH.m_122430_(), Direction.SOUTH.m_122431_())) == CrystalUpgrade.REPAIR;
            }
        }
        return this.getPedestalUpgradeType(new BlockPos(Direction.EAST.m_122429_(), Direction.EAST.m_122430_(), Direction.EAST.m_122431_())) == CrystalUpgrade.REPAIR && this.getPedestalUpgradeType(new BlockPos(Direction.WEST.m_122429_(), Direction.WEST.m_122430_(), Direction.WEST.m_122431_())) == CrystalUpgrade.REPAIR;
    }

    private boolean hasSpeedUpgrade() {
        switch ((Direction)this.m_58900_().m_61143_((Property)RuneforgeBlock.FACING)) {
            case EAST: 
            case WEST: {
                return this.getPedestalUpgradeType(new BlockPos(Direction.NORTH.m_122429_(), Direction.NORTH.m_122430_(), Direction.NORTH.m_122431_())) == CrystalUpgrade.SPEED && this.getPedestalUpgradeType(new BlockPos(Direction.SOUTH.m_122429_(), Direction.SOUTH.m_122430_(), Direction.SOUTH.m_122431_())) == CrystalUpgrade.SPEED;
            }
        }
        return this.getPedestalUpgradeType(new BlockPos(Direction.EAST.m_122429_(), Direction.EAST.m_122430_(), Direction.EAST.m_122431_())) == CrystalUpgrade.SPEED && this.getPedestalUpgradeType(new BlockPos(Direction.WEST.m_122429_(), Direction.WEST.m_122430_(), Direction.WEST.m_122431_())) == CrystalUpgrade.SPEED;
    }

    private CrystalUpgrade getPedestalUpgradeType(BlockPos offset) {
        PedestalTile pedestal;
        ItemStack stack;
        if (this.m_58904_().m_8055_(this.f_58858_.m_121955_((Vec3i)offset)).m_60734_() instanceof PedestalBlock && !(stack = (pedestal = (PedestalTile)this.f_58857_.m_7702_(this.f_58858_.m_121955_((Vec3i)offset))).m_8020_(0)).m_41619_() && stack.m_41720_() instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)stack.m_41720_();
            if (blockItem.m_40614_() == BlockInit.CHIMERITE_CRYSTAL_ORANGE.get() || blockItem.m_40614_() == BlockInit.CHIMERITE_CRYSTAL_RED.get() || blockItem.m_40614_() == BlockInit.CHIMERITE_CRYSTAL_YELLOW.get()) {
                return CrystalUpgrade.DOUBLE;
            }
            if (blockItem.m_40614_() == BlockInit.CHIMERITE_CRYSTAL_BLUE.get() || blockItem.m_40614_() == BlockInit.CHIMERITE_CRYSTAL_CYAN.get() || blockItem.m_40614_() == BlockInit.CHIMERITE_CRYSTAL_LIGHT_BLUE.get() || blockItem.m_40614_() == BlockInit.CHIMERITE_CRYSTAL_WHITE.get()) {
                return CrystalUpgrade.REPAIR;
            }
            if (blockItem.m_40614_() == BlockInit.CHIMERITE_CRYSTAL_PURPLE.get() || blockItem.m_40614_() == BlockInit.CHIMERITE_CRYSTAL_MAGENTA.get() || blockItem.m_40614_() == BlockInit.CHIMERITE_CRYSTAL_PINK.get()) {
                return CrystalUpgrade.SPEED;
            }
        }
        return CrystalUpgrade.NONE;
    }

    @Override
    public ItemStack m_8016_(int index) {
        ItemStack ret = super.m_8016_(index);
        if (!this.m_58904_().m_5776_()) {
            this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)RuneforgeBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
            this.smeltTicks = 0;
        }
        return ret;
    }

    @Override
    public int m_6643_() {
        return 64;
    }

    public CompoundTag m_5995_() {
        CompoundTag base = super.m_5995_();
        CompoundTag sub = new CompoundTag();
        this.m_8020_(0).m_41739_(sub);
        base.m_128365_("invSync", (Tag)sub);
        base.m_128379_("repairing", this.isRepairing);
        base.m_128405_("burnTime", this.burnTime);
        base.m_128405_("smeltTicks", this.smeltTicks);
        return base;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        CompoundTag sub = tag.m_128469_("invSync");
        this.m_6836_(0, ItemStack.m_41712_((CompoundTag)sub));
        this.isRepairing = tag.m_128471_("repairing");
        this.burnTime = tag.m_128451_("burnTime");
        this.smeltTicks = tag.m_128451_("smeltTicks");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag data = pkt.m_131708_();
        CompoundTag sub = data.m_128469_("invSync");
        this.m_6836_(0, ItemStack.m_41712_((CompoundTag)sub));
        this.isRepairing = data.m_128471_("repairing");
        this.burnTime = data.m_128451_("burnTime");
        this.smeltTicks = data.m_128451_("smeltTicks");
    }

    public int m_6893_() {
        return 64;
    }

    public ItemStack getDisplayedItem() {
        return this.m_8020_(0);
    }

    public boolean MatchesReagent(ResourceLocation rLoc) {
        if (this.m_8020_(0).m_41619_()) {
            return false;
        }
        return MATags.isItemEqual(this.m_8020_(0), rLoc);
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("smelt_ticks", this.smeltTicks);
        compound.m_128405_("burn_ticks", this.burnTime);
        compound.m_128379_("repairing", this.isRepairing);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("smelt_ticks")) {
            this.smeltTicks = compound.m_128451_("smelt_ticks");
        }
        if (compound.m_128441_("burn_ticks")) {
            this.burnTime = compound.m_128451_("burn_ticks");
        }
        if (compound.m_128441_("repairing")) {
            this.isRepairing = compound.m_128471_("repairing");
        }
        super.m_142466_(compound);
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, RuneForgeTile tile) {
        if (((Boolean)state.m_61143_((Property)RuneforgeBlock.ACTIVE)).booleanValue()) {
            if (!level.m_5776_()) {
                if (tile.hasRepairUpgrade()) {
                    tile.tickLogic_repair();
                } else {
                    tile.tickLogic_smelt();
                }
            } else {
                if (tile.hasRepairUpgrade()) {
                    tile.tickLogic_repair();
                } else {
                    ++tile.smeltTicks;
                }
                tile.spawnParticles();
            }
        }
    }

    private void tickLogic_repair() {
        int repair_rate;
        ItemStack stack = this.m_8020_(0);
        if (stack.m_41619_() || !stack.isRepairable() || !stack.m_41768_() || MATags.isItemIn(stack.m_41720_(), MATags.Items.REPAIR_BLACKLIST)) {
            this.resetSelf();
        }
        ++this.smeltTicks;
        int n = repair_rate = (Integer)this.m_58900_().m_61143_((Property)RuneforgeBlock.MATERIAL) == 1 ? 1 : 5;
        if (this.smeltTicks % repair_rate == 0) {
            stack.m_41721_(stack.m_41773_() - 1);
        }
    }

    private void tickLogic_smelt() {
        if (this.__cachedRecipeOutput == null && !this.cacheRecipe()) {
            this.resetSelf();
            return;
        }
        ++this.smeltTicks;
        if (this.smeltTicks >= this.burnTime) {
            this.ignoreRecipeCheck = true;
            this.m_6836_(0, this.__cachedRecipeOutput.m_41777_());
            if (this.__cachedRecipe != null) {
                ArrayList<ItemStack> byproducts = this.__cachedRecipe.rollByproducts(this.f_58857_.m_213780_());
                for (ItemStack byproduct : byproducts) {
                    InventoryUtilities.DropItemAt(byproduct, Vec3.m_82512_((Vec3i)this.m_58899_().m_7494_()), this.f_58857_, true);
                }
            }
            this.__cachedRecipe = null;
            this.ignoreRecipeCheck = false;
            this.resetSelf();
            this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)RuneforgeBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    private void resetSelf() {
        this.smeltTicks = 0;
        this.burnTime = 0;
        this.isRepairing = false;
        if (!this.m_58904_().m_5776_()) {
            this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)RuneforgeBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    private void spawnParticles() {
        BlockState state = this.m_58900_();
        if (((Boolean)state.m_61143_((Property)RuneforgeBlock.ACTIVE)).booleanValue()) {
            this.spawnActiveParticles(state);
            if (((Boolean)state.m_61143_((Property)RuneforgeBlock.ORE_DOUBLING)).booleanValue()) {
                this.spawnDoublingParticles(state);
            }
            if (((Boolean)state.m_61143_((Property)RuneforgeBlock.SPEED)).booleanValue()) {
                this.spawnSpeedParticles(state);
            }
            if (((Boolean)state.m_61143_((Property)RuneforgeBlock.REPAIR)).booleanValue()) {
                this.spawnRepairParticles(state);
            }
        }
    }

    private void spawnActiveParticles(BlockState state) {
        float xOffset = 0.5f;
        float zOffset = 0.5f;
        float yOffset = 0.95f;
        float spread = 0.15f;
        float upVel = this.isRepairing ? 0.03f : 0.01f;
        MAParticleType particle = new MAParticleType((ParticleType<MAParticleType>)(this.isRepairing ? (ParticleType)ParticleInit.ARCANE.get() : (ParticleType)ParticleInit.FLAME.get()));
        if ((Integer)state.m_61143_((Property)RuneforgeBlock.MATERIAL) == 0) {
            particle.setColor(20, 40, 60);
        } else {
            particle.setScale(0.06f);
            particle.setMaxAge(8);
            upVel = 0.06f;
            if (Math.random() < (double)0.6f) {
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get())).setColor(156, 60, 30).setGravity(0.01f).setMaxAge(20), (double)((float)this.f_58858_.m_123341_() + xOffset + (-spread + this.f_58857_.m_213780_().m_188501_() * spread * 2.0f)), (double)((float)this.f_58858_.m_123342_() + yOffset), (double)((float)this.f_58858_.m_123343_() + zOffset + (-spread + this.f_58857_.m_213780_().m_188501_() * spread * 2.0f)), -0.05 + Math.random() * 0.1, 0.06, -0.05 + Math.random() * 0.1);
            }
        }
        for (int i = 0; i < 2; ++i) {
            this.m_58904_().m_7106_((ParticleOptions)particle, (double)((float)this.f_58858_.m_123341_() + xOffset + (-spread + this.f_58857_.m_213780_().m_188501_() * spread * 2.0f)), (double)((float)this.f_58858_.m_123342_() + yOffset), (double)((float)this.f_58858_.m_123343_() + zOffset + (-spread + this.f_58857_.m_213780_().m_188501_() * spread * 2.0f)), 0.0, (double)upVel, 0.0);
        }
    }

    private void spawnDoublingParticles(BlockState state) {
        BlockPos offset_1 = null;
        BlockPos offset_2 = null;
        switch ((Direction)this.m_58900_().m_61143_((Property)RuneforgeBlock.FACING)) {
            case EAST: 
            case WEST: {
                offset_1 = new BlockPos(Direction.NORTH.m_122429_(), Direction.NORTH.m_122430_(), Direction.NORTH.m_122431_());
                offset_2 = new BlockPos(Direction.SOUTH.m_122429_(), Direction.SOUTH.m_122430_(), Direction.SOUTH.m_122431_());
                break;
            }
            default: {
                offset_1 = new BlockPos(Direction.EAST.m_122429_(), Direction.EAST.m_122430_(), Direction.EAST.m_122431_());
                offset_2 = new BlockPos(Direction.WEST.m_122429_(), Direction.WEST.m_122430_(), Direction.WEST.m_122431_());
            }
        }
        if (offset_1 != null && offset_2 != null) {
            for (int i = 0; i < 5; ++i) {
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME_ORBIT.get())), (double)((float)(this.f_58858_.m_123341_() + offset_1.m_123341_()) + 0.5f), (double)((float)(this.f_58858_.m_123342_() + offset_1.m_123342_()) + 0.75f), (double)((float)(this.f_58858_.m_123343_() + offset_1.m_123343_()) + 0.5f), (double)0.1f, (double)0.02f, (double)0.1f);
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME_ORBIT.get())), (double)((float)(this.f_58858_.m_123341_() + offset_2.m_123341_()) + 0.5f), (double)((float)(this.f_58858_.m_123342_() + offset_2.m_123342_()) + 0.75f), (double)((float)(this.f_58858_.m_123343_() + offset_2.m_123343_()) + 0.5f), (double)0.1f, (double)0.02f, (double)0.1f);
            }
        }
    }

    private void spawnSpeedParticles(BlockState state) {
        BlockPos offset_1 = null;
        BlockPos offset_2 = null;
        switch ((Direction)this.m_58900_().m_61143_((Property)RuneforgeBlock.FACING)) {
            case EAST: 
            case WEST: {
                offset_1 = new BlockPos(Direction.NORTH.m_122429_(), Direction.NORTH.m_122430_(), Direction.NORTH.m_122431_());
                offset_2 = new BlockPos(Direction.SOUTH.m_122429_(), Direction.SOUTH.m_122430_(), Direction.SOUTH.m_122431_());
                break;
            }
            default: {
                offset_1 = new BlockPos(Direction.EAST.m_122429_(), Direction.EAST.m_122430_(), Direction.EAST.m_122431_());
                offset_2 = new BlockPos(Direction.WEST.m_122429_(), Direction.WEST.m_122430_(), Direction.WEST.m_122431_());
            }
        }
        if (offset_1 != null && offset_2 != null) {
            for (int i = 0; i < 5; ++i) {
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME_ORBIT.get())).setColor(91, 36, 143), (double)((float)(this.f_58858_.m_123341_() + offset_1.m_123341_()) + 0.5f), (double)((float)(this.f_58858_.m_123342_() + offset_1.m_123342_()) + 0.75f), (double)((float)(this.f_58858_.m_123343_() + offset_1.m_123343_()) + 0.5f), (double)0.1f, (double)0.02f, (double)0.1f);
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME_ORBIT.get())).setColor(91, 36, 143), (double)((float)(this.f_58858_.m_123341_() + offset_2.m_123341_()) + 0.5f), (double)((float)(this.f_58858_.m_123342_() + offset_2.m_123342_()) + 0.75f), (double)((float)(this.f_58858_.m_123343_() + offset_2.m_123343_()) + 0.5f), (double)0.1f, (double)0.02f, (double)0.1f);
            }
        }
    }

    private void spawnRepairParticles(BlockState state) {
        BlockPos offset_1 = null;
        BlockPos offset_2 = null;
        switch ((Direction)this.m_58900_().m_61143_((Property)RuneforgeBlock.FACING)) {
            case EAST: 
            case WEST: {
                offset_1 = new BlockPos(Direction.NORTH.m_122429_(), Direction.NORTH.m_122430_(), Direction.NORTH.m_122431_());
                offset_2 = new BlockPos(Direction.SOUTH.m_122429_(), Direction.SOUTH.m_122430_(), Direction.SOUTH.m_122431_());
                break;
            }
            default: {
                offset_1 = new BlockPos(Direction.EAST.m_122429_(), Direction.EAST.m_122430_(), Direction.EAST.m_122431_());
                offset_2 = new BlockPos(Direction.WEST.m_122429_(), Direction.WEST.m_122430_(), Direction.WEST.m_122431_());
            }
        }
        if (offset_1 != null && offset_2 != null) {
            for (int i = 0; i < 5; ++i) {
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_ORBIT.get())), (double)((float)(this.f_58858_.m_123341_() + offset_1.m_123341_()) + 0.5f), (double)((float)(this.f_58858_.m_123342_() + offset_1.m_123342_()) + 0.75f), (double)((float)(this.f_58858_.m_123343_() + offset_1.m_123343_()) + 0.5f), (double)0.1f, (double)0.02f, (double)0.1f);
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_ORBIT.get())), (double)((float)(this.f_58858_.m_123341_() + offset_2.m_123341_()) + 0.5f), (double)((float)(this.f_58858_.m_123342_() + offset_2.m_123342_()) + 0.75f), (double)((float)(this.f_58858_.m_123343_() + offset_2.m_123343_()) + 0.5f), (double)0.1f, (double)0.02f, (double)0.1f);
            }
        }
    }

    @Override
    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        if (index == 0) {
            return this.m_8020_(0).m_41619_();
        }
        return false;
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        if (!ItemStack.m_41728_((ItemStack)this.m_8020_(index), (ItemStack)stack) || ((Boolean)this.m_58900_().m_61143_((Property)RuneforgeBlock.ACTIVE)).booleanValue()) {
            return false;
        }
        if (index == 0) {
            return !this.m_8020_(0).m_41619_();
        }
        return false;
    }

    @Override
    public int[] m_7071_(Direction side) {
        return new int[]{0};
    }

    public float getBurnPct() {
        if (this.burnTime == 0) {
            return 0.0f;
        }
        return MathUtils.clamp01((float)this.smeltTicks / (float)this.burnTime);
    }

    private static enum CrystalUpgrade {
        NONE,
        DOUBLE,
        REPAIR,
        SPEED;

    }
}

