/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.pylon;

import com.mna.api.blocks.tile.pylon.PylonTileBase;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.tools.RLoc;
import com.mna.blocks.BlockInit;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.blocks.utility.InvisibleLight;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.TickPriority;

public class LightPylonTile
extends PylonTileBase {
    private static final ResourceLocation icon = RLoc.create("textures/gui/pylon/light.png");
    private static final int MAX_LIGHTS_UPDATED_PER_TICK = 100;
    private HashSet<Long> knownLightPositions = new HashSet();
    private ArrayList<Long> knownLightPositions_traversable = new ArrayList();
    private int lastKnownUpdateIndex = 0;

    public LightPylonTile(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public LightPylonTile(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)TileEntityInit.LIGHT_PYLON.get(), pPos, pBlockState);
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, LightPylonTile tile) {
        if (tile.tick()) {
            int n = tile.powerUpTicks;
            Objects.requireNonNull(tile);
            if (n == 60) {
                tile.update_known_lights();
                tile.forAllBlocks(100, (cPos, cState) -> {
                    if (cState.m_60734_() == BlockInit.INVISIBLE_LIGHT_BLOCK.get()) {
                        long lPos = cPos.m_121878_();
                        if (tile.knownLightPositions.add(lPos)) {
                            tile.knownLightPositions_traversable.add(lPos);
                        }
                    } else if (cState.m_60795_()) {
                        long lPos = cPos.m_121878_();
                        int light = level.m_45517_(LightLayer.BLOCK, cPos);
                        if (light < GeneralConfigValues.LightPylonBrightnessThreshold) {
                            level.m_7731_(cPos, ((InvisibleLight)BlockInit.INVISIBLE_LIGHT_BLOCK.get()).m_49966_(), 23);
                            level.m_186464_(cPos, (Block)BlockInit.INVISIBLE_LIGHT_BLOCK.get(), 2400, TickPriority.EXTREMELY_LOW);
                            if (tile.knownLightPositions.add(lPos)) {
                                tile.knownLightPositions_traversable.add(lPos);
                            }
                        }
                    }
                });
            }
        }
    }

    private void update_known_lights() {
        for (int i = 0; i < 100; ++i) {
            long uPosL;
            BlockPos uPos;
            if (this.lastKnownUpdateIndex >= this.knownLightPositions_traversable.size()) {
                this.lastKnownUpdateIndex = 0;
                break;
            }
            if (!this.f_58857_.m_46749_(uPos = BlockPos.m_122022_((long)(uPosL = this.knownLightPositions_traversable.get(this.lastKnownUpdateIndex++).longValue())))) continue;
            BlockState uState = this.f_58857_.m_8055_(uPos);
            if (uState.m_60734_() != BlockInit.INVISIBLE_LIGHT_BLOCK.get()) {
                this.knownLightPositions.remove(uPosL);
                while (this.knownLightPositions_traversable.remove(uPosL)) {
                }
                continue;
            }
            this.f_58857_.m_46597_(uPos, (BlockState)uState.m_61124_((Property)BlockStateProperties.f_61413_, (Comparable)Integer.valueOf(4)));
            if (this.f_58857_.m_183326_().m_183582_(uPos, (Object)((Block)BlockInit.INVISIBLE_LIGHT_BLOCK.get()))) continue;
            this.f_58857_.m_186464_(uPos, (Block)BlockInit.INVISIBLE_LIGHT_BLOCK.get(), 1200, TickPriority.EXTREMELY_LOW);
        }
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128388_("positions", this.knownLightPositions.stream().mapToLong(Number::longValue).toArray());
        pTag.m_128405_("idx", this.lastKnownUpdateIndex);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("positions")) {
            long[] positions;
            this.knownLightPositions.clear();
            for (long p : positions = pTag.m_128467_("positions")) {
                this.knownLightPositions.add(p);
                this.knownLightPositions_traversable.add(p);
            }
        }
        if (pTag.m_128441_("idx")) {
            this.lastKnownUpdateIndex = pTag.m_128451_("idx");
        }
    }
}

