/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.renderers;

import com.mna.blocks.runeforging.PedestalBlock;
import com.mna.blocks.tileentities.PedestalTile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class PedestalRenderer
implements BlockEntityRenderer<PedestalTile> {
    private final Minecraft mc = Minecraft.m_91087_();
    private final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
    private final EntityRenderDispatcher renderDispatcher = this.mc.m_91290_();
    private final Font font;

    public PedestalRenderer(BlockEntityRendererProvider.Context context) {
        this.font = this.mc.f_91062_;
    }

    public void render(PedestalTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack itemstack = tileEntityIn.getDisplayedItem();
        if (!itemstack.m_41619_()) {
            matrixStackIn.m_85836_();
            if (itemstack.m_41720_() instanceof BlockItem) {
                matrixStackIn.m_85837_(0.5, 1.2, 0.5);
            } else {
                matrixStackIn.m_85837_(0.5, 1.0, 0.5);
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            }
            matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            this.itemRenderer.m_269128_(itemstack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, (Level)this.mc.f_91073_, 0);
            matrixStackIn.m_85849_();
            this.renderHoverText(tileEntityIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        }
    }

    private void renderHoverText(PedestalTile tileEntityIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!((Boolean)tileEntityIn.m_58900_().m_61143_((Property)PedestalBlock.SHOW_SIGN)).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91077_ == null || mc.f_91077_.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult brtr = (BlockHitResult)mc.f_91077_;
        if (!brtr.m_82425_().equals((Object)tileEntityIn.m_58899_())) {
            return;
        }
        if (!brtr.m_82434_().equals((Object)tileEntityIn.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_))) {
            return;
        }
        Vec3 dist = mc.f_91074_.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)tileEntityIn.m_58899_())).m_82541_().m_82490_(0.5);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 1.1, 0.5);
        matrixStackIn.m_85837_(dist.f_82479_, dist.f_82480_, dist.f_82481_);
        matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
        this.renderString(tileEntityIn.getDisplayedItem().m_41611_().getString(), matrixStackIn, bufferIn, combinedLightIn);
        matrixStackIn.m_85849_();
    }

    protected void renderString(String text, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.m_85836_();
        stack.m_252781_(this.renderDispatcher.m_253208_());
        stack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        float opacity = 0.25f;
        int textColor = (int)(opacity * 255.0f) << 24;
        float hOffset = -this.font.m_92895_(text) / 2;
        this.font.m_271703_(text, hOffset, 0.0f, 0x20FFFFFF, false, matrix4f, buffer, Font.DisplayMode.NORMAL, textColor, packedLight);
        this.font.m_271703_(text, hOffset, 0.0f, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        stack.m_85849_();
    }
}

