/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.wizard_lab;

import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IWellspringNodeRegistry;
import com.mna.api.capabilities.IWorldMagic;
import com.mna.api.events.GenericProgressionEvent;
import com.mna.api.events.ProgressionEventIDs;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.blocks.artifice.FumeBellowsBlock;
import com.mna.blocks.artifice.FumePrismBlock;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.blocks.tileentities.wizard_lab.WizardLabTile;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.items.ritual.Mote;
import com.mna.recipes.RecipeInit;
import com.mna.recipes.eldrin.FumeFilterRecipe;
import com.mna.tools.ContainerTools;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.mutable.MutableFloat;

public class EldrinFumeTile
extends WizardLabTile {
    public static final float GENERATION_RATE_PER_TICK = 0.02f;
    public static final int SLOT_FUEL = 0;
    public static final int SLOT_MOTE = 1;
    public static final int INVENTORY_SIZE = 2;
    private float fuelBurnTicks = 0.0f;
    private float moteBurnTicks = 0.0f;
    private float moteBurnTicksRemaining = 0.0f;
    private Affinity selectedAffinity = Affinity.UNKNOWN;
    private float fuelBurnMultiplier = 1.0f;
    private float outputMultiplier = 1.0f;
    private boolean prismUpgrade = false;

    public EldrinFumeTile(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize) {
        super(type, pos, state, inventorySize);
    }

    public EldrinFumeTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.ELDRIN_FUME.get(), pos, state, 2);
    }

    public FuelStatus getFuelValues(Level level, ItemStack stack) {
        Affinity affinity;
        float amount = this.moteBurnTicksRemaining;
        Affinity affinity2 = affinity = amount > 0.0f ? this.selectedAffinity : Affinity.UNKNOWN;
        if (stack.m_41619_()) {
            return new FuelStatus(affinity, amount, false);
        }
        Optional<FumeFilterRecipe> recipe = level.m_7465_().m_44013_((RecipeType)RecipeInit.FUME_FILTER_TYPE.get()).stream().filter(r -> r.matches(ContainerTools.createTemporaryContainer(stack), level)).findFirst();
        if (recipe.isEmpty() || amount > 0.0f && recipe.get().getAffinity() == affinity) {
            return new FuelStatus(affinity, amount, false);
        }
        return new FuelStatus(recipe.get().getAffinity(), recipe.get().getTotalGeneration() / 0.02f, true);
    }

    public void onNeighborChanged() {
        this.calculateMultipliers();
    }

    @Override
    public boolean canActivate(Player player) {
        if (this.isActive()) {
            return false;
        }
        FuelStatus fuelValues = this.getFuelValues(this.f_58857_, this.m_8020_(1));
        if (fuelValues.getAffinity() != Affinity.UNKNOWN && fuelValues.getMoteBurnTime() > 0.0f && ForgeHooks.getBurnTime((ItemStack)this.m_8020_(0), null) > 0) {
            IWorldMagic worldMagic = (IWorldMagic)player.m_9236_().getCapability(WorldMagicProvider.MAGIC).orElse(null);
            if (worldMagic == null) {
                return false;
            }
            IWellspringNodeRegistry wellspringNetwork = worldMagic.getWellspringRegistry();
            if (wellspringNetwork == null) {
                return false;
            }
            HashMap<Affinity, Float> curAmt = wellspringNetwork.getNodeNetworkAmountFor(player.m_20148_(), this.f_58857_);
            return !(curAmt.getOrDefault((Object)fuelValues.getAffinity(), Float.valueOf(0.0f)).floatValue() >= 5000.0f);
        }
        return false;
    }

    @Override
    protected boolean canContinue() {
        return true;
    }

    @Override
    public float getPctComplete() {
        return this.getFuelPctRemaining();
    }

    @Override
    protected boolean canActiveTick() {
        return true;
    }

    @Override
    protected void tickActiveLogic() {
        if (this.moteBurnTicksRemaining > 0.0f) {
            FuelStatus values;
            this.injectPower();
            this.moteBurnTicksRemaining -= 1.0f;
            if (this.moteBurnTicksRemaining < 1.0f && this.itemsPresent() && (values = this.getFuelValues(this.f_58857_, this.m_8020_(1))).isConsumeMote()) {
                this.reactivate(false);
            }
        }
    }

    @Override
    protected void onCraftStart(Player crafter) {
        FuelStatus values;
        ItemStack burnableStack;
        this.calculateMultipliers();
        if (this.getActiveTicks() <= 0) {
            ItemStack potentialFuel = this.m_8020_(0);
            int fuelBurnTicks = ForgeHooks.getBurnTime((ItemStack)potentialFuel, null);
            if (fuelBurnTicks == 0) {
                this.setInactive();
                return;
            }
            this.fuelBurnTicks = (float)fuelBurnTicks / this.fuelBurnMultiplier;
            if (potentialFuel.hasCraftingRemainingItem()) {
                this.m_6836_(0, potentialFuel.getCraftingRemainingItem());
            } else {
                potentialFuel.m_41774_(1);
            }
        }
        if (!(burnableStack = this.m_8020_(1)).m_41619_() && (values = this.getFuelValues(this.f_58857_, burnableStack)).isConsumeMote()) {
            this.selectedAffinity = values.getAffinity();
            this.moteBurnTicksRemaining = this.moteBurnTicks = values.getMoteBurnTime() / this.fuelBurnMultiplier;
            burnableStack.m_41774_(1);
        }
        if (crafter != null && !crafter.m_9236_().m_5776_()) {
            MinecraftForge.EVENT_BUS.post((Event)new GenericProgressionEvent(crafter, ProgressionEventIDs.ELDRIN_FUME_LIT));
            if (crafter instanceof ServerPlayer) {
                CustomAdvancementTriggers.LIGHT_FUME.trigger((ServerPlayer)crafter, this.selectedAffinity);
            }
        }
    }

    private void calculateMultipliers() {
        Direction dir = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        Direction left = dir.m_122428_();
        Direction right = dir.m_122427_();
        BlockState bsLeft = this.f_58857_.m_8055_(this.m_58899_().m_121955_(left.m_122436_()));
        BlockState bsRight = this.f_58857_.m_8055_(this.m_58899_().m_121955_(right.m_122436_()));
        BlockState bsAbove = this.f_58857_.m_8055_(this.m_58899_().m_6630_(2));
        this.prismUpgrade = bsAbove.m_60734_() instanceof FumePrismBlock;
        int numBellows = 0;
        if (bsLeft.m_60734_() instanceof FumeBellowsBlock && bsLeft.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == dir && ((Boolean)bsLeft.m_61143_((Property)FumeBellowsBlock.FUME_RIGHT)).booleanValue()) {
            ++numBellows;
        }
        if (bsRight.m_60734_() instanceof FumeBellowsBlock && bsRight.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == dir && ((Boolean)bsRight.m_61143_((Property)FumeBellowsBlock.FUME_LEFT)).booleanValue()) {
            ++numBellows;
        }
        float prevBurnMultiplier = this.fuelBurnMultiplier;
        if (numBellows == 0) {
            this.fuelBurnMultiplier = 1.0f;
            this.outputMultiplier = 1.0f;
        } else if (numBellows == 1) {
            this.fuelBurnMultiplier = 2.0f;
            this.outputMultiplier = 2.0f;
        } else if (numBellows == 2) {
            this.fuelBurnMultiplier = 5.0f;
            this.outputMultiplier = 5.0f;
        }
        if (this.prismUpgrade) {
            this.outputMultiplier /= 3.0f;
        }
        if (prevBurnMultiplier != this.fuelBurnMultiplier && this.isActive()) {
            this.fuelBurnTicks *= prevBurnMultiplier;
            this.fuelBurnTicks /= this.fuelBurnMultiplier;
            this.moteBurnTicks *= prevBurnMultiplier;
            this.moteBurnTicks /= this.fuelBurnMultiplier;
            this.moteBurnTicksRemaining *= prevBurnMultiplier;
            this.moteBurnTicksRemaining /= this.fuelBurnMultiplier;
        }
    }

    @Override
    protected void onComplete() {
        if ((this.hasStack(0) || this.getFuelPctRemaining() > 0.0f) && (this.hasStack(1) || this.getMotePctRemaining() > 0.0f)) {
            Mote mote;
            Item item;
            ItemStack moteStack = this.m_8020_(1);
            if (!moteStack.m_41619_() && (item = moteStack.m_41720_()) instanceof Mote && this.selectedAffinity != (mote = (Mote)item).getRelatedAffinity()) {
                return;
            }
            this.m_58904_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
                Affinity[] affinities = this.getGeneratingAffinities();
                HashMap<Affinity, Float> nodeNetwork = m.getWellspringRegistry().getNodeNetworkAmountFor(this.getCrafterID(), this.f_58857_);
                for (Affinity affinity : affinities) {
                    if (!(nodeNetwork.getOrDefault((Object)affinity, Float.valueOf(0.0f)).floatValue() < 5000.0f)) continue;
                    this.reactivate();
                    break;
                }
            });
        }
    }

    private void injectPower() {
        if (!this.m_58904_().m_5776_() && this.selectedAffinity != null) {
            this.m_58904_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
                for (Affinity toGenerate : this.getGeneratingAffinities()) {
                    float amount = this.getPowerPerTick(toGenerate);
                    m.getWellspringRegistry().insertPower(this.getCrafterID(), this.f_58857_, toGenerate, amount);
                }
            });
        }
    }

    public float getMotePctRemaining() {
        return this.moteBurnTicksRemaining / this.moteBurnTicks;
    }

    public float getFuelPctRemaining() {
        return (float)this.getActiveTicks() / this.fuelBurnTicks;
    }

    @Override
    protected boolean needsPower() {
        return false;
    }

    public Affinity[] getGeneratingAffinities() {
        if (this.selectedAffinity == Affinity.UNKNOWN) {
            FuelStatus fuelValues = this.getFuelValues(this.f_58857_, this.m_8020_(1));
            this.selectedAffinity = fuelValues.getAffinity();
        }
        if (this.prismUpgrade) {
            return new Affinity[]{this.selectedAffinity, this.selectedAffinity.getAdjacentLeft(), this.selectedAffinity.getAdjacentRight()};
        }
        return new Affinity[]{this.selectedAffinity};
    }

    public float getPowerPerTick(Affinity aff) {
        MutableFloat powerPerTick = new MutableFloat(0.0f);
        this.m_58904_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
            float amount = 0.02f * this.outputMultiplier;
            float multiplier = m.getWellspringRegistry().getEldrinGenerationMultiplierFor(this.getCrafterID(), this.f_58857_, aff);
            powerPerTick.setValue(amount * multiplier);
        });
        return powerPerTick.floatValue();
    }

    private boolean itemsPresent() {
        return this.hasStack(0) && this.hasStack(1);
    }

    @Override
    protected List<Integer> getSyncedInventorySlots() {
        return Arrays.asList(0, 1);
    }

    @Override
    public int[] m_7071_(Direction side) {
        if (side == Direction.UP || side == Direction.DOWN) {
            return new int[]{1};
        }
        return new int[]{0};
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return !this.isActive();
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        ItemStack existing;
        if (index == 1) {
            FuelStatus burnableData = this.getFuelValues(this.f_58857_, stack);
            if (burnableData.getAffinity() == Affinity.UNKNOWN || burnableData.getMoteBurnTime() == 0.0f) {
                return false;
            }
            if (this.isActive() && burnableData.getAffinity() != this.selectedAffinity) {
                return false;
            }
        } else if (index == 0) {
            if (ForgeHooks.getBurnTime((ItemStack)stack, null) == 0) {
                return false;
            }
        } else {
            return false;
        }
        return (existing = this.m_8020_(index)).m_41619_() || existing.m_41613_() < existing.m_41741_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)existing);
    }

    @Override
    protected CompoundTag getMeta() {
        CompoundTag meta = new CompoundTag();
        meta.m_128350_("burnTime", this.fuelBurnTicks);
        meta.m_128350_("moteBurnTime", this.moteBurnTicks);
        meta.m_128350_("moteBurnTimeRemaining", this.moteBurnTicksRemaining);
        meta.m_128405_("affinity", this.selectedAffinity.ordinal());
        meta.m_128350_("fuelMultiplier", this.fuelBurnMultiplier);
        meta.m_128350_("outputMultiplier", this.outputMultiplier);
        meta.m_128379_("prism", this.prismUpgrade);
        return meta;
    }

    @Override
    protected void loadMeta(CompoundTag tag) {
        if (tag.m_128441_("burnTime")) {
            this.fuelBurnTicks = tag.m_128457_("burnTime");
        }
        if (tag.m_128441_("moteBurnTime")) {
            this.moteBurnTicks = tag.m_128457_("moteBurnTime");
        }
        if (tag.m_128441_("moteBurnTimeRemaining")) {
            this.moteBurnTicksRemaining = tag.m_128457_("moteBurnTimeRemaining");
        }
        if (tag.m_128441_("affinity")) {
            this.selectedAffinity = Affinity.values()[tag.m_128451_("affinity")];
        }
        this.fuelBurnMultiplier = tag.m_128441_("fuelMultiplier") ? tag.m_128457_("fuelMultiplier") : 1.0f;
        this.outputMultiplier = tag.m_128441_("outputMultiplier") ? tag.m_128457_("outputMultiplier") : 1.0f;
        this.prismUpgrade = tag.m_128441_("prism") && tag.m_128471_("prism");
    }

    @Override
    protected void tick() {
        super.tick();
        if (this.m_58904_().m_5776_()) {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        if (this.isActive()) {
            int[] color = this.selectedAffinity.getColor();
            float colorMultiplier = 0.25f;
            float secondaryColorMultiplier = 0.075f;
            Vec3 particlePos = Vec3.m_82514_((Vec3i)this.m_58899_(), (double)1.2);
            this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())).setColor((int)((float)color[0] * colorMultiplier), (int)((float)color[1] * colorMultiplier), (int)((float)color[2] * colorMultiplier)), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
            float particleVelocity = 0.01f * this.outputMultiplier;
            if (this.prismUpgrade) {
                particleVelocity *= 3.0f;
            }
            this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())).setColor((int)((float)color[0] * secondaryColorMultiplier), (int)((float)color[1] * secondaryColorMultiplier), (int)((float)color[2] * secondaryColorMultiplier)).setMaxAge(40), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, (double)particleVelocity, 0.0);
        }
    }

    class FuelStatus {
        private Affinity affinity;
        private float moteBurnTime;
        private boolean consumeMote;

        public FuelStatus(Affinity affinity, float moteBurnTime, boolean consumeMote) {
            this.affinity = affinity;
            this.moteBurnTime = moteBurnTime;
            this.consumeMote = consumeMote;
        }

        public Affinity getAffinity() {
            return this.affinity;
        }

        public float getMoteBurnTime() {
            return this.moteBurnTime;
        }

        public boolean isConsumeMote() {
            return this.consumeMote;
        }
    }
}

