/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.wizard_lab;

import com.mna.api.sound.SFX;
import com.mna.blocks.artifice.FumeBellowsBlock;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.blocks.tileentities.wizard_lab.EldrinFumeTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FumeBellowsTile
extends BlockEntity
implements GeoBlockEntity,
AnimationController.SoundKeyframeHandler<FumeBellowsTile> {
    protected static final RawAnimation BELLOW = RawAnimation.begin().thenLoop("animation.fume_filter_bellows.bellow");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FumeBellowsTile(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)TileEntityInit.FUME_BELLOWS.get(), pPos, pBlockState);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, this::animationControl);
        controller.setSoundKeyframeHandler((AnimationController.SoundKeyframeHandler)this);
        controllers.add(new AnimationController[]{controller});
    }

    protected <E extends FumeBellowsTile> PlayState animationControl(AnimationState<E> state) {
        if (this.isModifiedFumeActive()) {
            return state.setAndContinue(BELLOW);
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isModifiedFumeActive() {
        BlockPos leftOffset;
        BlockEntity leftEntity;
        BlockState state = this.m_58900_();
        BlockPos pos = this.m_58899_();
        Direction dir = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        if (((Boolean)state.m_61143_((Property)FumeBellowsBlock.FUME_RIGHT)).booleanValue()) {
            BlockPos rightOffset = pos.m_121955_(dir.m_122427_().m_122436_());
            BlockEntity rightEntity = this.f_58857_.m_7702_(rightOffset);
            if (rightEntity != null && rightEntity instanceof EldrinFumeTile) {
                EldrinFumeTile fume = (EldrinFumeTile)rightEntity;
                return fume.isActive();
            }
        } else if (((Boolean)state.m_61143_((Property)FumeBellowsBlock.FUME_LEFT)).booleanValue() && (leftEntity = this.f_58857_.m_7702_(leftOffset = pos.m_121955_(dir.m_122428_().m_122436_()))) != null && leftEntity instanceof EldrinFumeTile) {
            EldrinFumeTile fume = (EldrinFumeTile)leftEntity;
            return fume.isActive();
        }
        return false;
    }

    public void handle(SoundKeyframeEvent<FumeBellowsTile> event) {
        if (event.getKeyframeData().getSound().equals("bellow")) {
            BlockPos pos = this.m_58899_();
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = pos.m_123342_();
            double d2 = (double)pos.m_123343_() + 0.5;
            this.f_58857_.m_7785_(d0, d1, d2, SFX.Block.FUME_BELLOWS, SoundSource.BLOCKS, 0.25f, 1.0f, false);
        }
    }
}

